/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteEvaluationJobRequest extends BedrockRequest implements
        ToCopyableBuilder<BatchDeleteEvaluationJobRequest.Builder, BatchDeleteEvaluationJobRequest> {
    private static final SdkField<List<String>> JOB_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("jobIdentifiers")
            .getter(getter(BatchDeleteEvaluationJobRequest::jobIdentifiers))
            .setter(setter(Builder::jobIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_IDENTIFIERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> jobIdentifiers;

    private BatchDeleteEvaluationJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobIdentifiers = builder.jobIdentifiers;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobIdentifiers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasJobIdentifiers() {
        return jobIdentifiers != null && !(jobIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of one or more evaluation job Amazon Resource Names (ARNs) you want to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobIdentifiers} method.
     * </p>
     * 
     * @return A list of one or more evaluation job Amazon Resource Names (ARNs) you want to delete.
     */
    public final List<String> jobIdentifiers() {
        return jobIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasJobIdentifiers() ? jobIdentifiers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteEvaluationJobRequest)) {
            return false;
        }
        BatchDeleteEvaluationJobRequest other = (BatchDeleteEvaluationJobRequest) obj;
        return hasJobIdentifiers() == other.hasJobIdentifiers() && Objects.equals(jobIdentifiers(), other.jobIdentifiers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteEvaluationJobRequest")
                .add("JobIdentifiers", jobIdentifiers() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobIdentifiers":
            return Optional.ofNullable(clazz.cast(jobIdentifiers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobIdentifiers", JOB_IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteEvaluationJobRequest, T> g) {
        return obj -> g.apply((BatchDeleteEvaluationJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchDeleteEvaluationJobRequest> {
        /**
         * <p>
         * A list of one or more evaluation job Amazon Resource Names (ARNs) you want to delete.
         * </p>
         * 
         * @param jobIdentifiers
         *        A list of one or more evaluation job Amazon Resource Names (ARNs) you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobIdentifiers(Collection<String> jobIdentifiers);

        /**
         * <p>
         * A list of one or more evaluation job Amazon Resource Names (ARNs) you want to delete.
         * </p>
         * 
         * @param jobIdentifiers
         *        A list of one or more evaluation job Amazon Resource Names (ARNs) you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobIdentifiers(String... jobIdentifiers);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private List<String> jobIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteEvaluationJobRequest model) {
            super(model);
            jobIdentifiers(model.jobIdentifiers);
        }

        public final Collection<String> getJobIdentifiers() {
            if (jobIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return jobIdentifiers;
        }

        public final void setJobIdentifiers(Collection<String> jobIdentifiers) {
            this.jobIdentifiers = EvaluationJobIdentifiersCopier.copy(jobIdentifiers);
        }

        @Override
        public final Builder jobIdentifiers(Collection<String> jobIdentifiers) {
            this.jobIdentifiers = EvaluationJobIdentifiersCopier.copy(jobIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobIdentifiers(String... jobIdentifiers) {
            jobIdentifiers(Arrays.asList(jobIdentifiers));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteEvaluationJobRequest build() {
            return new BatchDeleteEvaluationJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
