/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An annotation for modifying an existing custom type in an Automated Reasoning policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyUpdateTypeAnnotation implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyUpdateTypeAnnotation.Builder, AutomatedReasoningPolicyUpdateTypeAnnotation> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AutomatedReasoningPolicyUpdateTypeAnnotation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> NEW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("newName").getter(getter(AutomatedReasoningPolicyUpdateTypeAnnotation::newName))
            .setter(setter(Builder::newName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AutomatedReasoningPolicyUpdateTypeAnnotation::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<AutomatedReasoningPolicyTypeValueAnnotation>> VALUES_FIELD = SdkField
            .<List<AutomatedReasoningPolicyTypeValueAnnotation>> builder(MarshallingType.LIST)
            .memberName("values")
            .getter(getter(AutomatedReasoningPolicyUpdateTypeAnnotation::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomatedReasoningPolicyTypeValueAnnotation> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomatedReasoningPolicyTypeValueAnnotation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, NEW_NAME_FIELD,
            DESCRIPTION_FIELD, VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String newName;

    private final String description;

    private final List<AutomatedReasoningPolicyTypeValueAnnotation> values;

    private AutomatedReasoningPolicyUpdateTypeAnnotation(BuilderImpl builder) {
        this.name = builder.name;
        this.newName = builder.newName;
        this.description = builder.description;
        this.values = builder.values;
    }

    /**
     * <p>
     * The current name of the custom type to update.
     * </p>
     * 
     * @return The current name of the custom type to update.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The new name for the custom type, if you want to rename it. If not provided, the name remains unchanged.
     * </p>
     * 
     * @return The new name for the custom type, if you want to rename it. If not provided, the name remains unchanged.
     */
    public final String newName() {
        return newName;
    }

    /**
     * <p>
     * The new description for the custom type, replacing the previous description.
     * </p>
     * 
     * @return The new description for the custom type, replacing the previous description.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The updated list of values for the custom type, which can include additions, modifications, or removals.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The updated list of values for the custom type, which can include additions, modifications, or removals.
     */
    public final List<AutomatedReasoningPolicyTypeValueAnnotation> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(newName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyUpdateTypeAnnotation)) {
            return false;
        }
        AutomatedReasoningPolicyUpdateTypeAnnotation other = (AutomatedReasoningPolicyUpdateTypeAnnotation) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(newName(), other.newName())
                && Objects.equals(description(), other.description()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyUpdateTypeAnnotation")
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NewName", newName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Values", hasValues() ? values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "newName":
            return Optional.ofNullable(clazz.cast(newName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("newName", NEW_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("values", VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyUpdateTypeAnnotation, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyUpdateTypeAnnotation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyUpdateTypeAnnotation> {
        /**
         * <p>
         * The current name of the custom type to update.
         * </p>
         * 
         * @param name
         *        The current name of the custom type to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The new name for the custom type, if you want to rename it. If not provided, the name remains unchanged.
         * </p>
         * 
         * @param newName
         *        The new name for the custom type, if you want to rename it. If not provided, the name remains
         *        unchanged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newName(String newName);

        /**
         * <p>
         * The new description for the custom type, replacing the previous description.
         * </p>
         * 
         * @param description
         *        The new description for the custom type, replacing the previous description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The updated list of values for the custom type, which can include additions, modifications, or removals.
         * </p>
         * 
         * @param values
         *        The updated list of values for the custom type, which can include additions, modifications, or
         *        removals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<AutomatedReasoningPolicyTypeValueAnnotation> values);

        /**
         * <p>
         * The updated list of values for the custom type, which can include additions, modifications, or removals.
         * </p>
         * 
         * @param values
         *        The updated list of values for the custom type, which can include additions, modifications, or
         *        removals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(AutomatedReasoningPolicyTypeValueAnnotation... values);

        /**
         * <p>
         * The updated list of values for the custom type, which can include additions, modifications, or removals.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyTypeValueAnnotation.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyTypeValueAnnotation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyTypeValueAnnotation.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #values(List<AutomatedReasoningPolicyTypeValueAnnotation>)}.
         * 
         * @param values
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyTypeValueAnnotation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(java.util.Collection<AutomatedReasoningPolicyTypeValueAnnotation>)
         */
        Builder values(Consumer<AutomatedReasoningPolicyTypeValueAnnotation.Builder>... values);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String newName;

        private String description;

        private List<AutomatedReasoningPolicyTypeValueAnnotation> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyUpdateTypeAnnotation model) {
            name(model.name);
            newName(model.newName);
            description(model.description);
            values(model.values);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNewName() {
            return newName;
        }

        public final void setNewName(String newName) {
            this.newName = newName;
        }

        @Override
        public final Builder newName(String newName) {
            this.newName = newName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<AutomatedReasoningPolicyTypeValueAnnotation.Builder> getValues() {
            List<AutomatedReasoningPolicyTypeValueAnnotation.Builder> result = AutomatedReasoningPolicyTypeValueAnnotationListCopier
                    .copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<AutomatedReasoningPolicyTypeValueAnnotation.BuilderImpl> values) {
            this.values = AutomatedReasoningPolicyTypeValueAnnotationListCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<AutomatedReasoningPolicyTypeValueAnnotation> values) {
            this.values = AutomatedReasoningPolicyTypeValueAnnotationListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(AutomatedReasoningPolicyTypeValueAnnotation... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<AutomatedReasoningPolicyTypeValueAnnotation.Builder>... values) {
            values(Stream.of(values).map(c -> AutomatedReasoningPolicyTypeValueAnnotation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AutomatedReasoningPolicyUpdateTypeAnnotation build() {
            return new AutomatedReasoningPolicyUpdateTypeAnnotation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
