/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a comprehensive test suite generated by the build workflow, providing validation capabilities for automated
 * reasoning policies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyGeneratedTestCases implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyGeneratedTestCases.Builder, AutomatedReasoningPolicyGeneratedTestCases> {
    private static final SdkField<List<AutomatedReasoningPolicyGeneratedTestCase>> GENERATED_TEST_CASES_FIELD = SdkField
            .<List<AutomatedReasoningPolicyGeneratedTestCase>> builder(MarshallingType.LIST)
            .memberName("generatedTestCases")
            .getter(getter(AutomatedReasoningPolicyGeneratedTestCases::generatedTestCases))
            .setter(setter(Builder::generatedTestCases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedTestCases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomatedReasoningPolicyGeneratedTestCase> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomatedReasoningPolicyGeneratedTestCase::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATED_TEST_CASES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AutomatedReasoningPolicyGeneratedTestCase> generatedTestCases;

    private AutomatedReasoningPolicyGeneratedTestCases(BuilderImpl builder) {
        this.generatedTestCases = builder.generatedTestCases;
    }

    /**
     * For responses, this returns true if the service returned a value for the GeneratedTestCases property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGeneratedTestCases() {
        return generatedTestCases != null && !(generatedTestCases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents a collection of generated test cases.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGeneratedTestCases} method.
     * </p>
     * 
     * @return Represents a collection of generated test cases.
     */
    public final List<AutomatedReasoningPolicyGeneratedTestCase> generatedTestCases() {
        return generatedTestCases;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasGeneratedTestCases() ? generatedTestCases() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyGeneratedTestCases)) {
            return false;
        }
        AutomatedReasoningPolicyGeneratedTestCases other = (AutomatedReasoningPolicyGeneratedTestCases) obj;
        return hasGeneratedTestCases() == other.hasGeneratedTestCases()
                && Objects.equals(generatedTestCases(), other.generatedTestCases());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyGeneratedTestCases")
                .add("GeneratedTestCases", hasGeneratedTestCases() ? generatedTestCases() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "generatedTestCases":
            return Optional.ofNullable(clazz.cast(generatedTestCases()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("generatedTestCases", GENERATED_TEST_CASES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyGeneratedTestCases, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyGeneratedTestCases) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyGeneratedTestCases> {
        /**
         * <p>
         * Represents a collection of generated test cases.
         * </p>
         * 
         * @param generatedTestCases
         *        Represents a collection of generated test cases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedTestCases(Collection<AutomatedReasoningPolicyGeneratedTestCase> generatedTestCases);

        /**
         * <p>
         * Represents a collection of generated test cases.
         * </p>
         * 
         * @param generatedTestCases
         *        Represents a collection of generated test cases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedTestCases(AutomatedReasoningPolicyGeneratedTestCase... generatedTestCases);

        /**
         * <p>
         * Represents a collection of generated test cases.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyGeneratedTestCase.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyGeneratedTestCase#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyGeneratedTestCase.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #generatedTestCases(List<AutomatedReasoningPolicyGeneratedTestCase>)}.
         * 
         * @param generatedTestCases
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyGeneratedTestCase.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generatedTestCases(java.util.Collection<AutomatedReasoningPolicyGeneratedTestCase>)
         */
        Builder generatedTestCases(Consumer<AutomatedReasoningPolicyGeneratedTestCase.Builder>... generatedTestCases);
    }

    static final class BuilderImpl implements Builder {
        private List<AutomatedReasoningPolicyGeneratedTestCase> generatedTestCases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyGeneratedTestCases model) {
            generatedTestCases(model.generatedTestCases);
        }

        public final List<AutomatedReasoningPolicyGeneratedTestCase.Builder> getGeneratedTestCases() {
            List<AutomatedReasoningPolicyGeneratedTestCase.Builder> result = AutomatedReasoningPolicyGeneratedTestCaseListCopier
                    .copyToBuilder(this.generatedTestCases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGeneratedTestCases(
                Collection<AutomatedReasoningPolicyGeneratedTestCase.BuilderImpl> generatedTestCases) {
            this.generatedTestCases = AutomatedReasoningPolicyGeneratedTestCaseListCopier.copyFromBuilder(generatedTestCases);
        }

        @Override
        public final Builder generatedTestCases(Collection<AutomatedReasoningPolicyGeneratedTestCase> generatedTestCases) {
            this.generatedTestCases = AutomatedReasoningPolicyGeneratedTestCaseListCopier.copy(generatedTestCases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generatedTestCases(AutomatedReasoningPolicyGeneratedTestCase... generatedTestCases) {
            generatedTestCases(Arrays.asList(generatedTestCases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generatedTestCases(Consumer<AutomatedReasoningPolicyGeneratedTestCase.Builder>... generatedTestCases) {
            generatedTestCases(Stream.of(generatedTestCases)
                    .map(c -> AutomatedReasoningPolicyGeneratedTestCase.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AutomatedReasoningPolicyGeneratedTestCases build() {
            return new AutomatedReasoningPolicyGeneratedTestCases(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
