/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a generated test case, consisting of query content, guard content, and expected results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyGeneratedTestCase implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyGeneratedTestCase.Builder, AutomatedReasoningPolicyGeneratedTestCase> {
    private static final SdkField<String> QUERY_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryContent").getter(getter(AutomatedReasoningPolicyGeneratedTestCase::queryContent))
            .setter(setter(Builder::queryContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryContent").build()).build();

    private static final SdkField<String> GUARD_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("guardContent").getter(getter(AutomatedReasoningPolicyGeneratedTestCase::guardContent))
            .setter(setter(Builder::guardContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardContent").build()).build();

    private static final SdkField<String> EXPECTED_AGGREGATED_FINDINGS_RESULT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("expectedAggregatedFindingsResult")
            .getter(getter(AutomatedReasoningPolicyGeneratedTestCase::expectedAggregatedFindingsResultAsString))
            .setter(setter(Builder::expectedAggregatedFindingsResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedAggregatedFindingsResult")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_CONTENT_FIELD,
            GUARD_CONTENT_FIELD, EXPECTED_AGGREGATED_FINDINGS_RESULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String queryContent;

    private final String guardContent;

    private final String expectedAggregatedFindingsResult;

    private AutomatedReasoningPolicyGeneratedTestCase(BuilderImpl builder) {
        this.queryContent = builder.queryContent;
        this.guardContent = builder.guardContent;
        this.expectedAggregatedFindingsResult = builder.expectedAggregatedFindingsResult;
    }

    /**
     * <p>
     * The input query or prompt that generated the content. This provides context for the validation.
     * </p>
     * 
     * @return The input query or prompt that generated the content. This provides context for the validation.
     */
    public final String queryContent() {
        return queryContent;
    }

    /**
     * <p>
     * The output content that's validated by the Automated Reasoning policy. This represents the foundation model
     * response that will be checked for accuracy.
     * </p>
     * 
     * @return The output content that's validated by the Automated Reasoning policy. This represents the foundation
     *         model response that will be checked for accuracy.
     */
    public final String guardContent() {
        return guardContent;
    }

    /**
     * <p>
     * The expected results of the generated test case. Possible values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>VALID</code> - The claims are true. The claims are implied by the premises and the Automated Reasoning
     * policy. Given the Automated Reasoning policy and premises, it is not possible for these claims to be false. In
     * other words, there are no alternative answers that are true that contradict the claims.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INVALID</code> - The claims are false. The claims are not implied by the premises and Automated Reasoning
     * policy. Furthermore, there exists different claims that are consistent with the premises and Automated Reasoning
     * policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SATISFIABLE</code> - The claims can be true or false. It depends on what assumptions are made for the claim
     * to be implied from the premises and Automated Reasoning policy rules. In this situation, different assumptions
     * can make input claims false and alternative claims true.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMPOSSIBLE</code> - Automated Reasoning can’t make a statement about the claims. This can happen if the
     * premises are logically incorrect, or if there is a conflict within the Automated Reasoning policy itself.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #expectedAggregatedFindingsResult} will return
     * {@link AutomatedReasoningCheckResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #expectedAggregatedFindingsResultAsString}.
     * </p>
     * 
     * @return The expected results of the generated test case. Possible values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>VALID</code> - The claims are true. The claims are implied by the premises and the Automated
     *         Reasoning policy. Given the Automated Reasoning policy and premises, it is not possible for these claims
     *         to be false. In other words, there are no alternative answers that are true that contradict the claims.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INVALID</code> - The claims are false. The claims are not implied by the premises and Automated
     *         Reasoning policy. Furthermore, there exists different claims that are consistent with the premises and
     *         Automated Reasoning policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SATISFIABLE</code> - The claims can be true or false. It depends on what assumptions are made for
     *         the claim to be implied from the premises and Automated Reasoning policy rules. In this situation,
     *         different assumptions can make input claims false and alternative claims true.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IMPOSSIBLE</code> - Automated Reasoning can’t make a statement about the claims. This can happen if
     *         the premises are logically incorrect, or if there is a conflict within the Automated Reasoning policy
     *         itself.
     *         </p>
     *         </li>
     * @see AutomatedReasoningCheckResult
     */
    public final AutomatedReasoningCheckResult expectedAggregatedFindingsResult() {
        return AutomatedReasoningCheckResult.fromValue(expectedAggregatedFindingsResult);
    }

    /**
     * <p>
     * The expected results of the generated test case. Possible values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>VALID</code> - The claims are true. The claims are implied by the premises and the Automated Reasoning
     * policy. Given the Automated Reasoning policy and premises, it is not possible for these claims to be false. In
     * other words, there are no alternative answers that are true that contradict the claims.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INVALID</code> - The claims are false. The claims are not implied by the premises and Automated Reasoning
     * policy. Furthermore, there exists different claims that are consistent with the premises and Automated Reasoning
     * policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SATISFIABLE</code> - The claims can be true or false. It depends on what assumptions are made for the claim
     * to be implied from the premises and Automated Reasoning policy rules. In this situation, different assumptions
     * can make input claims false and alternative claims true.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMPOSSIBLE</code> - Automated Reasoning can’t make a statement about the claims. This can happen if the
     * premises are logically incorrect, or if there is a conflict within the Automated Reasoning policy itself.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #expectedAggregatedFindingsResult} will return
     * {@link AutomatedReasoningCheckResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #expectedAggregatedFindingsResultAsString}.
     * </p>
     * 
     * @return The expected results of the generated test case. Possible values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>VALID</code> - The claims are true. The claims are implied by the premises and the Automated
     *         Reasoning policy. Given the Automated Reasoning policy and premises, it is not possible for these claims
     *         to be false. In other words, there are no alternative answers that are true that contradict the claims.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INVALID</code> - The claims are false. The claims are not implied by the premises and Automated
     *         Reasoning policy. Furthermore, there exists different claims that are consistent with the premises and
     *         Automated Reasoning policy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SATISFIABLE</code> - The claims can be true or false. It depends on what assumptions are made for
     *         the claim to be implied from the premises and Automated Reasoning policy rules. In this situation,
     *         different assumptions can make input claims false and alternative claims true.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IMPOSSIBLE</code> - Automated Reasoning can’t make a statement about the claims. This can happen if
     *         the premises are logically incorrect, or if there is a conflict within the Automated Reasoning policy
     *         itself.
     *         </p>
     *         </li>
     * @see AutomatedReasoningCheckResult
     */
    public final String expectedAggregatedFindingsResultAsString() {
        return expectedAggregatedFindingsResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queryContent());
        hashCode = 31 * hashCode + Objects.hashCode(guardContent());
        hashCode = 31 * hashCode + Objects.hashCode(expectedAggregatedFindingsResultAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyGeneratedTestCase)) {
            return false;
        }
        AutomatedReasoningPolicyGeneratedTestCase other = (AutomatedReasoningPolicyGeneratedTestCase) obj;
        return Objects.equals(queryContent(), other.queryContent()) && Objects.equals(guardContent(), other.guardContent())
                && Objects.equals(expectedAggregatedFindingsResultAsString(), other.expectedAggregatedFindingsResultAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyGeneratedTestCase")
                .add("QueryContent", queryContent() == null ? null : "*** Sensitive Data Redacted ***")
                .add("GuardContent", guardContent() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ExpectedAggregatedFindingsResult", expectedAggregatedFindingsResultAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queryContent":
            return Optional.ofNullable(clazz.cast(queryContent()));
        case "guardContent":
            return Optional.ofNullable(clazz.cast(guardContent()));
        case "expectedAggregatedFindingsResult":
            return Optional.ofNullable(clazz.cast(expectedAggregatedFindingsResultAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("queryContent", QUERY_CONTENT_FIELD);
        map.put("guardContent", GUARD_CONTENT_FIELD);
        map.put("expectedAggregatedFindingsResult", EXPECTED_AGGREGATED_FINDINGS_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyGeneratedTestCase, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyGeneratedTestCase) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyGeneratedTestCase> {
        /**
         * <p>
         * The input query or prompt that generated the content. This provides context for the validation.
         * </p>
         * 
         * @param queryContent
         *        The input query or prompt that generated the content. This provides context for the validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryContent(String queryContent);

        /**
         * <p>
         * The output content that's validated by the Automated Reasoning policy. This represents the foundation model
         * response that will be checked for accuracy.
         * </p>
         * 
         * @param guardContent
         *        The output content that's validated by the Automated Reasoning policy. This represents the foundation
         *        model response that will be checked for accuracy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardContent(String guardContent);

        /**
         * <p>
         * The expected results of the generated test case. Possible values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>VALID</code> - The claims are true. The claims are implied by the premises and the Automated Reasoning
         * policy. Given the Automated Reasoning policy and premises, it is not possible for these claims to be false.
         * In other words, there are no alternative answers that are true that contradict the claims.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INVALID</code> - The claims are false. The claims are not implied by the premises and Automated
         * Reasoning policy. Furthermore, there exists different claims that are consistent with the premises and
         * Automated Reasoning policy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SATISFIABLE</code> - The claims can be true or false. It depends on what assumptions are made for the
         * claim to be implied from the premises and Automated Reasoning policy rules. In this situation, different
         * assumptions can make input claims false and alternative claims true.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IMPOSSIBLE</code> - Automated Reasoning can’t make a statement about the claims. This can happen if the
         * premises are logically incorrect, or if there is a conflict within the Automated Reasoning policy itself.
         * </p>
         * </li>
         * </ul>
         * 
         * @param expectedAggregatedFindingsResult
         *        The expected results of the generated test case. Possible values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>VALID</code> - The claims are true. The claims are implied by the premises and the Automated
         *        Reasoning policy. Given the Automated Reasoning policy and premises, it is not possible for these
         *        claims to be false. In other words, there are no alternative answers that are true that contradict the
         *        claims.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INVALID</code> - The claims are false. The claims are not implied by the premises and Automated
         *        Reasoning policy. Furthermore, there exists different claims that are consistent with the premises and
         *        Automated Reasoning policy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SATISFIABLE</code> - The claims can be true or false. It depends on what assumptions are made
         *        for the claim to be implied from the premises and Automated Reasoning policy rules. In this situation,
         *        different assumptions can make input claims false and alternative claims true.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IMPOSSIBLE</code> - Automated Reasoning can’t make a statement about the claims. This can happen
         *        if the premises are logically incorrect, or if there is a conflict within the Automated Reasoning
         *        policy itself.
         *        </p>
         *        </li>
         * @see AutomatedReasoningCheckResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedReasoningCheckResult
         */
        Builder expectedAggregatedFindingsResult(String expectedAggregatedFindingsResult);

        /**
         * <p>
         * The expected results of the generated test case. Possible values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>VALID</code> - The claims are true. The claims are implied by the premises and the Automated Reasoning
         * policy. Given the Automated Reasoning policy and premises, it is not possible for these claims to be false.
         * In other words, there are no alternative answers that are true that contradict the claims.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INVALID</code> - The claims are false. The claims are not implied by the premises and Automated
         * Reasoning policy. Furthermore, there exists different claims that are consistent with the premises and
         * Automated Reasoning policy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SATISFIABLE</code> - The claims can be true or false. It depends on what assumptions are made for the
         * claim to be implied from the premises and Automated Reasoning policy rules. In this situation, different
         * assumptions can make input claims false and alternative claims true.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IMPOSSIBLE</code> - Automated Reasoning can’t make a statement about the claims. This can happen if the
         * premises are logically incorrect, or if there is a conflict within the Automated Reasoning policy itself.
         * </p>
         * </li>
         * </ul>
         * 
         * @param expectedAggregatedFindingsResult
         *        The expected results of the generated test case. Possible values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>VALID</code> - The claims are true. The claims are implied by the premises and the Automated
         *        Reasoning policy. Given the Automated Reasoning policy and premises, it is not possible for these
         *        claims to be false. In other words, there are no alternative answers that are true that contradict the
         *        claims.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INVALID</code> - The claims are false. The claims are not implied by the premises and Automated
         *        Reasoning policy. Furthermore, there exists different claims that are consistent with the premises and
         *        Automated Reasoning policy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SATISFIABLE</code> - The claims can be true or false. It depends on what assumptions are made
         *        for the claim to be implied from the premises and Automated Reasoning policy rules. In this situation,
         *        different assumptions can make input claims false and alternative claims true.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IMPOSSIBLE</code> - Automated Reasoning can’t make a statement about the claims. This can happen
         *        if the premises are logically incorrect, or if there is a conflict within the Automated Reasoning
         *        policy itself.
         *        </p>
         *        </li>
         * @see AutomatedReasoningCheckResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedReasoningCheckResult
         */
        Builder expectedAggregatedFindingsResult(AutomatedReasoningCheckResult expectedAggregatedFindingsResult);
    }

    static final class BuilderImpl implements Builder {
        private String queryContent;

        private String guardContent;

        private String expectedAggregatedFindingsResult;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyGeneratedTestCase model) {
            queryContent(model.queryContent);
            guardContent(model.guardContent);
            expectedAggregatedFindingsResult(model.expectedAggregatedFindingsResult);
        }

        public final String getQueryContent() {
            return queryContent;
        }

        public final void setQueryContent(String queryContent) {
            this.queryContent = queryContent;
        }

        @Override
        public final Builder queryContent(String queryContent) {
            this.queryContent = queryContent;
            return this;
        }

        public final String getGuardContent() {
            return guardContent;
        }

        public final void setGuardContent(String guardContent) {
            this.guardContent = guardContent;
        }

        @Override
        public final Builder guardContent(String guardContent) {
            this.guardContent = guardContent;
            return this;
        }

        public final String getExpectedAggregatedFindingsResult() {
            return expectedAggregatedFindingsResult;
        }

        public final void setExpectedAggregatedFindingsResult(String expectedAggregatedFindingsResult) {
            this.expectedAggregatedFindingsResult = expectedAggregatedFindingsResult;
        }

        @Override
        public final Builder expectedAggregatedFindingsResult(String expectedAggregatedFindingsResult) {
            this.expectedAggregatedFindingsResult = expectedAggregatedFindingsResult;
            return this;
        }

        @Override
        public final Builder expectedAggregatedFindingsResult(AutomatedReasoningCheckResult expectedAggregatedFindingsResult) {
            this.expectedAggregatedFindingsResult(expectedAggregatedFindingsResult == null ? null
                    : expectedAggregatedFindingsResult.toString());
            return this;
        }

        @Override
        public AutomatedReasoningPolicyGeneratedTestCase build() {
            return new AutomatedReasoningPolicyGeneratedTestCase(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
