/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a set of rules that operate on completely separate variables, indicating they address different concerns
 * or domains within the policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyDisjointRuleSet implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyDisjointRuleSet.Builder, AutomatedReasoningPolicyDisjointRuleSet> {
    private static final SdkField<List<String>> VARIABLES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("variables")
            .getter(getter(AutomatedReasoningPolicyDisjointRuleSet::variables))
            .setter(setter(Builder::variables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RULES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("rules")
            .getter(getter(AutomatedReasoningPolicyDisjointRuleSet::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIABLES_FIELD, RULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> variables;

    private final List<String> rules;

    private AutomatedReasoningPolicyDisjointRuleSet(BuilderImpl builder) {
        this.variables = builder.variables;
        this.rules = builder.rules;
    }

    /**
     * For responses, this returns true if the service returned a value for the Variables property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVariables() {
        return variables != null && !(variables instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The set of variables that are used by the rules in this disjoint set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVariables} method.
     * </p>
     * 
     * @return The set of variables that are used by the rules in this disjoint set.
     */
    public final List<String> variables() {
        return variables;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of rules that form this disjoint set, all operating on the same set of variables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return The list of rules that form this disjoint set, all operating on the same set of variables.
     */
    public final List<String> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasVariables() ? variables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyDisjointRuleSet)) {
            return false;
        }
        AutomatedReasoningPolicyDisjointRuleSet other = (AutomatedReasoningPolicyDisjointRuleSet) obj;
        return hasVariables() == other.hasVariables() && Objects.equals(variables(), other.variables())
                && hasRules() == other.hasRules() && Objects.equals(rules(), other.rules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyDisjointRuleSet")
                .add("Variables", variables() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Rules", hasRules() ? rules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "variables":
            return Optional.ofNullable(clazz.cast(variables()));
        case "rules":
            return Optional.ofNullable(clazz.cast(rules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("variables", VARIABLES_FIELD);
        map.put("rules", RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyDisjointRuleSet, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyDisjointRuleSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyDisjointRuleSet> {
        /**
         * <p>
         * The set of variables that are used by the rules in this disjoint set.
         * </p>
         * 
         * @param variables
         *        The set of variables that are used by the rules in this disjoint set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variables(Collection<String> variables);

        /**
         * <p>
         * The set of variables that are used by the rules in this disjoint set.
         * </p>
         * 
         * @param variables
         *        The set of variables that are used by the rules in this disjoint set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variables(String... variables);

        /**
         * <p>
         * The list of rules that form this disjoint set, all operating on the same set of variables.
         * </p>
         * 
         * @param rules
         *        The list of rules that form this disjoint set, all operating on the same set of variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<String> rules);

        /**
         * <p>
         * The list of rules that form this disjoint set, all operating on the same set of variables.
         * </p>
         * 
         * @param rules
         *        The list of rules that form this disjoint set, all operating on the same set of variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(String... rules);
    }

    static final class BuilderImpl implements Builder {
        private List<String> variables = DefaultSdkAutoConstructList.getInstance();

        private List<String> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyDisjointRuleSet model) {
            variables(model.variables);
            rules(model.rules);
        }

        public final Collection<String> getVariables() {
            if (variables instanceof SdkAutoConstructList) {
                return null;
            }
            return variables;
        }

        public final void setVariables(Collection<String> variables) {
            this.variables = AutomatedReasoningPolicyDefinitionVariableNameListCopier.copy(variables);
        }

        @Override
        public final Builder variables(Collection<String> variables) {
            this.variables = AutomatedReasoningPolicyDefinitionVariableNameListCopier.copy(variables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(String... variables) {
            variables(Arrays.asList(variables));
            return this;
        }

        public final Collection<String> getRules() {
            if (rules instanceof SdkAutoConstructList) {
                return null;
            }
            return rules;
        }

        public final void setRules(Collection<String> rules) {
            this.rules = AutomatedReasoningPolicyDisjointedRuleIdListCopier.copy(rules);
        }

        @Override
        public final Builder rules(Collection<String> rules) {
            this.rules = AutomatedReasoningPolicyDisjointedRuleIdListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(String... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        public AutomatedReasoningPolicyDisjointRuleSet build() {
            return new AutomatedReasoningPolicyDisjointRuleSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
