/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a source document used in the policy build workflow, containing the content and metadata needed for policy
 * generation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningPolicyBuildWorkflowDocument implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningPolicyBuildWorkflowDocument.Builder, AutomatedReasoningPolicyBuildWorkflowDocument> {
    private static final SdkField<SdkBytes> DOCUMENT_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("document").getter(getter(AutomatedReasoningPolicyBuildWorkflowDocument::document))
            .setter(setter(Builder::document))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()).build();

    private static final SdkField<String> DOCUMENT_CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentContentType")
            .getter(getter(AutomatedReasoningPolicyBuildWorkflowDocument::documentContentTypeAsString))
            .setter(setter(Builder::documentContentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentContentType").build())
            .build();

    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentName").getter(getter(AutomatedReasoningPolicyBuildWorkflowDocument::documentName))
            .setter(setter(Builder::documentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentName").build()).build();

    private static final SdkField<String> DOCUMENT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentDescription").getter(getter(AutomatedReasoningPolicyBuildWorkflowDocument::documentDescription))
            .setter(setter(Builder::documentDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_FIELD,
            DOCUMENT_CONTENT_TYPE_FIELD, DOCUMENT_NAME_FIELD, DOCUMENT_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SdkBytes document;

    private final String documentContentType;

    private final String documentName;

    private final String documentDescription;

    private AutomatedReasoningPolicyBuildWorkflowDocument(BuilderImpl builder) {
        this.document = builder.document;
        this.documentContentType = builder.documentContentType;
        this.documentName = builder.documentName;
        this.documentDescription = builder.documentDescription;
    }

    /**
     * <p>
     * The actual content of the source document that will be analyzed to extract policy rules and concepts.
     * </p>
     * 
     * @return The actual content of the source document that will be analyzed to extract policy rules and concepts.
     */
    public final SdkBytes document() {
        return document;
    }

    /**
     * <p>
     * The MIME type of the document content (e.g., text/plain, application/pdf, text/markdown).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #documentContentType} will return
     * {@link AutomatedReasoningPolicyBuildDocumentContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #documentContentTypeAsString}.
     * </p>
     * 
     * @return The MIME type of the document content (e.g., text/plain, application/pdf, text/markdown).
     * @see AutomatedReasoningPolicyBuildDocumentContentType
     */
    public final AutomatedReasoningPolicyBuildDocumentContentType documentContentType() {
        return AutomatedReasoningPolicyBuildDocumentContentType.fromValue(documentContentType);
    }

    /**
     * <p>
     * The MIME type of the document content (e.g., text/plain, application/pdf, text/markdown).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #documentContentType} will return
     * {@link AutomatedReasoningPolicyBuildDocumentContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #documentContentTypeAsString}.
     * </p>
     * 
     * @return The MIME type of the document content (e.g., text/plain, application/pdf, text/markdown).
     * @see AutomatedReasoningPolicyBuildDocumentContentType
     */
    public final String documentContentTypeAsString() {
        return documentContentType;
    }

    /**
     * <p>
     * A descriptive name for the document that helps identify its purpose and content.
     * </p>
     * 
     * @return A descriptive name for the document that helps identify its purpose and content.
     */
    public final String documentName() {
        return documentName;
    }

    /**
     * <p>
     * A detailed description of the document's content and how it should be used in the policy generation process.
     * </p>
     * 
     * @return A detailed description of the document's content and how it should be used in the policy generation
     *         process.
     */
    public final String documentDescription() {
        return documentDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(document());
        hashCode = 31 * hashCode + Objects.hashCode(documentContentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(documentName());
        hashCode = 31 * hashCode + Objects.hashCode(documentDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyBuildWorkflowDocument)) {
            return false;
        }
        AutomatedReasoningPolicyBuildWorkflowDocument other = (AutomatedReasoningPolicyBuildWorkflowDocument) obj;
        return Objects.equals(document(), other.document())
                && Objects.equals(documentContentTypeAsString(), other.documentContentTypeAsString())
                && Objects.equals(documentName(), other.documentName())
                && Objects.equals(documentDescription(), other.documentDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningPolicyBuildWorkflowDocument")
                .add("Document", document() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DocumentContentType", documentContentTypeAsString())
                .add("DocumentName", documentName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DocumentDescription", documentDescription() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "document":
            return Optional.ofNullable(clazz.cast(document()));
        case "documentContentType":
            return Optional.ofNullable(clazz.cast(documentContentTypeAsString()));
        case "documentName":
            return Optional.ofNullable(clazz.cast(documentName()));
        case "documentDescription":
            return Optional.ofNullable(clazz.cast(documentDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("document", DOCUMENT_FIELD);
        map.put("documentContentType", DOCUMENT_CONTENT_TYPE_FIELD);
        map.put("documentName", DOCUMENT_NAME_FIELD);
        map.put("documentDescription", DOCUMENT_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyBuildWorkflowDocument, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyBuildWorkflowDocument) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningPolicyBuildWorkflowDocument> {
        /**
         * <p>
         * The actual content of the source document that will be analyzed to extract policy rules and concepts.
         * </p>
         * 
         * @param document
         *        The actual content of the source document that will be analyzed to extract policy rules and concepts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder document(SdkBytes document);

        /**
         * <p>
         * The MIME type of the document content (e.g., text/plain, application/pdf, text/markdown).
         * </p>
         * 
         * @param documentContentType
         *        The MIME type of the document content (e.g., text/plain, application/pdf, text/markdown).
         * @see AutomatedReasoningPolicyBuildDocumentContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedReasoningPolicyBuildDocumentContentType
         */
        Builder documentContentType(String documentContentType);

        /**
         * <p>
         * The MIME type of the document content (e.g., text/plain, application/pdf, text/markdown).
         * </p>
         * 
         * @param documentContentType
         *        The MIME type of the document content (e.g., text/plain, application/pdf, text/markdown).
         * @see AutomatedReasoningPolicyBuildDocumentContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedReasoningPolicyBuildDocumentContentType
         */
        Builder documentContentType(AutomatedReasoningPolicyBuildDocumentContentType documentContentType);

        /**
         * <p>
         * A descriptive name for the document that helps identify its purpose and content.
         * </p>
         * 
         * @param documentName
         *        A descriptive name for the document that helps identify its purpose and content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentName(String documentName);

        /**
         * <p>
         * A detailed description of the document's content and how it should be used in the policy generation process.
         * </p>
         * 
         * @param documentDescription
         *        A detailed description of the document's content and how it should be used in the policy generation
         *        process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentDescription(String documentDescription);
    }

    static final class BuilderImpl implements Builder {
        private SdkBytes document;

        private String documentContentType;

        private String documentName;

        private String documentDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyBuildWorkflowDocument model) {
            document(model.document);
            documentContentType(model.documentContentType);
            documentName(model.documentName);
            documentDescription(model.documentDescription);
        }

        public final ByteBuffer getDocument() {
            return document == null ? null : document.asByteBuffer();
        }

        public final void setDocument(ByteBuffer document) {
            document(document == null ? null : SdkBytes.fromByteBuffer(document));
        }

        @Override
        public final Builder document(SdkBytes document) {
            this.document = document;
            return this;
        }

        public final String getDocumentContentType() {
            return documentContentType;
        }

        public final void setDocumentContentType(String documentContentType) {
            this.documentContentType = documentContentType;
        }

        @Override
        public final Builder documentContentType(String documentContentType) {
            this.documentContentType = documentContentType;
            return this;
        }

        @Override
        public final Builder documentContentType(AutomatedReasoningPolicyBuildDocumentContentType documentContentType) {
            this.documentContentType(documentContentType == null ? null : documentContentType.toString());
            return this;
        }

        public final String getDocumentName() {
            return documentName;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final String getDocumentDescription() {
            return documentDescription;
        }

        public final void setDocumentDescription(String documentDescription) {
            this.documentDescription = documentDescription;
        }

        @Override
        public final Builder documentDescription(String documentDescription) {
            this.documentDescription = documentDescription;
            return this;
        }

        @Override
        public AutomatedReasoningPolicyBuildWorkflowDocument build() {
            return new AutomatedReasoningPolicyBuildWorkflowDocument(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
