/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a logical scenario where claims can be evaluated as true or false, containing specific logical
 * assignments.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningCheckScenario implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningCheckScenario.Builder, AutomatedReasoningCheckScenario> {
    private static final SdkField<List<AutomatedReasoningLogicStatement>> STATEMENTS_FIELD = SdkField
            .<List<AutomatedReasoningLogicStatement>> builder(MarshallingType.LIST)
            .memberName("statements")
            .getter(getter(AutomatedReasoningCheckScenario::statements))
            .setter(setter(Builder::statements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomatedReasoningLogicStatement> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomatedReasoningLogicStatement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATEMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AutomatedReasoningLogicStatement> statements;

    private AutomatedReasoningCheckScenario(BuilderImpl builder) {
        this.statements = builder.statements;
    }

    /**
     * For responses, this returns true if the service returned a value for the Statements property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatements() {
        return statements != null && !(statements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of logical assignments and statements that define this scenario.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatements} method.
     * </p>
     * 
     * @return List of logical assignments and statements that define this scenario.
     */
    public final List<AutomatedReasoningLogicStatement> statements() {
        return statements;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStatements() ? statements() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningCheckScenario)) {
            return false;
        }
        AutomatedReasoningCheckScenario other = (AutomatedReasoningCheckScenario) obj;
        return hasStatements() == other.hasStatements() && Objects.equals(statements(), other.statements());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningCheckScenario").add("Statements", hasStatements() ? statements() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "statements":
            return Optional.ofNullable(clazz.cast(statements()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("statements", STATEMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningCheckScenario, T> g) {
        return obj -> g.apply((AutomatedReasoningCheckScenario) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningCheckScenario> {
        /**
         * <p>
         * List of logical assignments and statements that define this scenario.
         * </p>
         * 
         * @param statements
         *        List of logical assignments and statements that define this scenario.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statements(Collection<AutomatedReasoningLogicStatement> statements);

        /**
         * <p>
         * List of logical assignments and statements that define this scenario.
         * </p>
         * 
         * @param statements
         *        List of logical assignments and statements that define this scenario.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statements(AutomatedReasoningLogicStatement... statements);

        /**
         * <p>
         * List of logical assignments and statements that define this scenario.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningLogicStatement.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningLogicStatement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningLogicStatement.Builder#build()} is
         * called immediately and its result is passed to {@link #statements(List<AutomatedReasoningLogicStatement>)}.
         * 
         * @param statements
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningLogicStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statements(java.util.Collection<AutomatedReasoningLogicStatement>)
         */
        Builder statements(Consumer<AutomatedReasoningLogicStatement.Builder>... statements);
    }

    static final class BuilderImpl implements Builder {
        private List<AutomatedReasoningLogicStatement> statements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningCheckScenario model) {
            statements(model.statements);
        }

        public final List<AutomatedReasoningLogicStatement.Builder> getStatements() {
            List<AutomatedReasoningLogicStatement.Builder> result = AutomatedReasoningLogicStatementListCopier
                    .copyToBuilder(this.statements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatements(Collection<AutomatedReasoningLogicStatement.BuilderImpl> statements) {
            this.statements = AutomatedReasoningLogicStatementListCopier.copyFromBuilder(statements);
        }

        @Override
        public final Builder statements(Collection<AutomatedReasoningLogicStatement> statements) {
            this.statements = AutomatedReasoningLogicStatementListCopier.copy(statements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statements(AutomatedReasoningLogicStatement... statements) {
            statements(Arrays.asList(statements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statements(Consumer<AutomatedReasoningLogicStatement.Builder>... statements) {
            statements(Stream.of(statements).map(c -> AutomatedReasoningLogicStatement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AutomatedReasoningCheckScenario build() {
            return new AutomatedReasoningCheckScenario(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
