/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates that the claims are logically false and contradictory to the established rules or premises.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedReasoningCheckInvalidFinding implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedReasoningCheckInvalidFinding.Builder, AutomatedReasoningCheckInvalidFinding> {
    private static final SdkField<AutomatedReasoningCheckTranslation> TRANSLATION_FIELD = SdkField
            .<AutomatedReasoningCheckTranslation> builder(MarshallingType.SDK_POJO).memberName("translation")
            .getter(getter(AutomatedReasoningCheckInvalidFinding::translation)).setter(setter(Builder::translation))
            .constructor(AutomatedReasoningCheckTranslation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("translation").build()).build();

    private static final SdkField<List<AutomatedReasoningCheckRule>> CONTRADICTING_RULES_FIELD = SdkField
            .<List<AutomatedReasoningCheckRule>> builder(MarshallingType.LIST)
            .memberName("contradictingRules")
            .getter(getter(AutomatedReasoningCheckInvalidFinding::contradictingRules))
            .setter(setter(Builder::contradictingRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contradictingRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomatedReasoningCheckRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomatedReasoningCheckRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AutomatedReasoningCheckLogicWarning> LOGIC_WARNING_FIELD = SdkField
            .<AutomatedReasoningCheckLogicWarning> builder(MarshallingType.SDK_POJO).memberName("logicWarning")
            .getter(getter(AutomatedReasoningCheckInvalidFinding::logicWarning)).setter(setter(Builder::logicWarning))
            .constructor(AutomatedReasoningCheckLogicWarning::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicWarning").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSLATION_FIELD,
            CONTRADICTING_RULES_FIELD, LOGIC_WARNING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AutomatedReasoningCheckTranslation translation;

    private final List<AutomatedReasoningCheckRule> contradictingRules;

    private final AutomatedReasoningCheckLogicWarning logicWarning;

    private AutomatedReasoningCheckInvalidFinding(BuilderImpl builder) {
        this.translation = builder.translation;
        this.contradictingRules = builder.contradictingRules;
        this.logicWarning = builder.logicWarning;
    }

    /**
     * <p>
     * The logical translation of the input that this finding invalidates.
     * </p>
     * 
     * @return The logical translation of the input that this finding invalidates.
     */
    public final AutomatedReasoningCheckTranslation translation() {
        return translation;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContradictingRules property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContradictingRules() {
        return contradictingRules != null && !(contradictingRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The automated reasoning policy rules that contradict the claims in the input.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContradictingRules} method.
     * </p>
     * 
     * @return The automated reasoning policy rules that contradict the claims in the input.
     */
    public final List<AutomatedReasoningCheckRule> contradictingRules() {
        return contradictingRules;
    }

    /**
     * <p>
     * Indication of a logic issue with the translation without needing to consider the automated reasoning policy
     * rules.
     * </p>
     * 
     * @return Indication of a logic issue with the translation without needing to consider the automated reasoning
     *         policy rules.
     */
    public final AutomatedReasoningCheckLogicWarning logicWarning() {
        return logicWarning;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(translation());
        hashCode = 31 * hashCode + Objects.hashCode(hasContradictingRules() ? contradictingRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(logicWarning());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningCheckInvalidFinding)) {
            return false;
        }
        AutomatedReasoningCheckInvalidFinding other = (AutomatedReasoningCheckInvalidFinding) obj;
        return Objects.equals(translation(), other.translation()) && hasContradictingRules() == other.hasContradictingRules()
                && Objects.equals(contradictingRules(), other.contradictingRules())
                && Objects.equals(logicWarning(), other.logicWarning());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedReasoningCheckInvalidFinding").add("Translation", translation())
                .add("ContradictingRules", hasContradictingRules() ? contradictingRules() : null)
                .add("LogicWarning", logicWarning()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "translation":
            return Optional.ofNullable(clazz.cast(translation()));
        case "contradictingRules":
            return Optional.ofNullable(clazz.cast(contradictingRules()));
        case "logicWarning":
            return Optional.ofNullable(clazz.cast(logicWarning()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("translation", TRANSLATION_FIELD);
        map.put("contradictingRules", CONTRADICTING_RULES_FIELD);
        map.put("logicWarning", LOGIC_WARNING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningCheckInvalidFinding, T> g) {
        return obj -> g.apply((AutomatedReasoningCheckInvalidFinding) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedReasoningCheckInvalidFinding> {
        /**
         * <p>
         * The logical translation of the input that this finding invalidates.
         * </p>
         * 
         * @param translation
         *        The logical translation of the input that this finding invalidates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder translation(AutomatedReasoningCheckTranslation translation);

        /**
         * <p>
         * The logical translation of the input that this finding invalidates.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningCheckTranslation.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningCheckTranslation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningCheckTranslation.Builder#build()} is called
         * immediately and its result is passed to {@link #translation(AutomatedReasoningCheckTranslation)}.
         * 
         * @param translation
         *        a consumer that will call methods on {@link AutomatedReasoningCheckTranslation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #translation(AutomatedReasoningCheckTranslation)
         */
        default Builder translation(Consumer<AutomatedReasoningCheckTranslation.Builder> translation) {
            return translation(AutomatedReasoningCheckTranslation.builder().applyMutation(translation).build());
        }

        /**
         * <p>
         * The automated reasoning policy rules that contradict the claims in the input.
         * </p>
         * 
         * @param contradictingRules
         *        The automated reasoning policy rules that contradict the claims in the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contradictingRules(Collection<AutomatedReasoningCheckRule> contradictingRules);

        /**
         * <p>
         * The automated reasoning policy rules that contradict the claims in the input.
         * </p>
         * 
         * @param contradictingRules
         *        The automated reasoning policy rules that contradict the claims in the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contradictingRules(AutomatedReasoningCheckRule... contradictingRules);

        /**
         * <p>
         * The automated reasoning policy rules that contradict the claims in the input.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckRule.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckRule.Builder#build()} is called
         * immediately and its result is passed to {@link #contradictingRules(List<AutomatedReasoningCheckRule>)}.
         * 
         * @param contradictingRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contradictingRules(java.util.Collection<AutomatedReasoningCheckRule>)
         */
        Builder contradictingRules(Consumer<AutomatedReasoningCheckRule.Builder>... contradictingRules);

        /**
         * <p>
         * Indication of a logic issue with the translation without needing to consider the automated reasoning policy
         * rules.
         * </p>
         * 
         * @param logicWarning
         *        Indication of a logic issue with the translation without needing to consider the automated reasoning
         *        policy rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicWarning(AutomatedReasoningCheckLogicWarning logicWarning);

        /**
         * <p>
         * Indication of a logic issue with the translation without needing to consider the automated reasoning policy
         * rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningCheckLogicWarning.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningCheckLogicWarning#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningCheckLogicWarning.Builder#build()} is called
         * immediately and its result is passed to {@link #logicWarning(AutomatedReasoningCheckLogicWarning)}.
         * 
         * @param logicWarning
         *        a consumer that will call methods on {@link AutomatedReasoningCheckLogicWarning.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logicWarning(AutomatedReasoningCheckLogicWarning)
         */
        default Builder logicWarning(Consumer<AutomatedReasoningCheckLogicWarning.Builder> logicWarning) {
            return logicWarning(AutomatedReasoningCheckLogicWarning.builder().applyMutation(logicWarning).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutomatedReasoningCheckTranslation translation;

        private List<AutomatedReasoningCheckRule> contradictingRules = DefaultSdkAutoConstructList.getInstance();

        private AutomatedReasoningCheckLogicWarning logicWarning;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningCheckInvalidFinding model) {
            translation(model.translation);
            contradictingRules(model.contradictingRules);
            logicWarning(model.logicWarning);
        }

        public final AutomatedReasoningCheckTranslation.Builder getTranslation() {
            return translation != null ? translation.toBuilder() : null;
        }

        public final void setTranslation(AutomatedReasoningCheckTranslation.BuilderImpl translation) {
            this.translation = translation != null ? translation.build() : null;
        }

        @Override
        public final Builder translation(AutomatedReasoningCheckTranslation translation) {
            this.translation = translation;
            return this;
        }

        public final List<AutomatedReasoningCheckRule.Builder> getContradictingRules() {
            List<AutomatedReasoningCheckRule.Builder> result = AutomatedReasoningCheckRuleListCopier
                    .copyToBuilder(this.contradictingRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContradictingRules(Collection<AutomatedReasoningCheckRule.BuilderImpl> contradictingRules) {
            this.contradictingRules = AutomatedReasoningCheckRuleListCopier.copyFromBuilder(contradictingRules);
        }

        @Override
        public final Builder contradictingRules(Collection<AutomatedReasoningCheckRule> contradictingRules) {
            this.contradictingRules = AutomatedReasoningCheckRuleListCopier.copy(contradictingRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contradictingRules(AutomatedReasoningCheckRule... contradictingRules) {
            contradictingRules(Arrays.asList(contradictingRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contradictingRules(Consumer<AutomatedReasoningCheckRule.Builder>... contradictingRules) {
            contradictingRules(Stream.of(contradictingRules)
                    .map(c -> AutomatedReasoningCheckRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final AutomatedReasoningCheckLogicWarning.Builder getLogicWarning() {
            return logicWarning != null ? logicWarning.toBuilder() : null;
        }

        public final void setLogicWarning(AutomatedReasoningCheckLogicWarning.BuilderImpl logicWarning) {
            this.logicWarning = logicWarning != null ? logicWarning.build() : null;
        }

        @Override
        public final Builder logicWarning(AutomatedReasoningCheckLogicWarning logicWarning) {
            this.logicWarning = logicWarning;
            return this;
        }

        @Override
        public AutomatedReasoningCheckInvalidFinding build() {
            return new AutomatedReasoningCheckInvalidFinding(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
