/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OfferType {
    ALL("ALL"),
    PUBLIC("PUBLIC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OfferType> VALUE_MAP;
    private final String value;

    private OfferType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OfferType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OfferType> knownValues() {
        EnumSet<OfferType> knownValues = EnumSet.allOf(OfferType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OfferType.class, OfferType::toString);
    }
}

