/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildWorkflowDocument;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildWorkflowDocumentListCopier;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildWorkflowRepairContent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomatedReasoningPolicyWorkflowTypeContent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomatedReasoningPolicyWorkflowTypeContent> {
    private static final SdkField<List<AutomatedReasoningPolicyBuildWorkflowDocument>> DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("documents").getter(AutomatedReasoningPolicyWorkflowTypeContent.getter(AutomatedReasoningPolicyWorkflowTypeContent::documents)).setter(AutomatedReasoningPolicyWorkflowTypeContent.setter(Builder::documents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomatedReasoningPolicyBuildWorkflowDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AutomatedReasoningPolicyBuildWorkflowRepairContent> POLICY_REPAIR_ASSETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("policyRepairAssets").getter(AutomatedReasoningPolicyWorkflowTypeContent.getter(AutomatedReasoningPolicyWorkflowTypeContent::policyRepairAssets)).setter(AutomatedReasoningPolicyWorkflowTypeContent.setter(Builder::policyRepairAssets)).constructor(AutomatedReasoningPolicyBuildWorkflowRepairContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyRepairAssets").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENTS_FIELD, POLICY_REPAIR_ASSETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomatedReasoningPolicyWorkflowTypeContent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<AutomatedReasoningPolicyBuildWorkflowDocument> documents;
    private final AutomatedReasoningPolicyBuildWorkflowRepairContent policyRepairAssets;
    private final Type type;

    private AutomatedReasoningPolicyWorkflowTypeContent(BuilderImpl builder) {
        this.documents = builder.documents;
        this.policyRepairAssets = builder.policyRepairAssets;
        this.type = builder.type;
    }

    public final boolean hasDocuments() {
        return this.documents != null && !(this.documents instanceof SdkAutoConstructList);
    }

    public final List<AutomatedReasoningPolicyBuildWorkflowDocument> documents() {
        return this.documents;
    }

    public final AutomatedReasoningPolicyBuildWorkflowRepairContent policyRepairAssets() {
        return this.policyRepairAssets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocuments() ? this.documents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.policyRepairAssets());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyWorkflowTypeContent)) {
            return false;
        }
        AutomatedReasoningPolicyWorkflowTypeContent other = (AutomatedReasoningPolicyWorkflowTypeContent)obj;
        return this.hasDocuments() == other.hasDocuments() && Objects.equals(this.documents(), other.documents()) && Objects.equals(this.policyRepairAssets(), other.policyRepairAssets());
    }

    public final String toString() {
        return ToString.builder((String)"AutomatedReasoningPolicyWorkflowTypeContent").add("Documents", this.hasDocuments() ? this.documents() : null).add("PolicyRepairAssets", (Object)this.policyRepairAssets()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "documents": {
                return Optional.ofNullable(clazz.cast(this.documents()));
            }
            case "policyRepairAssets": {
                return Optional.ofNullable(clazz.cast(this.policyRepairAssets()));
            }
        }
        return Optional.empty();
    }

    public static AutomatedReasoningPolicyWorkflowTypeContent fromDocuments(List<AutomatedReasoningPolicyBuildWorkflowDocument> documents) {
        return (AutomatedReasoningPolicyWorkflowTypeContent)AutomatedReasoningPolicyWorkflowTypeContent.builder().documents(documents).build();
    }

    public static AutomatedReasoningPolicyWorkflowTypeContent fromPolicyRepairAssets(AutomatedReasoningPolicyBuildWorkflowRepairContent policyRepairAssets) {
        return (AutomatedReasoningPolicyWorkflowTypeContent)AutomatedReasoningPolicyWorkflowTypeContent.builder().policyRepairAssets(policyRepairAssets).build();
    }

    public static AutomatedReasoningPolicyWorkflowTypeContent fromPolicyRepairAssets(Consumer<AutomatedReasoningPolicyBuildWorkflowRepairContent.Builder> policyRepairAssets) {
        AutomatedReasoningPolicyBuildWorkflowRepairContent.Builder builder = AutomatedReasoningPolicyBuildWorkflowRepairContent.builder();
        policyRepairAssets.accept(builder);
        return AutomatedReasoningPolicyWorkflowTypeContent.fromPolicyRepairAssets((AutomatedReasoningPolicyBuildWorkflowRepairContent)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("documents", DOCUMENTS_FIELD);
        map.put("policyRepairAssets", POLICY_REPAIR_ASSETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyWorkflowTypeContent, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyWorkflowTypeContent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        DOCUMENTS,
        POLICY_REPAIR_ASSETS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<AutomatedReasoningPolicyBuildWorkflowDocument> documents = DefaultSdkAutoConstructList.getInstance();
        private AutomatedReasoningPolicyBuildWorkflowRepairContent policyRepairAssets;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyWorkflowTypeContent model) {
            this.documents(model.documents);
            this.policyRepairAssets(model.policyRepairAssets);
        }

        public final List<AutomatedReasoningPolicyBuildWorkflowDocument.Builder> getDocuments() {
            List<AutomatedReasoningPolicyBuildWorkflowDocument.Builder> result = AutomatedReasoningPolicyBuildWorkflowDocumentListCopier.copyToBuilder(this.documents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocuments(Collection<AutomatedReasoningPolicyBuildWorkflowDocument.BuilderImpl> documents) {
            List<AutomatedReasoningPolicyBuildWorkflowDocument> oldValue = this.documents;
            this.documents = AutomatedReasoningPolicyBuildWorkflowDocumentListCopier.copyFromBuilder(documents);
            this.handleUnionValueChange(Type.DOCUMENTS, oldValue, this.documents);
        }

        @Override
        public final Builder documents(Collection<AutomatedReasoningPolicyBuildWorkflowDocument> documents) {
            List<AutomatedReasoningPolicyBuildWorkflowDocument> oldValue = this.documents;
            this.documents = AutomatedReasoningPolicyBuildWorkflowDocumentListCopier.copy(documents);
            this.handleUnionValueChange(Type.DOCUMENTS, oldValue, this.documents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(AutomatedReasoningPolicyBuildWorkflowDocument ... documents) {
            this.documents(Arrays.asList(documents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(Consumer<AutomatedReasoningPolicyBuildWorkflowDocument.Builder> ... documents) {
            this.documents(Stream.of(documents).map(c -> (AutomatedReasoningPolicyBuildWorkflowDocument)((AutomatedReasoningPolicyBuildWorkflowDocument.Builder)AutomatedReasoningPolicyBuildWorkflowDocument.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AutomatedReasoningPolicyBuildWorkflowRepairContent.Builder getPolicyRepairAssets() {
            return this.policyRepairAssets != null ? this.policyRepairAssets.toBuilder() : null;
        }

        public final void setPolicyRepairAssets(AutomatedReasoningPolicyBuildWorkflowRepairContent.BuilderImpl policyRepairAssets) {
            AutomatedReasoningPolicyBuildWorkflowRepairContent oldValue = this.policyRepairAssets;
            this.policyRepairAssets = policyRepairAssets != null ? policyRepairAssets.build() : null;
            this.handleUnionValueChange(Type.POLICY_REPAIR_ASSETS, oldValue, this.policyRepairAssets);
        }

        @Override
        public final Builder policyRepairAssets(AutomatedReasoningPolicyBuildWorkflowRepairContent policyRepairAssets) {
            AutomatedReasoningPolicyBuildWorkflowRepairContent oldValue = this.policyRepairAssets;
            this.policyRepairAssets = policyRepairAssets;
            this.handleUnionValueChange(Type.POLICY_REPAIR_ASSETS, oldValue, this.policyRepairAssets);
            return this;
        }

        public AutomatedReasoningPolicyWorkflowTypeContent build() {
            return new AutomatedReasoningPolicyWorkflowTypeContent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomatedReasoningPolicyWorkflowTypeContent> {
        public Builder documents(Collection<AutomatedReasoningPolicyBuildWorkflowDocument> var1);

        public Builder documents(AutomatedReasoningPolicyBuildWorkflowDocument ... var1);

        public Builder documents(Consumer<AutomatedReasoningPolicyBuildWorkflowDocument.Builder> ... var1);

        public Builder policyRepairAssets(AutomatedReasoningPolicyBuildWorkflowRepairContent var1);

        default public Builder policyRepairAssets(Consumer<AutomatedReasoningPolicyBuildWorkflowRepairContent.Builder> policyRepairAssets) {
            return this.policyRepairAssets((AutomatedReasoningPolicyBuildWorkflowRepairContent)((AutomatedReasoningPolicyBuildWorkflowRepairContent.Builder)AutomatedReasoningPolicyBuildWorkflowRepairContent.builder().applyMutation(policyRepairAssets)).build());
        }
    }
}

