/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockAsyncClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicySummary;
import software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPoliciesRequest;
import software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPoliciesResponse;

public class ListAutomatedReasoningPoliciesPublisher
implements SdkPublisher<ListAutomatedReasoningPoliciesResponse> {
    private final BedrockAsyncClient client;
    private final ListAutomatedReasoningPoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAutomatedReasoningPoliciesPublisher(BedrockAsyncClient client, ListAutomatedReasoningPoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAutomatedReasoningPoliciesPublisher(BedrockAsyncClient client, ListAutomatedReasoningPoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAutomatedReasoningPoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAutomatedReasoningPoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AutomatedReasoningPolicySummary> automatedReasoningPolicySummaries() {
        Function<ListAutomatedReasoningPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.automatedReasoningPolicySummaries() != null) {
                return response.automatedReasoningPolicySummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAutomatedReasoningPoliciesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAutomatedReasoningPoliciesResponseFetcher
    implements AsyncPageFetcher<ListAutomatedReasoningPoliciesResponse> {
        private ListAutomatedReasoningPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListAutomatedReasoningPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAutomatedReasoningPoliciesResponse> nextPage(ListAutomatedReasoningPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListAutomatedReasoningPoliciesPublisher.this.client.listAutomatedReasoningPolicies(ListAutomatedReasoningPoliciesPublisher.this.firstRequest);
            }
            return ListAutomatedReasoningPoliciesPublisher.this.client.listAutomatedReasoningPolicies((ListAutomatedReasoningPoliciesRequest)((Object)ListAutomatedReasoningPoliciesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

