/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildStepContext;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildStepMessage;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildStepMessageListCopier;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionElement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomatedReasoningPolicyBuildStep
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomatedReasoningPolicyBuildStep> {
    private static final SdkField<AutomatedReasoningPolicyBuildStepContext> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("context").getter(AutomatedReasoningPolicyBuildStep.getter(AutomatedReasoningPolicyBuildStep::context)).setter(AutomatedReasoningPolicyBuildStep.setter(Builder::context)).constructor(AutomatedReasoningPolicyBuildStepContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build()}).build();
    private static final SdkField<AutomatedReasoningPolicyDefinitionElement> PRIOR_ELEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("priorElement").getter(AutomatedReasoningPolicyBuildStep.getter(AutomatedReasoningPolicyBuildStep::priorElement)).setter(AutomatedReasoningPolicyBuildStep.setter(Builder::priorElement)).constructor(AutomatedReasoningPolicyDefinitionElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priorElement").build()}).build();
    private static final SdkField<List<AutomatedReasoningPolicyBuildStepMessage>> MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("messages").getter(AutomatedReasoningPolicyBuildStep.getter(AutomatedReasoningPolicyBuildStep::messages)).setter(AutomatedReasoningPolicyBuildStep.setter(Builder::messages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomatedReasoningPolicyBuildStepMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTEXT_FIELD, PRIOR_ELEMENT_FIELD, MESSAGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomatedReasoningPolicyBuildStep.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AutomatedReasoningPolicyBuildStepContext context;
    private final AutomatedReasoningPolicyDefinitionElement priorElement;
    private final List<AutomatedReasoningPolicyBuildStepMessage> messages;

    private AutomatedReasoningPolicyBuildStep(BuilderImpl builder) {
        this.context = builder.context;
        this.priorElement = builder.priorElement;
        this.messages = builder.messages;
    }

    public final AutomatedReasoningPolicyBuildStepContext context() {
        return this.context;
    }

    public final AutomatedReasoningPolicyDefinitionElement priorElement() {
        return this.priorElement;
    }

    public final boolean hasMessages() {
        return this.messages != null && !(this.messages instanceof SdkAutoConstructList);
    }

    public final List<AutomatedReasoningPolicyBuildStepMessage> messages() {
        return this.messages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.context());
        hashCode = 31 * hashCode + Objects.hashCode(this.priorElement());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessages() ? this.messages() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyBuildStep)) {
            return false;
        }
        AutomatedReasoningPolicyBuildStep other = (AutomatedReasoningPolicyBuildStep)obj;
        return Objects.equals(this.context(), other.context()) && Objects.equals(this.priorElement(), other.priorElement()) && this.hasMessages() == other.hasMessages() && Objects.equals(this.messages(), other.messages());
    }

    public final String toString() {
        return ToString.builder((String)"AutomatedReasoningPolicyBuildStep").add("Context", (Object)this.context()).add("PriorElement", (Object)this.priorElement()).add("Messages", this.hasMessages() ? this.messages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "context": {
                return Optional.ofNullable(clazz.cast(this.context()));
            }
            case "priorElement": {
                return Optional.ofNullable(clazz.cast(this.priorElement()));
            }
            case "messages": {
                return Optional.ofNullable(clazz.cast(this.messages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("context", CONTEXT_FIELD);
        map.put("priorElement", PRIOR_ELEMENT_FIELD);
        map.put("messages", MESSAGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyBuildStep, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyBuildStep)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AutomatedReasoningPolicyBuildStepContext context;
        private AutomatedReasoningPolicyDefinitionElement priorElement;
        private List<AutomatedReasoningPolicyBuildStepMessage> messages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyBuildStep model) {
            this.context(model.context);
            this.priorElement(model.priorElement);
            this.messages(model.messages);
        }

        public final AutomatedReasoningPolicyBuildStepContext.Builder getContext() {
            return this.context != null ? this.context.toBuilder() : null;
        }

        public final void setContext(AutomatedReasoningPolicyBuildStepContext.BuilderImpl context) {
            this.context = context != null ? context.build() : null;
        }

        @Override
        public final Builder context(AutomatedReasoningPolicyBuildStepContext context) {
            this.context = context;
            return this;
        }

        public final AutomatedReasoningPolicyDefinitionElement.Builder getPriorElement() {
            return this.priorElement != null ? this.priorElement.toBuilder() : null;
        }

        public final void setPriorElement(AutomatedReasoningPolicyDefinitionElement.BuilderImpl priorElement) {
            this.priorElement = priorElement != null ? priorElement.build() : null;
        }

        @Override
        public final Builder priorElement(AutomatedReasoningPolicyDefinitionElement priorElement) {
            this.priorElement = priorElement;
            return this;
        }

        public final List<AutomatedReasoningPolicyBuildStepMessage.Builder> getMessages() {
            List<AutomatedReasoningPolicyBuildStepMessage.Builder> result = AutomatedReasoningPolicyBuildStepMessageListCopier.copyToBuilder(this.messages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessages(Collection<AutomatedReasoningPolicyBuildStepMessage.BuilderImpl> messages) {
            this.messages = AutomatedReasoningPolicyBuildStepMessageListCopier.copyFromBuilder(messages);
        }

        @Override
        public final Builder messages(Collection<AutomatedReasoningPolicyBuildStepMessage> messages) {
            this.messages = AutomatedReasoningPolicyBuildStepMessageListCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(AutomatedReasoningPolicyBuildStepMessage ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<AutomatedReasoningPolicyBuildStepMessage.Builder> ... messages) {
            this.messages(Stream.of(messages).map(c -> (AutomatedReasoningPolicyBuildStepMessage)((AutomatedReasoningPolicyBuildStepMessage.Builder)AutomatedReasoningPolicyBuildStepMessage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AutomatedReasoningPolicyBuildStep build() {
            return new AutomatedReasoningPolicyBuildStep(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomatedReasoningPolicyBuildStep> {
        public Builder context(AutomatedReasoningPolicyBuildStepContext var1);

        default public Builder context(Consumer<AutomatedReasoningPolicyBuildStepContext.Builder> context) {
            return this.context((AutomatedReasoningPolicyBuildStepContext)((AutomatedReasoningPolicyBuildStepContext.Builder)AutomatedReasoningPolicyBuildStepContext.builder().applyMutation(context)).build());
        }

        public Builder priorElement(AutomatedReasoningPolicyDefinitionElement var1);

        default public Builder priorElement(Consumer<AutomatedReasoningPolicyDefinitionElement.Builder> priorElement) {
            return this.priorElement((AutomatedReasoningPolicyDefinitionElement)((AutomatedReasoningPolicyDefinitionElement.Builder)AutomatedReasoningPolicyDefinitionElement.builder().applyMutation(priorElement)).build());
        }

        public Builder messages(Collection<AutomatedReasoningPolicyBuildStepMessage> var1);

        public Builder messages(AutomatedReasoningPolicyBuildStepMessage ... var1);

        public Builder messages(Consumer<AutomatedReasoningPolicyBuildStepMessage.Builder> ... var1);
    }
}

