/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckLogicWarning;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckRule;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckRuleListCopier;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckScenario;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckTranslation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomatedReasoningCheckValidFinding
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomatedReasoningCheckValidFinding> {
    private static final SdkField<AutomatedReasoningCheckTranslation> TRANSLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("translation").getter(AutomatedReasoningCheckValidFinding.getter(AutomatedReasoningCheckValidFinding::translation)).setter(AutomatedReasoningCheckValidFinding.setter(Builder::translation)).constructor(AutomatedReasoningCheckTranslation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("translation").build()}).build();
    private static final SdkField<AutomatedReasoningCheckScenario> CLAIMS_TRUE_SCENARIO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("claimsTrueScenario").getter(AutomatedReasoningCheckValidFinding.getter(AutomatedReasoningCheckValidFinding::claimsTrueScenario)).setter(AutomatedReasoningCheckValidFinding.setter(Builder::claimsTrueScenario)).constructor(AutomatedReasoningCheckScenario::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("claimsTrueScenario").build()}).build();
    private static final SdkField<List<AutomatedReasoningCheckRule>> SUPPORTING_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("supportingRules").getter(AutomatedReasoningCheckValidFinding.getter(AutomatedReasoningCheckValidFinding::supportingRules)).setter(AutomatedReasoningCheckValidFinding.setter(Builder::supportingRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportingRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomatedReasoningCheckRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AutomatedReasoningCheckLogicWarning> LOGIC_WARNING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logicWarning").getter(AutomatedReasoningCheckValidFinding.getter(AutomatedReasoningCheckValidFinding::logicWarning)).setter(AutomatedReasoningCheckValidFinding.setter(Builder::logicWarning)).constructor(AutomatedReasoningCheckLogicWarning::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicWarning").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSLATION_FIELD, CLAIMS_TRUE_SCENARIO_FIELD, SUPPORTING_RULES_FIELD, LOGIC_WARNING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomatedReasoningCheckValidFinding.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AutomatedReasoningCheckTranslation translation;
    private final AutomatedReasoningCheckScenario claimsTrueScenario;
    private final List<AutomatedReasoningCheckRule> supportingRules;
    private final AutomatedReasoningCheckLogicWarning logicWarning;

    private AutomatedReasoningCheckValidFinding(BuilderImpl builder) {
        this.translation = builder.translation;
        this.claimsTrueScenario = builder.claimsTrueScenario;
        this.supportingRules = builder.supportingRules;
        this.logicWarning = builder.logicWarning;
    }

    public final AutomatedReasoningCheckTranslation translation() {
        return this.translation;
    }

    public final AutomatedReasoningCheckScenario claimsTrueScenario() {
        return this.claimsTrueScenario;
    }

    public final boolean hasSupportingRules() {
        return this.supportingRules != null && !(this.supportingRules instanceof SdkAutoConstructList);
    }

    public final List<AutomatedReasoningCheckRule> supportingRules() {
        return this.supportingRules;
    }

    public final AutomatedReasoningCheckLogicWarning logicWarning() {
        return this.logicWarning;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.translation());
        hashCode = 31 * hashCode + Objects.hashCode(this.claimsTrueScenario());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportingRules() ? this.supportingRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.logicWarning());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningCheckValidFinding)) {
            return false;
        }
        AutomatedReasoningCheckValidFinding other = (AutomatedReasoningCheckValidFinding)obj;
        return Objects.equals(this.translation(), other.translation()) && Objects.equals(this.claimsTrueScenario(), other.claimsTrueScenario()) && this.hasSupportingRules() == other.hasSupportingRules() && Objects.equals(this.supportingRules(), other.supportingRules()) && Objects.equals(this.logicWarning(), other.logicWarning());
    }

    public final String toString() {
        return ToString.builder((String)"AutomatedReasoningCheckValidFinding").add("Translation", (Object)this.translation()).add("ClaimsTrueScenario", (Object)this.claimsTrueScenario()).add("SupportingRules", this.hasSupportingRules() ? this.supportingRules() : null).add("LogicWarning", (Object)this.logicWarning()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "translation": {
                return Optional.ofNullable(clazz.cast(this.translation()));
            }
            case "claimsTrueScenario": {
                return Optional.ofNullable(clazz.cast(this.claimsTrueScenario()));
            }
            case "supportingRules": {
                return Optional.ofNullable(clazz.cast(this.supportingRules()));
            }
            case "logicWarning": {
                return Optional.ofNullable(clazz.cast(this.logicWarning()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("translation", TRANSLATION_FIELD);
        map.put("claimsTrueScenario", CLAIMS_TRUE_SCENARIO_FIELD);
        map.put("supportingRules", SUPPORTING_RULES_FIELD);
        map.put("logicWarning", LOGIC_WARNING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningCheckValidFinding, T> g) {
        return obj -> g.apply((AutomatedReasoningCheckValidFinding)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AutomatedReasoningCheckTranslation translation;
        private AutomatedReasoningCheckScenario claimsTrueScenario;
        private List<AutomatedReasoningCheckRule> supportingRules = DefaultSdkAutoConstructList.getInstance();
        private AutomatedReasoningCheckLogicWarning logicWarning;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningCheckValidFinding model) {
            this.translation(model.translation);
            this.claimsTrueScenario(model.claimsTrueScenario);
            this.supportingRules(model.supportingRules);
            this.logicWarning(model.logicWarning);
        }

        public final AutomatedReasoningCheckTranslation.Builder getTranslation() {
            return this.translation != null ? this.translation.toBuilder() : null;
        }

        public final void setTranslation(AutomatedReasoningCheckTranslation.BuilderImpl translation) {
            this.translation = translation != null ? translation.build() : null;
        }

        @Override
        public final Builder translation(AutomatedReasoningCheckTranslation translation) {
            this.translation = translation;
            return this;
        }

        public final AutomatedReasoningCheckScenario.Builder getClaimsTrueScenario() {
            return this.claimsTrueScenario != null ? this.claimsTrueScenario.toBuilder() : null;
        }

        public final void setClaimsTrueScenario(AutomatedReasoningCheckScenario.BuilderImpl claimsTrueScenario) {
            this.claimsTrueScenario = claimsTrueScenario != null ? claimsTrueScenario.build() : null;
        }

        @Override
        public final Builder claimsTrueScenario(AutomatedReasoningCheckScenario claimsTrueScenario) {
            this.claimsTrueScenario = claimsTrueScenario;
            return this;
        }

        public final List<AutomatedReasoningCheckRule.Builder> getSupportingRules() {
            List<AutomatedReasoningCheckRule.Builder> result = AutomatedReasoningCheckRuleListCopier.copyToBuilder(this.supportingRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportingRules(Collection<AutomatedReasoningCheckRule.BuilderImpl> supportingRules) {
            this.supportingRules = AutomatedReasoningCheckRuleListCopier.copyFromBuilder(supportingRules);
        }

        @Override
        public final Builder supportingRules(Collection<AutomatedReasoningCheckRule> supportingRules) {
            this.supportingRules = AutomatedReasoningCheckRuleListCopier.copy(supportingRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportingRules(AutomatedReasoningCheckRule ... supportingRules) {
            this.supportingRules(Arrays.asList(supportingRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportingRules(Consumer<AutomatedReasoningCheckRule.Builder> ... supportingRules) {
            this.supportingRules(Stream.of(supportingRules).map(c -> (AutomatedReasoningCheckRule)((AutomatedReasoningCheckRule.Builder)AutomatedReasoningCheckRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AutomatedReasoningCheckLogicWarning.Builder getLogicWarning() {
            return this.logicWarning != null ? this.logicWarning.toBuilder() : null;
        }

        public final void setLogicWarning(AutomatedReasoningCheckLogicWarning.BuilderImpl logicWarning) {
            this.logicWarning = logicWarning != null ? logicWarning.build() : null;
        }

        @Override
        public final Builder logicWarning(AutomatedReasoningCheckLogicWarning logicWarning) {
            this.logicWarning = logicWarning;
            return this;
        }

        public AutomatedReasoningCheckValidFinding build() {
            return new AutomatedReasoningCheckValidFinding(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomatedReasoningCheckValidFinding> {
        public Builder translation(AutomatedReasoningCheckTranslation var1);

        default public Builder translation(Consumer<AutomatedReasoningCheckTranslation.Builder> translation) {
            return this.translation((AutomatedReasoningCheckTranslation)((AutomatedReasoningCheckTranslation.Builder)AutomatedReasoningCheckTranslation.builder().applyMutation(translation)).build());
        }

        public Builder claimsTrueScenario(AutomatedReasoningCheckScenario var1);

        default public Builder claimsTrueScenario(Consumer<AutomatedReasoningCheckScenario.Builder> claimsTrueScenario) {
            return this.claimsTrueScenario((AutomatedReasoningCheckScenario)((AutomatedReasoningCheckScenario.Builder)AutomatedReasoningCheckScenario.builder().applyMutation(claimsTrueScenario)).build());
        }

        public Builder supportingRules(Collection<AutomatedReasoningCheckRule> var1);

        public Builder supportingRules(AutomatedReasoningCheckRule ... var1);

        public Builder supportingRules(Consumer<AutomatedReasoningCheckRule.Builder> ... var1);

        public Builder logicWarning(AutomatedReasoningCheckLogicWarning var1);

        default public Builder logicWarning(Consumer<AutomatedReasoningCheckLogicWarning.Builder> logicWarning) {
            return this.logicWarning((AutomatedReasoningCheckLogicWarning)((AutomatedReasoningCheckLogicWarning.Builder)AutomatedReasoningCheckLogicWarning.builder().applyMutation(logicWarning)).build());
        }
    }
}

