/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SageMakerEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SageMakerEndpoint> {
    private static final SdkField<Integer> INITIAL_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("initialInstanceCount").getter(SageMakerEndpoint.getter(SageMakerEndpoint::initialInstanceCount)).setter(SageMakerEndpoint.setter(Builder::initialInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialInstanceCount").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceType").getter(SageMakerEndpoint.getter(SageMakerEndpoint::instanceType)).setter(SageMakerEndpoint.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRole").getter(SageMakerEndpoint.getter(SageMakerEndpoint::executionRole)).setter(SageMakerEndpoint.setter(Builder::executionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()}).build();
    private static final SdkField<String> KMS_ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsEncryptionKey").getter(SageMakerEndpoint.getter(SageMakerEndpoint::kmsEncryptionKey)).setter(SageMakerEndpoint.setter(Builder::kmsEncryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsEncryptionKey").build()}).build();
    private static final SdkField<VpcConfig> VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpc").getter(SageMakerEndpoint.getter(SageMakerEndpoint::vpc)).setter(SageMakerEndpoint.setter(Builder::vpc)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpc").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIAL_INSTANCE_COUNT_FIELD, INSTANCE_TYPE_FIELD, EXECUTION_ROLE_FIELD, KMS_ENCRYPTION_KEY_FIELD, VPC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SageMakerEndpoint.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer initialInstanceCount;
    private final String instanceType;
    private final String executionRole;
    private final String kmsEncryptionKey;
    private final VpcConfig vpc;

    private SageMakerEndpoint(BuilderImpl builder) {
        this.initialInstanceCount = builder.initialInstanceCount;
        this.instanceType = builder.instanceType;
        this.executionRole = builder.executionRole;
        this.kmsEncryptionKey = builder.kmsEncryptionKey;
        this.vpc = builder.vpc;
    }

    public final Integer initialInstanceCount() {
        return this.initialInstanceCount;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String executionRole() {
        return this.executionRole;
    }

    public final String kmsEncryptionKey() {
        return this.kmsEncryptionKey;
    }

    public final VpcConfig vpc() {
        return this.vpc;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.initialInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsEncryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpc());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SageMakerEndpoint)) {
            return false;
        }
        SageMakerEndpoint other = (SageMakerEndpoint)obj;
        return Objects.equals(this.initialInstanceCount(), other.initialInstanceCount()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.executionRole(), other.executionRole()) && Objects.equals(this.kmsEncryptionKey(), other.kmsEncryptionKey()) && Objects.equals(this.vpc(), other.vpc());
    }

    public final String toString() {
        return ToString.builder((String)"SageMakerEndpoint").add("InitialInstanceCount", (Object)this.initialInstanceCount()).add("InstanceType", (Object)this.instanceType()).add("ExecutionRole", (Object)this.executionRole()).add("KmsEncryptionKey", (Object)this.kmsEncryptionKey()).add("Vpc", (Object)this.vpc()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "initialInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.initialInstanceCount()));
            }
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "executionRole": {
                return Optional.ofNullable(clazz.cast(this.executionRole()));
            }
            case "kmsEncryptionKey": {
                return Optional.ofNullable(clazz.cast(this.kmsEncryptionKey()));
            }
            case "vpc": {
                return Optional.ofNullable(clazz.cast(this.vpc()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("initialInstanceCount", INITIAL_INSTANCE_COUNT_FIELD);
        map.put("instanceType", INSTANCE_TYPE_FIELD);
        map.put("executionRole", EXECUTION_ROLE_FIELD);
        map.put("kmsEncryptionKey", KMS_ENCRYPTION_KEY_FIELD);
        map.put("vpc", VPC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SageMakerEndpoint, T> g) {
        return obj -> g.apply((SageMakerEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer initialInstanceCount;
        private String instanceType;
        private String executionRole;
        private String kmsEncryptionKey;
        private VpcConfig vpc;

        private BuilderImpl() {
        }

        private BuilderImpl(SageMakerEndpoint model) {
            this.initialInstanceCount(model.initialInstanceCount);
            this.instanceType(model.instanceType);
            this.executionRole(model.executionRole);
            this.kmsEncryptionKey(model.kmsEncryptionKey);
            this.vpc(model.vpc);
        }

        public final Integer getInitialInstanceCount() {
            return this.initialInstanceCount;
        }

        public final void setInitialInstanceCount(Integer initialInstanceCount) {
            this.initialInstanceCount = initialInstanceCount;
        }

        @Override
        public final Builder initialInstanceCount(Integer initialInstanceCount) {
            this.initialInstanceCount = initialInstanceCount;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getExecutionRole() {
            return this.executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final String getKmsEncryptionKey() {
            return this.kmsEncryptionKey;
        }

        public final void setKmsEncryptionKey(String kmsEncryptionKey) {
            this.kmsEncryptionKey = kmsEncryptionKey;
        }

        @Override
        public final Builder kmsEncryptionKey(String kmsEncryptionKey) {
            this.kmsEncryptionKey = kmsEncryptionKey;
            return this;
        }

        public final VpcConfig.Builder getVpc() {
            return this.vpc != null ? this.vpc.toBuilder() : null;
        }

        public final void setVpc(VpcConfig.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public final Builder vpc(VpcConfig vpc) {
            this.vpc = vpc;
            return this;
        }

        public SageMakerEndpoint build() {
            return new SageMakerEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SageMakerEndpoint> {
        public Builder initialInstanceCount(Integer var1);

        public Builder instanceType(String var1);

        public Builder executionRole(String var1);

        public Builder kmsEncryptionKey(String var1);

        public Builder vpc(VpcConfig var1);

        default public Builder vpc(Consumer<VpcConfig.Builder> vpc) {
            return this.vpc((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpc)).build());
        }
    }
}

