/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configuration details for retrieval of information and response generation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RAGConfig implements SdkPojo, Serializable, ToCopyableBuilder<RAGConfig.Builder, RAGConfig> {
    private static final SdkField<KnowledgeBaseConfig> KNOWLEDGE_BASE_CONFIG_FIELD = SdkField
            .<KnowledgeBaseConfig> builder(MarshallingType.SDK_POJO).memberName("knowledgeBaseConfig")
            .getter(getter(RAGConfig::knowledgeBaseConfig)).setter(setter(Builder::knowledgeBaseConfig))
            .constructor(KnowledgeBaseConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseConfig").build())
            .build();

    private static final SdkField<EvaluationPrecomputedRagSourceConfig> PRECOMPUTED_RAG_SOURCE_CONFIG_FIELD = SdkField
            .<EvaluationPrecomputedRagSourceConfig> builder(MarshallingType.SDK_POJO)
            .memberName("precomputedRagSourceConfig")
            .getter(getter(RAGConfig::precomputedRagSourceConfig))
            .setter(setter(Builder::precomputedRagSourceConfig))
            .constructor(EvaluationPrecomputedRagSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("precomputedRagSourceConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_CONFIG_FIELD,
            PRECOMPUTED_RAG_SOURCE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final KnowledgeBaseConfig knowledgeBaseConfig;

    private final EvaluationPrecomputedRagSourceConfig precomputedRagSourceConfig;

    private final Type type;

    private RAGConfig(BuilderImpl builder) {
        this.knowledgeBaseConfig = builder.knowledgeBaseConfig;
        this.precomputedRagSourceConfig = builder.precomputedRagSourceConfig;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains configuration details for knowledge base retrieval and response generation.
     * </p>
     * 
     * @return Contains configuration details for knowledge base retrieval and response generation.
     */
    public final KnowledgeBaseConfig knowledgeBaseConfig() {
        return knowledgeBaseConfig;
    }

    /**
     * <p>
     * Contains configuration details about the RAG source used to generate inference response data for a Knowledge Base
     * evaluation job.
     * </p>
     * 
     * @return Contains configuration details about the RAG source used to generate inference response data for a
     *         Knowledge Base evaluation job.
     */
    public final EvaluationPrecomputedRagSourceConfig precomputedRagSourceConfig() {
        return precomputedRagSourceConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseConfig());
        hashCode = 31 * hashCode + Objects.hashCode(precomputedRagSourceConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RAGConfig)) {
            return false;
        }
        RAGConfig other = (RAGConfig) obj;
        return Objects.equals(knowledgeBaseConfig(), other.knowledgeBaseConfig())
                && Objects.equals(precomputedRagSourceConfig(), other.precomputedRagSourceConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RAGConfig").add("KnowledgeBaseConfig", knowledgeBaseConfig())
                .add("PrecomputedRagSourceConfig", precomputedRagSourceConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "knowledgeBaseConfig":
            return Optional.ofNullable(clazz.cast(knowledgeBaseConfig()));
        case "precomputedRagSourceConfig":
            return Optional.ofNullable(clazz.cast(precomputedRagSourceConfig()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #knowledgeBaseConfig()} initialized to the given value.
     *
     * <p>
     * Contains configuration details for knowledge base retrieval and response generation.
     * </p>
     * 
     * @param knowledgeBaseConfig
     *        Contains configuration details for knowledge base retrieval and response generation.
     */
    public static RAGConfig fromKnowledgeBaseConfig(KnowledgeBaseConfig knowledgeBaseConfig) {
        return builder().knowledgeBaseConfig(knowledgeBaseConfig).build();
    }

    /**
     * Create an instance of this class with {@link #knowledgeBaseConfig()} initialized to the given value.
     *
     * <p>
     * Contains configuration details for knowledge base retrieval and response generation.
     * </p>
     * 
     * @param knowledgeBaseConfig
     *        Contains configuration details for knowledge base retrieval and response generation.
     */
    public static RAGConfig fromKnowledgeBaseConfig(Consumer<KnowledgeBaseConfig.Builder> knowledgeBaseConfig) {
        KnowledgeBaseConfig.Builder builder = KnowledgeBaseConfig.builder();
        knowledgeBaseConfig.accept(builder);
        return fromKnowledgeBaseConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #precomputedRagSourceConfig()} initialized to the given value.
     *
     * <p>
     * Contains configuration details about the RAG source used to generate inference response data for a Knowledge Base
     * evaluation job.
     * </p>
     * 
     * @param precomputedRagSourceConfig
     *        Contains configuration details about the RAG source used to generate inference response data for a
     *        Knowledge Base evaluation job.
     */
    public static RAGConfig fromPrecomputedRagSourceConfig(EvaluationPrecomputedRagSourceConfig precomputedRagSourceConfig) {
        return builder().precomputedRagSourceConfig(precomputedRagSourceConfig).build();
    }

    /**
     * Create an instance of this class with {@link #precomputedRagSourceConfig()} initialized to the given value.
     *
     * <p>
     * Contains configuration details about the RAG source used to generate inference response data for a Knowledge Base
     * evaluation job.
     * </p>
     * 
     * @param precomputedRagSourceConfig
     *        Contains configuration details about the RAG source used to generate inference response data for a
     *        Knowledge Base evaluation job.
     */
    public static RAGConfig fromPrecomputedRagSourceConfig(
            Consumer<EvaluationPrecomputedRagSourceConfig.Builder> precomputedRagSourceConfig) {
        EvaluationPrecomputedRagSourceConfig.Builder builder = EvaluationPrecomputedRagSourceConfig.builder();
        precomputedRagSourceConfig.accept(builder);
        return fromPrecomputedRagSourceConfig(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("knowledgeBaseConfig", KNOWLEDGE_BASE_CONFIG_FIELD);
        map.put("precomputedRagSourceConfig", PRECOMPUTED_RAG_SOURCE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RAGConfig, T> g) {
        return obj -> g.apply((RAGConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RAGConfig> {
        /**
         * <p>
         * Contains configuration details for knowledge base retrieval and response generation.
         * </p>
         * 
         * @param knowledgeBaseConfig
         *        Contains configuration details for knowledge base retrieval and response generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseConfig(KnowledgeBaseConfig knowledgeBaseConfig);

        /**
         * <p>
         * Contains configuration details for knowledge base retrieval and response generation.
         * </p>
         * This is a convenience method that creates an instance of the {@link KnowledgeBaseConfig.Builder} avoiding the
         * need to create one manually via {@link KnowledgeBaseConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KnowledgeBaseConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #knowledgeBaseConfig(KnowledgeBaseConfig)}.
         * 
         * @param knowledgeBaseConfig
         *        a consumer that will call methods on {@link KnowledgeBaseConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #knowledgeBaseConfig(KnowledgeBaseConfig)
         */
        default Builder knowledgeBaseConfig(Consumer<KnowledgeBaseConfig.Builder> knowledgeBaseConfig) {
            return knowledgeBaseConfig(KnowledgeBaseConfig.builder().applyMutation(knowledgeBaseConfig).build());
        }

        /**
         * <p>
         * Contains configuration details about the RAG source used to generate inference response data for a Knowledge
         * Base evaluation job.
         * </p>
         * 
         * @param precomputedRagSourceConfig
         *        Contains configuration details about the RAG source used to generate inference response data for a
         *        Knowledge Base evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder precomputedRagSourceConfig(EvaluationPrecomputedRagSourceConfig precomputedRagSourceConfig);

        /**
         * <p>
         * Contains configuration details about the RAG source used to generate inference response data for a Knowledge
         * Base evaluation job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EvaluationPrecomputedRagSourceConfig.Builder} avoiding the need to create one manually via
         * {@link EvaluationPrecomputedRagSourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationPrecomputedRagSourceConfig.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #precomputedRagSourceConfig(EvaluationPrecomputedRagSourceConfig)}.
         * 
         * @param precomputedRagSourceConfig
         *        a consumer that will call methods on {@link EvaluationPrecomputedRagSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #precomputedRagSourceConfig(EvaluationPrecomputedRagSourceConfig)
         */
        default Builder precomputedRagSourceConfig(
                Consumer<EvaluationPrecomputedRagSourceConfig.Builder> precomputedRagSourceConfig) {
            return precomputedRagSourceConfig(EvaluationPrecomputedRagSourceConfig.builder()
                    .applyMutation(precomputedRagSourceConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private KnowledgeBaseConfig knowledgeBaseConfig;

        private EvaluationPrecomputedRagSourceConfig precomputedRagSourceConfig;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RAGConfig model) {
            knowledgeBaseConfig(model.knowledgeBaseConfig);
            precomputedRagSourceConfig(model.precomputedRagSourceConfig);
        }

        public final KnowledgeBaseConfig.Builder getKnowledgeBaseConfig() {
            return knowledgeBaseConfig != null ? knowledgeBaseConfig.toBuilder() : null;
        }

        public final void setKnowledgeBaseConfig(KnowledgeBaseConfig.BuilderImpl knowledgeBaseConfig) {
            Object oldValue = this.knowledgeBaseConfig;
            this.knowledgeBaseConfig = knowledgeBaseConfig != null ? knowledgeBaseConfig.build() : null;
            handleUnionValueChange(Type.KNOWLEDGE_BASE_CONFIG, oldValue, this.knowledgeBaseConfig);
        }

        @Override
        public final Builder knowledgeBaseConfig(KnowledgeBaseConfig knowledgeBaseConfig) {
            Object oldValue = this.knowledgeBaseConfig;
            this.knowledgeBaseConfig = knowledgeBaseConfig;
            handleUnionValueChange(Type.KNOWLEDGE_BASE_CONFIG, oldValue, this.knowledgeBaseConfig);
            return this;
        }

        public final EvaluationPrecomputedRagSourceConfig.Builder getPrecomputedRagSourceConfig() {
            return precomputedRagSourceConfig != null ? precomputedRagSourceConfig.toBuilder() : null;
        }

        public final void setPrecomputedRagSourceConfig(
                EvaluationPrecomputedRagSourceConfig.BuilderImpl precomputedRagSourceConfig) {
            Object oldValue = this.precomputedRagSourceConfig;
            this.precomputedRagSourceConfig = precomputedRagSourceConfig != null ? precomputedRagSourceConfig.build() : null;
            handleUnionValueChange(Type.PRECOMPUTED_RAG_SOURCE_CONFIG, oldValue, this.precomputedRagSourceConfig);
        }

        @Override
        public final Builder precomputedRagSourceConfig(EvaluationPrecomputedRagSourceConfig precomputedRagSourceConfig) {
            Object oldValue = this.precomputedRagSourceConfig;
            this.precomputedRagSourceConfig = precomputedRagSourceConfig;
            handleUnionValueChange(Type.PRECOMPUTED_RAG_SOURCE_CONFIG, oldValue, this.precomputedRagSourceConfig);
            return this;
        }

        @Override
        public RAGConfig build() {
            return new RAGConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RAGConfig#type()
     */
    public enum Type {
        KNOWLEDGE_BASE_CONFIG,

        PRECOMPUTED_RAG_SOURCE_CONFIG,

        UNKNOWN_TO_SDK_VERSION
    }
}
