/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about topics that the guardrail should identify and deny.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailTopicPolicyConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailTopicPolicyConfig.Builder, GuardrailTopicPolicyConfig> {
    private static final SdkField<List<GuardrailTopicConfig>> TOPICS_CONFIG_FIELD = SdkField
            .<List<GuardrailTopicConfig>> builder(MarshallingType.LIST)
            .memberName("topicsConfig")
            .getter(getter(GuardrailTopicPolicyConfig::topicsConfig))
            .setter(setter(Builder::topicsConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicsConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GuardrailTopicConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(GuardrailTopicConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPICS_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<GuardrailTopicConfig> topicsConfig;

    private GuardrailTopicPolicyConfig(BuilderImpl builder) {
        this.topicsConfig = builder.topicsConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the TopicsConfig property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTopicsConfig() {
        return topicsConfig != null && !(topicsConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of policies related to topics that the guardrail should deny.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTopicsConfig} method.
     * </p>
     * 
     * @return A list of policies related to topics that the guardrail should deny.
     */
    public final List<GuardrailTopicConfig> topicsConfig() {
        return topicsConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTopicsConfig() ? topicsConfig() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailTopicPolicyConfig)) {
            return false;
        }
        GuardrailTopicPolicyConfig other = (GuardrailTopicPolicyConfig) obj;
        return hasTopicsConfig() == other.hasTopicsConfig() && Objects.equals(topicsConfig(), other.topicsConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailTopicPolicyConfig").add("TopicsConfig", hasTopicsConfig() ? topicsConfig() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "topicsConfig":
            return Optional.ofNullable(clazz.cast(topicsConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("topicsConfig", TOPICS_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailTopicPolicyConfig, T> g) {
        return obj -> g.apply((GuardrailTopicPolicyConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailTopicPolicyConfig> {
        /**
         * <p>
         * A list of policies related to topics that the guardrail should deny.
         * </p>
         * 
         * @param topicsConfig
         *        A list of policies related to topics that the guardrail should deny.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicsConfig(Collection<GuardrailTopicConfig> topicsConfig);

        /**
         * <p>
         * A list of policies related to topics that the guardrail should deny.
         * </p>
         * 
         * @param topicsConfig
         *        A list of policies related to topics that the guardrail should deny.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicsConfig(GuardrailTopicConfig... topicsConfig);

        /**
         * <p>
         * A list of policies related to topics that the guardrail should deny.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.GuardrailTopicConfig.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.bedrock.model.GuardrailTopicConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.GuardrailTopicConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #topicsConfig(List<GuardrailTopicConfig>)}.
         * 
         * @param topicsConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.GuardrailTopicConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topicsConfig(java.util.Collection<GuardrailTopicConfig>)
         */
        Builder topicsConfig(Consumer<GuardrailTopicConfig.Builder>... topicsConfig);
    }

    static final class BuilderImpl implements Builder {
        private List<GuardrailTopicConfig> topicsConfig = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailTopicPolicyConfig model) {
            topicsConfig(model.topicsConfig);
        }

        public final List<GuardrailTopicConfig.Builder> getTopicsConfig() {
            List<GuardrailTopicConfig.Builder> result = GuardrailTopicsConfigCopier.copyToBuilder(this.topicsConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopicsConfig(Collection<GuardrailTopicConfig.BuilderImpl> topicsConfig) {
            this.topicsConfig = GuardrailTopicsConfigCopier.copyFromBuilder(topicsConfig);
        }

        @Override
        public final Builder topicsConfig(Collection<GuardrailTopicConfig> topicsConfig) {
            this.topicsConfig = GuardrailTopicsConfigCopier.copy(topicsConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicsConfig(GuardrailTopicConfig... topicsConfig) {
            topicsConfig(Arrays.asList(topicsConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicsConfig(Consumer<GuardrailTopicConfig.Builder>... topicsConfig) {
            topicsConfig(Stream.of(topicsConfig).map(c -> GuardrailTopicConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GuardrailTopicPolicyConfig build() {
            return new GuardrailTopicPolicyConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
