/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about PII entities and regular expressions to configure for the guardrail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailSensitiveInformationPolicyConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailSensitiveInformationPolicyConfig.Builder, GuardrailSensitiveInformationPolicyConfig> {
    private static final SdkField<List<GuardrailPiiEntityConfig>> PII_ENTITIES_CONFIG_FIELD = SdkField
            .<List<GuardrailPiiEntityConfig>> builder(MarshallingType.LIST)
            .memberName("piiEntitiesConfig")
            .getter(getter(GuardrailSensitiveInformationPolicyConfig::piiEntitiesConfig))
            .setter(setter(Builder::piiEntitiesConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("piiEntitiesConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GuardrailPiiEntityConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(GuardrailPiiEntityConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<GuardrailRegexConfig>> REGEXES_CONFIG_FIELD = SdkField
            .<List<GuardrailRegexConfig>> builder(MarshallingType.LIST)
            .memberName("regexesConfig")
            .getter(getter(GuardrailSensitiveInformationPolicyConfig::regexesConfig))
            .setter(setter(Builder::regexesConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regexesConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GuardrailRegexConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(GuardrailRegexConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PII_ENTITIES_CONFIG_FIELD,
            REGEXES_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<GuardrailPiiEntityConfig> piiEntitiesConfig;

    private final List<GuardrailRegexConfig> regexesConfig;

    private GuardrailSensitiveInformationPolicyConfig(BuilderImpl builder) {
        this.piiEntitiesConfig = builder.piiEntitiesConfig;
        this.regexesConfig = builder.regexesConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the PiiEntitiesConfig property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPiiEntitiesConfig() {
        return piiEntitiesConfig != null && !(piiEntitiesConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of PII entities to configure to the guardrail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPiiEntitiesConfig} method.
     * </p>
     * 
     * @return A list of PII entities to configure to the guardrail.
     */
    public final List<GuardrailPiiEntityConfig> piiEntitiesConfig() {
        return piiEntitiesConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegexesConfig property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRegexesConfig() {
        return regexesConfig != null && !(regexesConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of regular expressions to configure to the guardrail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegexesConfig} method.
     * </p>
     * 
     * @return A list of regular expressions to configure to the guardrail.
     */
    public final List<GuardrailRegexConfig> regexesConfig() {
        return regexesConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPiiEntitiesConfig() ? piiEntitiesConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRegexesConfig() ? regexesConfig() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailSensitiveInformationPolicyConfig)) {
            return false;
        }
        GuardrailSensitiveInformationPolicyConfig other = (GuardrailSensitiveInformationPolicyConfig) obj;
        return hasPiiEntitiesConfig() == other.hasPiiEntitiesConfig()
                && Objects.equals(piiEntitiesConfig(), other.piiEntitiesConfig())
                && hasRegexesConfig() == other.hasRegexesConfig() && Objects.equals(regexesConfig(), other.regexesConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailSensitiveInformationPolicyConfig")
                .add("PiiEntitiesConfig", hasPiiEntitiesConfig() ? piiEntitiesConfig() : null)
                .add("RegexesConfig", hasRegexesConfig() ? regexesConfig() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "piiEntitiesConfig":
            return Optional.ofNullable(clazz.cast(piiEntitiesConfig()));
        case "regexesConfig":
            return Optional.ofNullable(clazz.cast(regexesConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("piiEntitiesConfig", PII_ENTITIES_CONFIG_FIELD);
        map.put("regexesConfig", REGEXES_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailSensitiveInformationPolicyConfig, T> g) {
        return obj -> g.apply((GuardrailSensitiveInformationPolicyConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailSensitiveInformationPolicyConfig> {
        /**
         * <p>
         * A list of PII entities to configure to the guardrail.
         * </p>
         * 
         * @param piiEntitiesConfig
         *        A list of PII entities to configure to the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder piiEntitiesConfig(Collection<GuardrailPiiEntityConfig> piiEntitiesConfig);

        /**
         * <p>
         * A list of PII entities to configure to the guardrail.
         * </p>
         * 
         * @param piiEntitiesConfig
         *        A list of PII entities to configure to the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder piiEntitiesConfig(GuardrailPiiEntityConfig... piiEntitiesConfig);

        /**
         * <p>
         * A list of PII entities to configure to the guardrail.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityConfig.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #piiEntitiesConfig(List<GuardrailPiiEntityConfig>)}.
         * 
         * @param piiEntitiesConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #piiEntitiesConfig(java.util.Collection<GuardrailPiiEntityConfig>)
         */
        Builder piiEntitiesConfig(Consumer<GuardrailPiiEntityConfig.Builder>... piiEntitiesConfig);

        /**
         * <p>
         * A list of regular expressions to configure to the guardrail.
         * </p>
         * 
         * @param regexesConfig
         *        A list of regular expressions to configure to the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexesConfig(Collection<GuardrailRegexConfig> regexesConfig);

        /**
         * <p>
         * A list of regular expressions to configure to the guardrail.
         * </p>
         * 
         * @param regexesConfig
         *        A list of regular expressions to configure to the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexesConfig(GuardrailRegexConfig... regexesConfig);

        /**
         * <p>
         * A list of regular expressions to configure to the guardrail.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.GuardrailRegexConfig.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.bedrock.model.GuardrailRegexConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.GuardrailRegexConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #regexesConfig(List<GuardrailRegexConfig>)}.
         * 
         * @param regexesConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.GuardrailRegexConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regexesConfig(java.util.Collection<GuardrailRegexConfig>)
         */
        Builder regexesConfig(Consumer<GuardrailRegexConfig.Builder>... regexesConfig);
    }

    static final class BuilderImpl implements Builder {
        private List<GuardrailPiiEntityConfig> piiEntitiesConfig = DefaultSdkAutoConstructList.getInstance();

        private List<GuardrailRegexConfig> regexesConfig = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailSensitiveInformationPolicyConfig model) {
            piiEntitiesConfig(model.piiEntitiesConfig);
            regexesConfig(model.regexesConfig);
        }

        public final List<GuardrailPiiEntityConfig.Builder> getPiiEntitiesConfig() {
            List<GuardrailPiiEntityConfig.Builder> result = GuardrailPiiEntitiesConfigCopier
                    .copyToBuilder(this.piiEntitiesConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPiiEntitiesConfig(Collection<GuardrailPiiEntityConfig.BuilderImpl> piiEntitiesConfig) {
            this.piiEntitiesConfig = GuardrailPiiEntitiesConfigCopier.copyFromBuilder(piiEntitiesConfig);
        }

        @Override
        public final Builder piiEntitiesConfig(Collection<GuardrailPiiEntityConfig> piiEntitiesConfig) {
            this.piiEntitiesConfig = GuardrailPiiEntitiesConfigCopier.copy(piiEntitiesConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder piiEntitiesConfig(GuardrailPiiEntityConfig... piiEntitiesConfig) {
            piiEntitiesConfig(Arrays.asList(piiEntitiesConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder piiEntitiesConfig(Consumer<GuardrailPiiEntityConfig.Builder>... piiEntitiesConfig) {
            piiEntitiesConfig(Stream.of(piiEntitiesConfig).map(c -> GuardrailPiiEntityConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<GuardrailRegexConfig.Builder> getRegexesConfig() {
            List<GuardrailRegexConfig.Builder> result = GuardrailRegexesConfigCopier.copyToBuilder(this.regexesConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegexesConfig(Collection<GuardrailRegexConfig.BuilderImpl> regexesConfig) {
            this.regexesConfig = GuardrailRegexesConfigCopier.copyFromBuilder(regexesConfig);
        }

        @Override
        public final Builder regexesConfig(Collection<GuardrailRegexConfig> regexesConfig) {
            this.regexesConfig = GuardrailRegexesConfigCopier.copy(regexesConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexesConfig(GuardrailRegexConfig... regexesConfig) {
            regexesConfig(Arrays.asList(regexesConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexesConfig(Consumer<GuardrailRegexConfig.Builder>... regexesConfig) {
            regexesConfig(Stream.of(regexesConfig).map(c -> GuardrailRegexConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GuardrailSensitiveInformationPolicyConfig build() {
            return new GuardrailSensitiveInformationPolicyConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
