/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about PII entities and regular expressions configured for the guardrail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailSensitiveInformationPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailSensitiveInformationPolicy.Builder, GuardrailSensitiveInformationPolicy> {
    private static final SdkField<List<GuardrailPiiEntity>> PII_ENTITIES_FIELD = SdkField
            .<List<GuardrailPiiEntity>> builder(MarshallingType.LIST)
            .memberName("piiEntities")
            .getter(getter(GuardrailSensitiveInformationPolicy::piiEntities))
            .setter(setter(Builder::piiEntities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("piiEntities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GuardrailPiiEntity> builder(MarshallingType.SDK_POJO)
                                            .constructor(GuardrailPiiEntity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<GuardrailRegex>> REGEXES_FIELD = SdkField
            .<List<GuardrailRegex>> builder(MarshallingType.LIST)
            .memberName("regexes")
            .getter(getter(GuardrailSensitiveInformationPolicy::regexes))
            .setter(setter(Builder::regexes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regexes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GuardrailRegex> builder(MarshallingType.SDK_POJO)
                                            .constructor(GuardrailRegex::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PII_ENTITIES_FIELD,
            REGEXES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<GuardrailPiiEntity> piiEntities;

    private final List<GuardrailRegex> regexes;

    private GuardrailSensitiveInformationPolicy(BuilderImpl builder) {
        this.piiEntities = builder.piiEntities;
        this.regexes = builder.regexes;
    }

    /**
     * For responses, this returns true if the service returned a value for the PiiEntities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPiiEntities() {
        return piiEntities != null && !(piiEntities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of PII entities configured for the guardrail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPiiEntities} method.
     * </p>
     * 
     * @return The list of PII entities configured for the guardrail.
     */
    public final List<GuardrailPiiEntity> piiEntities() {
        return piiEntities;
    }

    /**
     * For responses, this returns true if the service returned a value for the Regexes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegexes() {
        return regexes != null && !(regexes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of regular expressions configured for the guardrail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegexes} method.
     * </p>
     * 
     * @return The list of regular expressions configured for the guardrail.
     */
    public final List<GuardrailRegex> regexes() {
        return regexes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPiiEntities() ? piiEntities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRegexes() ? regexes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailSensitiveInformationPolicy)) {
            return false;
        }
        GuardrailSensitiveInformationPolicy other = (GuardrailSensitiveInformationPolicy) obj;
        return hasPiiEntities() == other.hasPiiEntities() && Objects.equals(piiEntities(), other.piiEntities())
                && hasRegexes() == other.hasRegexes() && Objects.equals(regexes(), other.regexes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailSensitiveInformationPolicy")
                .add("PiiEntities", hasPiiEntities() ? piiEntities() : null).add("Regexes", hasRegexes() ? regexes() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "piiEntities":
            return Optional.ofNullable(clazz.cast(piiEntities()));
        case "regexes":
            return Optional.ofNullable(clazz.cast(regexes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("piiEntities", PII_ENTITIES_FIELD);
        map.put("regexes", REGEXES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailSensitiveInformationPolicy, T> g) {
        return obj -> g.apply((GuardrailSensitiveInformationPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailSensitiveInformationPolicy> {
        /**
         * <p>
         * The list of PII entities configured for the guardrail.
         * </p>
         * 
         * @param piiEntities
         *        The list of PII entities configured for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder piiEntities(Collection<GuardrailPiiEntity> piiEntities);

        /**
         * <p>
         * The list of PII entities configured for the guardrail.
         * </p>
         * 
         * @param piiEntities
         *        The list of PII entities configured for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder piiEntities(GuardrailPiiEntity... piiEntities);

        /**
         * <p>
         * The list of PII entities configured for the guardrail.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntity.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntity.Builder#build()} is called
         * immediately and its result is passed to {@link #piiEntities(List<GuardrailPiiEntity>)}.
         * 
         * @param piiEntities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #piiEntities(java.util.Collection<GuardrailPiiEntity>)
         */
        Builder piiEntities(Consumer<GuardrailPiiEntity.Builder>... piiEntities);

        /**
         * <p>
         * The list of regular expressions configured for the guardrail.
         * </p>
         * 
         * @param regexes
         *        The list of regular expressions configured for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexes(Collection<GuardrailRegex> regexes);

        /**
         * <p>
         * The list of regular expressions configured for the guardrail.
         * </p>
         * 
         * @param regexes
         *        The list of regular expressions configured for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexes(GuardrailRegex... regexes);

        /**
         * <p>
         * The list of regular expressions configured for the guardrail.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.GuardrailRegex.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.bedrock.model.GuardrailRegex#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.GuardrailRegex.Builder#build()} is called immediately
         * and its result is passed to {@link #regexes(List<GuardrailRegex>)}.
         * 
         * @param regexes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.GuardrailRegex.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regexes(java.util.Collection<GuardrailRegex>)
         */
        Builder regexes(Consumer<GuardrailRegex.Builder>... regexes);
    }

    static final class BuilderImpl implements Builder {
        private List<GuardrailPiiEntity> piiEntities = DefaultSdkAutoConstructList.getInstance();

        private List<GuardrailRegex> regexes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailSensitiveInformationPolicy model) {
            piiEntities(model.piiEntities);
            regexes(model.regexes);
        }

        public final List<GuardrailPiiEntity.Builder> getPiiEntities() {
            List<GuardrailPiiEntity.Builder> result = GuardrailPiiEntitiesCopier.copyToBuilder(this.piiEntities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPiiEntities(Collection<GuardrailPiiEntity.BuilderImpl> piiEntities) {
            this.piiEntities = GuardrailPiiEntitiesCopier.copyFromBuilder(piiEntities);
        }

        @Override
        public final Builder piiEntities(Collection<GuardrailPiiEntity> piiEntities) {
            this.piiEntities = GuardrailPiiEntitiesCopier.copy(piiEntities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder piiEntities(GuardrailPiiEntity... piiEntities) {
            piiEntities(Arrays.asList(piiEntities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder piiEntities(Consumer<GuardrailPiiEntity.Builder>... piiEntities) {
            piiEntities(Stream.of(piiEntities).map(c -> GuardrailPiiEntity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<GuardrailRegex.Builder> getRegexes() {
            List<GuardrailRegex.Builder> result = GuardrailRegexesCopier.copyToBuilder(this.regexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegexes(Collection<GuardrailRegex.BuilderImpl> regexes) {
            this.regexes = GuardrailRegexesCopier.copyFromBuilder(regexes);
        }

        @Override
        public final Builder regexes(Collection<GuardrailRegex> regexes) {
            this.regexes = GuardrailRegexesCopier.copy(regexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexes(GuardrailRegex... regexes) {
            regexes(Arrays.asList(regexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexes(Consumer<GuardrailRegex.Builder>... regexes) {
            regexes(Stream.of(regexes).map(c -> GuardrailRegex.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GuardrailSensitiveInformationPolicy build() {
            return new GuardrailSensitiveInformationPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
