/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The managed word list to configure for the guardrail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailManagedWordsConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailManagedWordsConfig.Builder, GuardrailManagedWordsConfig> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GuardrailManagedWordsConfig::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> INPUT_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputAction").getter(getter(GuardrailManagedWordsConfig::inputActionAsString))
            .setter(setter(Builder::inputAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputAction").build()).build();

    private static final SdkField<String> OUTPUT_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputAction").getter(getter(GuardrailManagedWordsConfig::outputActionAsString))
            .setter(setter(Builder::outputAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputAction").build()).build();

    private static final SdkField<Boolean> INPUT_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("inputEnabled").getter(getter(GuardrailManagedWordsConfig::inputEnabled))
            .setter(setter(Builder::inputEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputEnabled").build()).build();

    private static final SdkField<Boolean> OUTPUT_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("outputEnabled").getter(getter(GuardrailManagedWordsConfig::outputEnabled))
            .setter(setter(Builder::outputEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            INPUT_ACTION_FIELD, OUTPUT_ACTION_FIELD, INPUT_ENABLED_FIELD, OUTPUT_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String inputAction;

    private final String outputAction;

    private final Boolean inputEnabled;

    private final Boolean outputEnabled;

    private GuardrailManagedWordsConfig(BuilderImpl builder) {
        this.type = builder.type;
        this.inputAction = builder.inputAction;
        this.outputAction = builder.outputAction;
        this.inputEnabled = builder.inputEnabled;
        this.outputEnabled = builder.outputEnabled;
    }

    /**
     * <p>
     * The managed word type to configure for the guardrail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GuardrailManagedWordsType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The managed word type to configure for the guardrail.
     * @see GuardrailManagedWordsType
     */
    public final GuardrailManagedWordsType type() {
        return GuardrailManagedWordsType.fromValue(type);
    }

    /**
     * <p>
     * The managed word type to configure for the guardrail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GuardrailManagedWordsType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The managed word type to configure for the guardrail.
     * @see GuardrailManagedWordsType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Specifies the action to take when harmful content is detected in the input. Supported values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code> – Take no action but return detection information in the trace response.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputAction} will
     * return {@link GuardrailWordAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #inputActionAsString}.
     * </p>
     * 
     * @return Specifies the action to take when harmful content is detected in the input. Supported values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code> – Take no action but return detection information in the trace response.
     *         </p>
     *         </li>
     * @see GuardrailWordAction
     */
    public final GuardrailWordAction inputAction() {
        return GuardrailWordAction.fromValue(inputAction);
    }

    /**
     * <p>
     * Specifies the action to take when harmful content is detected in the input. Supported values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code> – Take no action but return detection information in the trace response.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputAction} will
     * return {@link GuardrailWordAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #inputActionAsString}.
     * </p>
     * 
     * @return Specifies the action to take when harmful content is detected in the input. Supported values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code> – Take no action but return detection information in the trace response.
     *         </p>
     *         </li>
     * @see GuardrailWordAction
     */
    public final String inputActionAsString() {
        return inputAction;
    }

    /**
     * <p>
     * Specifies the action to take when harmful content is detected in the output. Supported values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code> – Take no action but return detection information in the trace response.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputAction} will
     * return {@link GuardrailWordAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #outputActionAsString}.
     * </p>
     * 
     * @return Specifies the action to take when harmful content is detected in the output. Supported values
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code> – Take no action but return detection information in the trace response.
     *         </p>
     *         </li>
     * @see GuardrailWordAction
     */
    public final GuardrailWordAction outputAction() {
        return GuardrailWordAction.fromValue(outputAction);
    }

    /**
     * <p>
     * Specifies the action to take when harmful content is detected in the output. Supported values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NONE</code> – Take no action but return detection information in the trace response.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputAction} will
     * return {@link GuardrailWordAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #outputActionAsString}.
     * </p>
     * 
     * @return Specifies the action to take when harmful content is detected in the output. Supported values
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BLOCK</code> – Block the content and replace it with blocked messaging.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NONE</code> – Take no action but return detection information in the trace response.
     *         </p>
     *         </li>
     * @see GuardrailWordAction
     */
    public final String outputActionAsString() {
        return outputAction;
    }

    /**
     * <p>
     * Specifies whether to enable guardrail evaluation on the input. When disabled, you aren't charged for the
     * evaluation. The evaluation doesn't appear in the response.
     * </p>
     * 
     * @return Specifies whether to enable guardrail evaluation on the input. When disabled, you aren't charged for the
     *         evaluation. The evaluation doesn't appear in the response.
     */
    public final Boolean inputEnabled() {
        return inputEnabled;
    }

    /**
     * <p>
     * Specifies whether to enable guardrail evaluation on the output. When disabled, you aren't charged for the
     * evaluation. The evaluation doesn't appear in the response.
     * </p>
     * 
     * @return Specifies whether to enable guardrail evaluation on the output. When disabled, you aren't charged for the
     *         evaluation. The evaluation doesn't appear in the response.
     */
    public final Boolean outputEnabled() {
        return outputEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inputActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outputActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inputEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(outputEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailManagedWordsConfig)) {
            return false;
        }
        GuardrailManagedWordsConfig other = (GuardrailManagedWordsConfig) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(inputActionAsString(), other.inputActionAsString())
                && Objects.equals(outputActionAsString(), other.outputActionAsString())
                && Objects.equals(inputEnabled(), other.inputEnabled()) && Objects.equals(outputEnabled(), other.outputEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailManagedWordsConfig").add("Type", typeAsString())
                .add("InputAction", inputActionAsString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("OutputAction", outputActionAsString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("InputEnabled", inputEnabled()).add("OutputEnabled", outputEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "inputAction":
            return Optional.ofNullable(clazz.cast(inputActionAsString()));
        case "outputAction":
            return Optional.ofNullable(clazz.cast(outputActionAsString()));
        case "inputEnabled":
            return Optional.ofNullable(clazz.cast(inputEnabled()));
        case "outputEnabled":
            return Optional.ofNullable(clazz.cast(outputEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("inputAction", INPUT_ACTION_FIELD);
        map.put("outputAction", OUTPUT_ACTION_FIELD);
        map.put("inputEnabled", INPUT_ENABLED_FIELD);
        map.put("outputEnabled", OUTPUT_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailManagedWordsConfig, T> g) {
        return obj -> g.apply((GuardrailManagedWordsConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailManagedWordsConfig> {
        /**
         * <p>
         * The managed word type to configure for the guardrail.
         * </p>
         * 
         * @param type
         *        The managed word type to configure for the guardrail.
         * @see GuardrailManagedWordsType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailManagedWordsType
         */
        Builder type(String type);

        /**
         * <p>
         * The managed word type to configure for the guardrail.
         * </p>
         * 
         * @param type
         *        The managed word type to configure for the guardrail.
         * @see GuardrailManagedWordsType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailManagedWordsType
         */
        Builder type(GuardrailManagedWordsType type);

        /**
         * <p>
         * Specifies the action to take when harmful content is detected in the input. Supported values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code> – Take no action but return detection information in the trace response.
         * </p>
         * </li>
         * </ul>
         * 
         * @param inputAction
         *        Specifies the action to take when harmful content is detected in the input. Supported values
         *        include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code> – Take no action but return detection information in the trace response.
         *        </p>
         *        </li>
         * @see GuardrailWordAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailWordAction
         */
        Builder inputAction(String inputAction);

        /**
         * <p>
         * Specifies the action to take when harmful content is detected in the input. Supported values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code> – Take no action but return detection information in the trace response.
         * </p>
         * </li>
         * </ul>
         * 
         * @param inputAction
         *        Specifies the action to take when harmful content is detected in the input. Supported values
         *        include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code> – Take no action but return detection information in the trace response.
         *        </p>
         *        </li>
         * @see GuardrailWordAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailWordAction
         */
        Builder inputAction(GuardrailWordAction inputAction);

        /**
         * <p>
         * Specifies the action to take when harmful content is detected in the output. Supported values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code> – Take no action but return detection information in the trace response.
         * </p>
         * </li>
         * </ul>
         * 
         * @param outputAction
         *        Specifies the action to take when harmful content is detected in the output. Supported values
         *        include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code> – Take no action but return detection information in the trace response.
         *        </p>
         *        </li>
         * @see GuardrailWordAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailWordAction
         */
        Builder outputAction(String outputAction);

        /**
         * <p>
         * Specifies the action to take when harmful content is detected in the output. Supported values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NONE</code> – Take no action but return detection information in the trace response.
         * </p>
         * </li>
         * </ul>
         * 
         * @param outputAction
         *        Specifies the action to take when harmful content is detected in the output. Supported values
         *        include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BLOCK</code> – Block the content and replace it with blocked messaging.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NONE</code> – Take no action but return detection information in the trace response.
         *        </p>
         *        </li>
         * @see GuardrailWordAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailWordAction
         */
        Builder outputAction(GuardrailWordAction outputAction);

        /**
         * <p>
         * Specifies whether to enable guardrail evaluation on the input. When disabled, you aren't charged for the
         * evaluation. The evaluation doesn't appear in the response.
         * </p>
         * 
         * @param inputEnabled
         *        Specifies whether to enable guardrail evaluation on the input. When disabled, you aren't charged for
         *        the evaluation. The evaluation doesn't appear in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputEnabled(Boolean inputEnabled);

        /**
         * <p>
         * Specifies whether to enable guardrail evaluation on the output. When disabled, you aren't charged for the
         * evaluation. The evaluation doesn't appear in the response.
         * </p>
         * 
         * @param outputEnabled
         *        Specifies whether to enable guardrail evaluation on the output. When disabled, you aren't charged for
         *        the evaluation. The evaluation doesn't appear in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputEnabled(Boolean outputEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String inputAction;

        private String outputAction;

        private Boolean inputEnabled;

        private Boolean outputEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailManagedWordsConfig model) {
            type(model.type);
            inputAction(model.inputAction);
            outputAction(model.outputAction);
            inputEnabled(model.inputEnabled);
            outputEnabled(model.outputEnabled);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GuardrailManagedWordsType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getInputAction() {
            return inputAction;
        }

        public final void setInputAction(String inputAction) {
            this.inputAction = inputAction;
        }

        @Override
        public final Builder inputAction(String inputAction) {
            this.inputAction = inputAction;
            return this;
        }

        @Override
        public final Builder inputAction(GuardrailWordAction inputAction) {
            this.inputAction(inputAction == null ? null : inputAction.toString());
            return this;
        }

        public final String getOutputAction() {
            return outputAction;
        }

        public final void setOutputAction(String outputAction) {
            this.outputAction = outputAction;
        }

        @Override
        public final Builder outputAction(String outputAction) {
            this.outputAction = outputAction;
            return this;
        }

        @Override
        public final Builder outputAction(GuardrailWordAction outputAction) {
            this.outputAction(outputAction == null ? null : outputAction.toString());
            return this;
        }

        public final Boolean getInputEnabled() {
            return inputEnabled;
        }

        public final void setInputEnabled(Boolean inputEnabled) {
            this.inputEnabled = inputEnabled;
        }

        @Override
        public final Builder inputEnabled(Boolean inputEnabled) {
            this.inputEnabled = inputEnabled;
            return this;
        }

        public final Boolean getOutputEnabled() {
            return outputEnabled;
        }

        public final void setOutputEnabled(Boolean outputEnabled) {
            this.outputEnabled = outputEnabled;
        }

        @Override
        public final Builder outputEnabled(Boolean outputEnabled) {
            this.outputEnabled = outputEnabled;
            return this;
        }

        @Override
        public GuardrailManagedWordsConfig build() {
            return new GuardrailManagedWordsConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
