/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.RatingScaleCopier;
import software.amazon.awssdk.services.bedrock.model.RatingScaleItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomMetricDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomMetricDefinition> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CustomMetricDefinition.getter(CustomMetricDefinition::name)).setter(CustomMetricDefinition.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> INSTRUCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instructions").getter(CustomMetricDefinition.getter(CustomMetricDefinition::instructions)).setter(CustomMetricDefinition.setter(Builder::instructions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instructions").build()}).build();
    private static final SdkField<List<RatingScaleItem>> RATING_SCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ratingScale").getter(CustomMetricDefinition.getter(CustomMetricDefinition::ratingScale)).setter(CustomMetricDefinition.setter(Builder::ratingScale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ratingScale").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RatingScaleItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INSTRUCTIONS_FIELD, RATING_SCALE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomMetricDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String instructions;
    private final List<RatingScaleItem> ratingScale;

    private CustomMetricDefinition(BuilderImpl builder) {
        this.name = builder.name;
        this.instructions = builder.instructions;
        this.ratingScale = builder.ratingScale;
    }

    public final String name() {
        return this.name;
    }

    public final String instructions() {
        return this.instructions;
    }

    public final boolean hasRatingScale() {
        return this.ratingScale != null && !(this.ratingScale instanceof SdkAutoConstructList);
    }

    public final List<RatingScaleItem> ratingScale() {
        return this.ratingScale;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.instructions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRatingScale() ? this.ratingScale() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomMetricDefinition)) {
            return false;
        }
        CustomMetricDefinition other = (CustomMetricDefinition)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.instructions(), other.instructions()) && this.hasRatingScale() == other.hasRatingScale() && Objects.equals(this.ratingScale(), other.ratingScale());
    }

    public final String toString() {
        return ToString.builder((String)"CustomMetricDefinition").add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Instructions", (Object)this.instructions()).add("RatingScale", this.hasRatingScale() ? this.ratingScale() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "instructions": {
                return Optional.ofNullable(clazz.cast(this.instructions()));
            }
            case "ratingScale": {
                return Optional.ofNullable(clazz.cast(this.ratingScale()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("instructions", INSTRUCTIONS_FIELD);
        map.put("ratingScale", RATING_SCALE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomMetricDefinition, T> g) {
        return obj -> g.apply((CustomMetricDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String instructions;
        private List<RatingScaleItem> ratingScale = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomMetricDefinition model) {
            this.name(model.name);
            this.instructions(model.instructions);
            this.ratingScale(model.ratingScale);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getInstructions() {
            return this.instructions;
        }

        public final void setInstructions(String instructions) {
            this.instructions = instructions;
        }

        @Override
        public final Builder instructions(String instructions) {
            this.instructions = instructions;
            return this;
        }

        public final List<RatingScaleItem.Builder> getRatingScale() {
            List<RatingScaleItem.Builder> result = RatingScaleCopier.copyToBuilder(this.ratingScale);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRatingScale(Collection<RatingScaleItem.BuilderImpl> ratingScale) {
            this.ratingScale = RatingScaleCopier.copyFromBuilder(ratingScale);
        }

        @Override
        public final Builder ratingScale(Collection<RatingScaleItem> ratingScale) {
            this.ratingScale = RatingScaleCopier.copy(ratingScale);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ratingScale(RatingScaleItem ... ratingScale) {
            this.ratingScale(Arrays.asList(ratingScale));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ratingScale(Consumer<RatingScaleItem.Builder> ... ratingScale) {
            this.ratingScale(Stream.of(ratingScale).map(c -> (RatingScaleItem)((RatingScaleItem.Builder)RatingScaleItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CustomMetricDefinition build() {
            return new CustomMetricDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomMetricDefinition> {
        public Builder name(String var1);

        public Builder instructions(String var1);

        public Builder ratingScale(Collection<RatingScaleItem> var1);

        public Builder ratingScale(RatingScaleItem ... var1);

        public Builder ratingScale(Consumer<RatingScaleItem.Builder> ... var1);
    }
}

