/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.services.bedrock.model.InferenceProfileModel;
import software.amazon.awssdk.services.bedrock.model.InferenceProfileModelsCopier;
import software.amazon.awssdk.services.bedrock.model.InferenceProfileStatus;
import software.amazon.awssdk.services.bedrock.model.InferenceProfileType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetInferenceProfileResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, GetInferenceProfileResponse> {
    private static final SdkField<String> INFERENCE_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inferenceProfileName").getter(GetInferenceProfileResponse.getter(GetInferenceProfileResponse::inferenceProfileName)).setter(GetInferenceProfileResponse.setter(Builder::inferenceProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceProfileName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetInferenceProfileResponse.getter(GetInferenceProfileResponse::description)).setter(GetInferenceProfileResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetInferenceProfileResponse.getter(GetInferenceProfileResponse::createdAt)).setter(GetInferenceProfileResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetInferenceProfileResponse.getter(GetInferenceProfileResponse::updatedAt)).setter(GetInferenceProfileResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> INFERENCE_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inferenceProfileArn").getter(GetInferenceProfileResponse.getter(GetInferenceProfileResponse::inferenceProfileArn)).setter(GetInferenceProfileResponse.setter(Builder::inferenceProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceProfileArn").build()}).build();
    private static final SdkField<List<InferenceProfileModel>> MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("models").getter(GetInferenceProfileResponse.getter(GetInferenceProfileResponse::models)).setter(GetInferenceProfileResponse.setter(Builder::models)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("models").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InferenceProfileModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INFERENCE_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inferenceProfileId").getter(GetInferenceProfileResponse.getter(GetInferenceProfileResponse::inferenceProfileId)).setter(GetInferenceProfileResponse.setter(Builder::inferenceProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceProfileId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetInferenceProfileResponse.getter(GetInferenceProfileResponse::statusAsString)).setter(GetInferenceProfileResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(GetInferenceProfileResponse.getter(GetInferenceProfileResponse::typeAsString)).setter(GetInferenceProfileResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERENCE_PROFILE_NAME_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, INFERENCE_PROFILE_ARN_FIELD, MODELS_FIELD, INFERENCE_PROFILE_ID_FIELD, STATUS_FIELD, TYPE_FIELD));
    private final String inferenceProfileName;
    private final String description;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String inferenceProfileArn;
    private final List<InferenceProfileModel> models;
    private final String inferenceProfileId;
    private final String status;
    private final String type;

    private GetInferenceProfileResponse(BuilderImpl builder) {
        super(builder);
        this.inferenceProfileName = builder.inferenceProfileName;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.inferenceProfileArn = builder.inferenceProfileArn;
        this.models = builder.models;
        this.inferenceProfileId = builder.inferenceProfileId;
        this.status = builder.status;
        this.type = builder.type;
    }

    public final String inferenceProfileName() {
        return this.inferenceProfileName;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String inferenceProfileArn() {
        return this.inferenceProfileArn;
    }

    public final boolean hasModels() {
        return this.models != null && !(this.models instanceof SdkAutoConstructList);
    }

    public final List<InferenceProfileModel> models() {
        return this.models;
    }

    public final String inferenceProfileId() {
        return this.inferenceProfileId;
    }

    public final InferenceProfileStatus status() {
        return InferenceProfileStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final InferenceProfileType type() {
        return InferenceProfileType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModels() ? this.models() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInferenceProfileResponse)) {
            return false;
        }
        GetInferenceProfileResponse other = (GetInferenceProfileResponse)((Object)obj);
        return Objects.equals(this.inferenceProfileName(), other.inferenceProfileName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.inferenceProfileArn(), other.inferenceProfileArn()) && this.hasModels() == other.hasModels() && Objects.equals(this.models(), other.models()) && Objects.equals(this.inferenceProfileId(), other.inferenceProfileId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetInferenceProfileResponse").add("InferenceProfileName", (Object)this.inferenceProfileName()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("InferenceProfileArn", (Object)this.inferenceProfileArn()).add("Models", this.hasModels() ? this.models() : null).add("InferenceProfileId", (Object)this.inferenceProfileId()).add("Status", (Object)this.statusAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inferenceProfileName": {
                return Optional.ofNullable(clazz.cast(this.inferenceProfileName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "inferenceProfileArn": {
                return Optional.ofNullable(clazz.cast(this.inferenceProfileArn()));
            }
            case "models": {
                return Optional.ofNullable(clazz.cast(this.models()));
            }
            case "inferenceProfileId": {
                return Optional.ofNullable(clazz.cast(this.inferenceProfileId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInferenceProfileResponse, T> g) {
        return obj -> g.apply((GetInferenceProfileResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private String inferenceProfileName;
        private String description;
        private Instant createdAt;
        private Instant updatedAt;
        private String inferenceProfileArn;
        private List<InferenceProfileModel> models = DefaultSdkAutoConstructList.getInstance();
        private String inferenceProfileId;
        private String status;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInferenceProfileResponse model) {
            super(model);
            this.inferenceProfileName(model.inferenceProfileName);
            this.description(model.description);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.inferenceProfileArn(model.inferenceProfileArn);
            this.models(model.models);
            this.inferenceProfileId(model.inferenceProfileId);
            this.status(model.status);
            this.type(model.type);
        }

        public final String getInferenceProfileName() {
            return this.inferenceProfileName;
        }

        public final void setInferenceProfileName(String inferenceProfileName) {
            this.inferenceProfileName = inferenceProfileName;
        }

        @Override
        public final Builder inferenceProfileName(String inferenceProfileName) {
            this.inferenceProfileName = inferenceProfileName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getInferenceProfileArn() {
            return this.inferenceProfileArn;
        }

        public final void setInferenceProfileArn(String inferenceProfileArn) {
            this.inferenceProfileArn = inferenceProfileArn;
        }

        @Override
        public final Builder inferenceProfileArn(String inferenceProfileArn) {
            this.inferenceProfileArn = inferenceProfileArn;
            return this;
        }

        public final List<InferenceProfileModel.Builder> getModels() {
            List<InferenceProfileModel.Builder> result = InferenceProfileModelsCopier.copyToBuilder(this.models);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModels(Collection<InferenceProfileModel.BuilderImpl> models) {
            this.models = InferenceProfileModelsCopier.copyFromBuilder(models);
        }

        @Override
        public final Builder models(Collection<InferenceProfileModel> models) {
            this.models = InferenceProfileModelsCopier.copy(models);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(InferenceProfileModel ... models) {
            this.models(Arrays.asList(models));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(Consumer<InferenceProfileModel.Builder> ... models) {
            this.models(Stream.of(models).map(c -> (InferenceProfileModel)((InferenceProfileModel.Builder)InferenceProfileModel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInferenceProfileId() {
            return this.inferenceProfileId;
        }

        public final void setInferenceProfileId(String inferenceProfileId) {
            this.inferenceProfileId = inferenceProfileId;
        }

        @Override
        public final Builder inferenceProfileId(String inferenceProfileId) {
            this.inferenceProfileId = inferenceProfileId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InferenceProfileStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InferenceProfileType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public GetInferenceProfileResponse build() {
            return new GetInferenceProfileResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetInferenceProfileResponse> {
        public Builder inferenceProfileName(String var1);

        public Builder description(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder inferenceProfileArn(String var1);

        public Builder models(Collection<InferenceProfileModel> var1);

        public Builder models(InferenceProfileModel ... var1);

        public Builder models(Consumer<InferenceProfileModel.Builder> ... var1);

        public Builder inferenceProfileId(String var1);

        public Builder status(String var1);

        public Builder status(InferenceProfileStatus var1);

        public Builder type(String var1);

        public Builder type(InferenceProfileType var1);
    }
}

