/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.InvocationLogSource;
import software.amazon.awssdk.services.bedrock.model.RequestMetadataFilters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvocationLogsConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InvocationLogsConfig> {
    private static final SdkField<Boolean> USE_PROMPT_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("usePromptResponse").getter(InvocationLogsConfig.getter(InvocationLogsConfig::usePromptResponse)).setter(InvocationLogsConfig.setter(Builder::usePromptResponse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usePromptResponse").build()}).build();
    private static final SdkField<InvocationLogSource> INVOCATION_LOG_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("invocationLogSource").getter(InvocationLogsConfig.getter(InvocationLogsConfig::invocationLogSource)).setter(InvocationLogsConfig.setter(Builder::invocationLogSource)).constructor(InvocationLogSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationLogSource").build()}).build();
    private static final SdkField<RequestMetadataFilters> REQUEST_METADATA_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("requestMetadataFilters").getter(InvocationLogsConfig.getter(InvocationLogsConfig::requestMetadataFilters)).setter(InvocationLogsConfig.setter(Builder::requestMetadataFilters)).constructor(RequestMetadataFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestMetadataFilters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USE_PROMPT_RESPONSE_FIELD, INVOCATION_LOG_SOURCE_FIELD, REQUEST_METADATA_FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvocationLogsConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean usePromptResponse;
    private final InvocationLogSource invocationLogSource;
    private final RequestMetadataFilters requestMetadataFilters;

    private InvocationLogsConfig(BuilderImpl builder) {
        this.usePromptResponse = builder.usePromptResponse;
        this.invocationLogSource = builder.invocationLogSource;
        this.requestMetadataFilters = builder.requestMetadataFilters;
    }

    public final Boolean usePromptResponse() {
        return this.usePromptResponse;
    }

    public final InvocationLogSource invocationLogSource() {
        return this.invocationLogSource;
    }

    public final RequestMetadataFilters requestMetadataFilters() {
        return this.requestMetadataFilters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.usePromptResponse());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationLogSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestMetadataFilters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvocationLogsConfig)) {
            return false;
        }
        InvocationLogsConfig other = (InvocationLogsConfig)obj;
        return Objects.equals(this.usePromptResponse(), other.usePromptResponse()) && Objects.equals(this.invocationLogSource(), other.invocationLogSource()) && Objects.equals(this.requestMetadataFilters(), other.requestMetadataFilters());
    }

    public final String toString() {
        return ToString.builder((String)"InvocationLogsConfig").add("UsePromptResponse", (Object)this.usePromptResponse()).add("InvocationLogSource", (Object)this.invocationLogSource()).add("RequestMetadataFilters", (Object)this.requestMetadataFilters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "usePromptResponse": {
                return Optional.ofNullable(clazz.cast(this.usePromptResponse()));
            }
            case "invocationLogSource": {
                return Optional.ofNullable(clazz.cast(this.invocationLogSource()));
            }
            case "requestMetadataFilters": {
                return Optional.ofNullable(clazz.cast(this.requestMetadataFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("usePromptResponse", USE_PROMPT_RESPONSE_FIELD);
        map.put("invocationLogSource", INVOCATION_LOG_SOURCE_FIELD);
        map.put("requestMetadataFilters", REQUEST_METADATA_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvocationLogsConfig, T> g) {
        return obj -> g.apply((InvocationLogsConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean usePromptResponse;
        private InvocationLogSource invocationLogSource;
        private RequestMetadataFilters requestMetadataFilters;

        private BuilderImpl() {
        }

        private BuilderImpl(InvocationLogsConfig model) {
            this.usePromptResponse(model.usePromptResponse);
            this.invocationLogSource(model.invocationLogSource);
            this.requestMetadataFilters(model.requestMetadataFilters);
        }

        public final Boolean getUsePromptResponse() {
            return this.usePromptResponse;
        }

        public final void setUsePromptResponse(Boolean usePromptResponse) {
            this.usePromptResponse = usePromptResponse;
        }

        @Override
        public final Builder usePromptResponse(Boolean usePromptResponse) {
            this.usePromptResponse = usePromptResponse;
            return this;
        }

        public final InvocationLogSource.Builder getInvocationLogSource() {
            return this.invocationLogSource != null ? this.invocationLogSource.toBuilder() : null;
        }

        public final void setInvocationLogSource(InvocationLogSource.BuilderImpl invocationLogSource) {
            this.invocationLogSource = invocationLogSource != null ? invocationLogSource.build() : null;
        }

        @Override
        public final Builder invocationLogSource(InvocationLogSource invocationLogSource) {
            this.invocationLogSource = invocationLogSource;
            return this;
        }

        public final RequestMetadataFilters.Builder getRequestMetadataFilters() {
            return this.requestMetadataFilters != null ? this.requestMetadataFilters.toBuilder() : null;
        }

        public final void setRequestMetadataFilters(RequestMetadataFilters.BuilderImpl requestMetadataFilters) {
            this.requestMetadataFilters = requestMetadataFilters != null ? requestMetadataFilters.build() : null;
        }

        @Override
        public final Builder requestMetadataFilters(RequestMetadataFilters requestMetadataFilters) {
            this.requestMetadataFilters = requestMetadataFilters;
            return this;
        }

        public InvocationLogsConfig build() {
            return new InvocationLogsConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InvocationLogsConfig> {
        public Builder usePromptResponse(Boolean var1);

        public Builder invocationLogSource(InvocationLogSource var1);

        default public Builder invocationLogSource(Consumer<InvocationLogSource.Builder> invocationLogSource) {
            return this.invocationLogSource((InvocationLogSource)((InvocationLogSource.Builder)InvocationLogSource.builder().applyMutation(invocationLogSource)).build());
        }

        public Builder requestMetadataFilters(RequestMetadataFilters var1);

        default public Builder requestMetadataFilters(Consumer<RequestMetadataFilters.Builder> requestMetadataFilters) {
            return this.requestMetadataFilters((RequestMetadataFilters)((RequestMetadataFilters.Builder)RequestMetadataFilters.builder().applyMutation(requestMetadataFilters)).build());
        }
    }
}

