/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrock.model.RetrieveAndGenerateConfiguration;
import software.amazon.awssdk.services.bedrock.model.RetrieveConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KnowledgeBaseConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KnowledgeBaseConfig> {
    private static final SdkField<RetrieveConfig> RETRIEVE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retrieveConfig").getter(KnowledgeBaseConfig.getter(KnowledgeBaseConfig::retrieveConfig)).setter(KnowledgeBaseConfig.setter(Builder::retrieveConfig)).constructor(RetrieveConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrieveConfig").build()}).build();
    private static final SdkField<RetrieveAndGenerateConfiguration> RETRIEVE_AND_GENERATE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retrieveAndGenerateConfig").getter(KnowledgeBaseConfig.getter(KnowledgeBaseConfig::retrieveAndGenerateConfig)).setter(KnowledgeBaseConfig.setter(Builder::retrieveAndGenerateConfig)).constructor(RetrieveAndGenerateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrieveAndGenerateConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETRIEVE_CONFIG_FIELD, RETRIEVE_AND_GENERATE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("retrieveConfig", RETRIEVE_CONFIG_FIELD);
            this.put("retrieveAndGenerateConfig", RETRIEVE_AND_GENERATE_CONFIG_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final RetrieveConfig retrieveConfig;
    private final RetrieveAndGenerateConfiguration retrieveAndGenerateConfig;
    private final Type type;

    private KnowledgeBaseConfig(BuilderImpl builder) {
        this.retrieveConfig = builder.retrieveConfig;
        this.retrieveAndGenerateConfig = builder.retrieveAndGenerateConfig;
        this.type = builder.type;
    }

    public final RetrieveConfig retrieveConfig() {
        return this.retrieveConfig;
    }

    public final RetrieveAndGenerateConfiguration retrieveAndGenerateConfig() {
        return this.retrieveAndGenerateConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.retrieveConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrieveAndGenerateConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseConfig)) {
            return false;
        }
        KnowledgeBaseConfig other = (KnowledgeBaseConfig)obj;
        return Objects.equals(this.retrieveConfig(), other.retrieveConfig()) && Objects.equals(this.retrieveAndGenerateConfig(), other.retrieveAndGenerateConfig());
    }

    public final String toString() {
        return ToString.builder((String)"KnowledgeBaseConfig").add("RetrieveConfig", (Object)this.retrieveConfig()).add("RetrieveAndGenerateConfig", (Object)this.retrieveAndGenerateConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "retrieveConfig": {
                return Optional.ofNullable(clazz.cast(this.retrieveConfig()));
            }
            case "retrieveAndGenerateConfig": {
                return Optional.ofNullable(clazz.cast(this.retrieveAndGenerateConfig()));
            }
        }
        return Optional.empty();
    }

    public static KnowledgeBaseConfig fromRetrieveConfig(RetrieveConfig retrieveConfig) {
        return (KnowledgeBaseConfig)KnowledgeBaseConfig.builder().retrieveConfig(retrieveConfig).build();
    }

    public static KnowledgeBaseConfig fromRetrieveConfig(Consumer<RetrieveConfig.Builder> retrieveConfig) {
        RetrieveConfig.Builder builder = RetrieveConfig.builder();
        retrieveConfig.accept(builder);
        return KnowledgeBaseConfig.fromRetrieveConfig((RetrieveConfig)builder.build());
    }

    public static KnowledgeBaseConfig fromRetrieveAndGenerateConfig(RetrieveAndGenerateConfiguration retrieveAndGenerateConfig) {
        return (KnowledgeBaseConfig)KnowledgeBaseConfig.builder().retrieveAndGenerateConfig(retrieveAndGenerateConfig).build();
    }

    public static KnowledgeBaseConfig fromRetrieveAndGenerateConfig(Consumer<RetrieveAndGenerateConfiguration.Builder> retrieveAndGenerateConfig) {
        RetrieveAndGenerateConfiguration.Builder builder = RetrieveAndGenerateConfiguration.builder();
        retrieveAndGenerateConfig.accept(builder);
        return KnowledgeBaseConfig.fromRetrieveAndGenerateConfig((RetrieveAndGenerateConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseConfig, T> g) {
        return obj -> g.apply((KnowledgeBaseConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        RETRIEVE_CONFIG,
        RETRIEVE_AND_GENERATE_CONFIG,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private RetrieveConfig retrieveConfig;
        private RetrieveAndGenerateConfiguration retrieveAndGenerateConfig;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseConfig model) {
            this.retrieveConfig(model.retrieveConfig);
            this.retrieveAndGenerateConfig(model.retrieveAndGenerateConfig);
        }

        public final RetrieveConfig.Builder getRetrieveConfig() {
            return this.retrieveConfig != null ? this.retrieveConfig.toBuilder() : null;
        }

        public final void setRetrieveConfig(RetrieveConfig.BuilderImpl retrieveConfig) {
            RetrieveConfig oldValue = this.retrieveConfig;
            this.retrieveConfig = retrieveConfig != null ? retrieveConfig.build() : null;
            this.handleUnionValueChange(Type.RETRIEVE_CONFIG, oldValue, this.retrieveConfig);
        }

        @Override
        public final Builder retrieveConfig(RetrieveConfig retrieveConfig) {
            RetrieveConfig oldValue = this.retrieveConfig;
            this.retrieveConfig = retrieveConfig;
            this.handleUnionValueChange(Type.RETRIEVE_CONFIG, oldValue, this.retrieveConfig);
            return this;
        }

        public final RetrieveAndGenerateConfiguration.Builder getRetrieveAndGenerateConfig() {
            return this.retrieveAndGenerateConfig != null ? this.retrieveAndGenerateConfig.toBuilder() : null;
        }

        public final void setRetrieveAndGenerateConfig(RetrieveAndGenerateConfiguration.BuilderImpl retrieveAndGenerateConfig) {
            RetrieveAndGenerateConfiguration oldValue = this.retrieveAndGenerateConfig;
            this.retrieveAndGenerateConfig = retrieveAndGenerateConfig != null ? retrieveAndGenerateConfig.build() : null;
            this.handleUnionValueChange(Type.RETRIEVE_AND_GENERATE_CONFIG, oldValue, this.retrieveAndGenerateConfig);
        }

        @Override
        public final Builder retrieveAndGenerateConfig(RetrieveAndGenerateConfiguration retrieveAndGenerateConfig) {
            RetrieveAndGenerateConfiguration oldValue = this.retrieveAndGenerateConfig;
            this.retrieveAndGenerateConfig = retrieveAndGenerateConfig;
            this.handleUnionValueChange(Type.RETRIEVE_AND_GENERATE_CONFIG, oldValue, this.retrieveAndGenerateConfig);
            return this;
        }

        public KnowledgeBaseConfig build() {
            return new KnowledgeBaseConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KnowledgeBaseConfig> {
        public Builder retrieveConfig(RetrieveConfig var1);

        default public Builder retrieveConfig(Consumer<RetrieveConfig.Builder> retrieveConfig) {
            return this.retrieveConfig((RetrieveConfig)((RetrieveConfig.Builder)RetrieveConfig.builder().applyMutation(retrieveConfig)).build());
        }

        public Builder retrieveAndGenerateConfig(RetrieveAndGenerateConfiguration var1);

        default public Builder retrieveAndGenerateConfig(Consumer<RetrieveAndGenerateConfiguration.Builder> retrieveAndGenerateConfig) {
            return this.retrieveAndGenerateConfig((RetrieveAndGenerateConfiguration)((RetrieveAndGenerateConfiguration.Builder)RetrieveAndGenerateConfiguration.builder().applyMutation(retrieveAndGenerateConfig)).build());
        }
    }
}

