/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterMarketplaceModelEndpointRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, RegisterMarketplaceModelEndpointRequest> {
    private static final SdkField<String> ENDPOINT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpointIdentifier").getter(RegisterMarketplaceModelEndpointRequest.getter(RegisterMarketplaceModelEndpointRequest::endpointIdentifier)).setter(RegisterMarketplaceModelEndpointRequest.setter(Builder::endpointIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("endpointIdentifier").build()}).build();
    private static final SdkField<String> MODEL_SOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelSourceIdentifier").getter(RegisterMarketplaceModelEndpointRequest.getter(RegisterMarketplaceModelEndpointRequest::modelSourceIdentifier)).setter(RegisterMarketplaceModelEndpointRequest.setter(Builder::modelSourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelSourceIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_IDENTIFIER_FIELD, MODEL_SOURCE_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("endpointIdentifier", ENDPOINT_IDENTIFIER_FIELD);
            this.put("modelSourceIdentifier", MODEL_SOURCE_IDENTIFIER_FIELD);
        }
    });
    private final String endpointIdentifier;
    private final String modelSourceIdentifier;

    private RegisterMarketplaceModelEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.endpointIdentifier = builder.endpointIdentifier;
        this.modelSourceIdentifier = builder.modelSourceIdentifier;
    }

    public final String endpointIdentifier() {
        return this.endpointIdentifier;
    }

    public final String modelSourceIdentifier() {
        return this.modelSourceIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelSourceIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterMarketplaceModelEndpointRequest)) {
            return false;
        }
        RegisterMarketplaceModelEndpointRequest other = (RegisterMarketplaceModelEndpointRequest)((Object)obj);
        return Objects.equals(this.endpointIdentifier(), other.endpointIdentifier()) && Objects.equals(this.modelSourceIdentifier(), other.modelSourceIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterMarketplaceModelEndpointRequest").add("EndpointIdentifier", (Object)this.endpointIdentifier()).add("ModelSourceIdentifier", (Object)this.modelSourceIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endpointIdentifier": {
                return Optional.ofNullable(clazz.cast(this.endpointIdentifier()));
            }
            case "modelSourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.modelSourceIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RegisterMarketplaceModelEndpointRequest, T> g) {
        return obj -> g.apply((RegisterMarketplaceModelEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private String endpointIdentifier;
        private String modelSourceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterMarketplaceModelEndpointRequest model) {
            super(model);
            this.endpointIdentifier(model.endpointIdentifier);
            this.modelSourceIdentifier(model.modelSourceIdentifier);
        }

        public final String getEndpointIdentifier() {
            return this.endpointIdentifier;
        }

        public final void setEndpointIdentifier(String endpointIdentifier) {
            this.endpointIdentifier = endpointIdentifier;
        }

        @Override
        public final Builder endpointIdentifier(String endpointIdentifier) {
            this.endpointIdentifier = endpointIdentifier;
            return this;
        }

        public final String getModelSourceIdentifier() {
            return this.modelSourceIdentifier;
        }

        public final void setModelSourceIdentifier(String modelSourceIdentifier) {
            this.modelSourceIdentifier = modelSourceIdentifier;
        }

        @Override
        public final Builder modelSourceIdentifier(String modelSourceIdentifier) {
            this.modelSourceIdentifier = modelSourceIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterMarketplaceModelEndpointRequest build() {
            return new RegisterMarketplaceModelEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterMarketplaceModelEndpointRequest> {
        public Builder endpointIdentifier(String var1);

        public Builder modelSourceIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

