/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.ApplicationType;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.services.bedrock.model.ErrorMessagesCopier;
import software.amazon.awssdk.services.bedrock.model.EvaluationConfig;
import software.amazon.awssdk.services.bedrock.model.EvaluationInferenceConfig;
import software.amazon.awssdk.services.bedrock.model.EvaluationJobStatus;
import software.amazon.awssdk.services.bedrock.model.EvaluationJobType;
import software.amazon.awssdk.services.bedrock.model.EvaluationOutputDataConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEvaluationJobResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, GetEvaluationJobResponse> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(GetEvaluationJobResponse.getter(GetEvaluationJobResponse::jobName)).setter(GetEvaluationJobResponse.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetEvaluationJobResponse.getter(GetEvaluationJobResponse::statusAsString)).setter(GetEvaluationJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobArn").getter(GetEvaluationJobResponse.getter(GetEvaluationJobResponse::jobArn)).setter(GetEvaluationJobResponse.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()}).build();
    private static final SdkField<String> JOB_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobDescription").getter(GetEvaluationJobResponse.getter(GetEvaluationJobResponse::jobDescription)).setter(GetEvaluationJobResponse.setter(Builder::jobDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDescription").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(GetEvaluationJobResponse.getter(GetEvaluationJobResponse::roleArn)).setter(GetEvaluationJobResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> CUSTOMER_ENCRYPTION_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerEncryptionKeyId").getter(GetEvaluationJobResponse.getter(GetEvaluationJobResponse::customerEncryptionKeyId)).setter(GetEvaluationJobResponse.setter(Builder::customerEncryptionKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerEncryptionKeyId").build()}).build();
    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobType").getter(GetEvaluationJobResponse.getter(GetEvaluationJobResponse::jobTypeAsString)).setter(GetEvaluationJobResponse.setter(Builder::jobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobType").build()}).build();
    private static final SdkField<String> APPLICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationType").getter(GetEvaluationJobResponse.getter(GetEvaluationJobResponse::applicationTypeAsString)).setter(GetEvaluationJobResponse.setter(Builder::applicationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationType").build()}).build();
    private static final SdkField<EvaluationConfig> EVALUATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("evaluationConfig").getter(GetEvaluationJobResponse.getter(GetEvaluationJobResponse::evaluationConfig)).setter(GetEvaluationJobResponse.setter(Builder::evaluationConfig)).constructor(EvaluationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationConfig").build()}).build();
    private static final SdkField<EvaluationInferenceConfig> INFERENCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inferenceConfig").getter(GetEvaluationJobResponse.getter(GetEvaluationJobResponse::inferenceConfig)).setter(GetEvaluationJobResponse.setter(Builder::inferenceConfig)).constructor(EvaluationInferenceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfig").build()}).build();
    private static final SdkField<EvaluationOutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputDataConfig").getter(GetEvaluationJobResponse.getter(GetEvaluationJobResponse::outputDataConfig)).setter(GetEvaluationJobResponse.setter(Builder::outputDataConfig)).constructor(EvaluationOutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDataConfig").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetEvaluationJobResponse.getter(GetEvaluationJobResponse::creationTime)).setter(GetEvaluationJobResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTime").getter(GetEvaluationJobResponse.getter(GetEvaluationJobResponse::lastModifiedTime)).setter(GetEvaluationJobResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<String>> FAILURE_MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failureMessages").getter(GetEvaluationJobResponse.getter(GetEvaluationJobResponse::failureMessages)).setter(GetEvaluationJobResponse.setter(Builder::failureMessages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, STATUS_FIELD, JOB_ARN_FIELD, JOB_DESCRIPTION_FIELD, ROLE_ARN_FIELD, CUSTOMER_ENCRYPTION_KEY_ID_FIELD, JOB_TYPE_FIELD, APPLICATION_TYPE_FIELD, EVALUATION_CONFIG_FIELD, INFERENCE_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, FAILURE_MESSAGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("jobName", JOB_NAME_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("jobArn", JOB_ARN_FIELD);
            this.put("jobDescription", JOB_DESCRIPTION_FIELD);
            this.put("roleArn", ROLE_ARN_FIELD);
            this.put("customerEncryptionKeyId", CUSTOMER_ENCRYPTION_KEY_ID_FIELD);
            this.put("jobType", JOB_TYPE_FIELD);
            this.put("applicationType", APPLICATION_TYPE_FIELD);
            this.put("evaluationConfig", EVALUATION_CONFIG_FIELD);
            this.put("inferenceConfig", INFERENCE_CONFIG_FIELD);
            this.put("outputDataConfig", OUTPUT_DATA_CONFIG_FIELD);
            this.put("creationTime", CREATION_TIME_FIELD);
            this.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
            this.put("failureMessages", FAILURE_MESSAGES_FIELD);
        }
    });
    private final String jobName;
    private final String status;
    private final String jobArn;
    private final String jobDescription;
    private final String roleArn;
    private final String customerEncryptionKeyId;
    private final String jobType;
    private final String applicationType;
    private final EvaluationConfig evaluationConfig;
    private final EvaluationInferenceConfig inferenceConfig;
    private final EvaluationOutputDataConfig outputDataConfig;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final List<String> failureMessages;

    private GetEvaluationJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.status = builder.status;
        this.jobArn = builder.jobArn;
        this.jobDescription = builder.jobDescription;
        this.roleArn = builder.roleArn;
        this.customerEncryptionKeyId = builder.customerEncryptionKeyId;
        this.jobType = builder.jobType;
        this.applicationType = builder.applicationType;
        this.evaluationConfig = builder.evaluationConfig;
        this.inferenceConfig = builder.inferenceConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureMessages = builder.failureMessages;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final EvaluationJobStatus status() {
        return EvaluationJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String jobArn() {
        return this.jobArn;
    }

    public final String jobDescription() {
        return this.jobDescription;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String customerEncryptionKeyId() {
        return this.customerEncryptionKeyId;
    }

    public final EvaluationJobType jobType() {
        return EvaluationJobType.fromValue(this.jobType);
    }

    public final String jobTypeAsString() {
        return this.jobType;
    }

    public final ApplicationType applicationType() {
        return ApplicationType.fromValue(this.applicationType);
    }

    public final String applicationTypeAsString() {
        return this.applicationType;
    }

    public final EvaluationConfig evaluationConfig() {
        return this.evaluationConfig;
    }

    public final EvaluationInferenceConfig inferenceConfig() {
        return this.inferenceConfig;
    }

    public final EvaluationOutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final boolean hasFailureMessages() {
        return this.failureMessages != null && !(this.failureMessages instanceof SdkAutoConstructList);
    }

    public final List<String> failureMessages() {
        return this.failureMessages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerEncryptionKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailureMessages() ? this.failureMessages() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEvaluationJobResponse)) {
            return false;
        }
        GetEvaluationJobResponse other = (GetEvaluationJobResponse)((Object)obj);
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.jobArn(), other.jobArn()) && Objects.equals(this.jobDescription(), other.jobDescription()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.customerEncryptionKeyId(), other.customerEncryptionKeyId()) && Objects.equals(this.jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(this.applicationTypeAsString(), other.applicationTypeAsString()) && Objects.equals(this.evaluationConfig(), other.evaluationConfig()) && Objects.equals(this.inferenceConfig(), other.inferenceConfig()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && this.hasFailureMessages() == other.hasFailureMessages() && Objects.equals(this.failureMessages(), other.failureMessages());
    }

    public final String toString() {
        return ToString.builder((String)"GetEvaluationJobResponse").add("JobName", (Object)this.jobName()).add("Status", (Object)this.statusAsString()).add("JobArn", (Object)this.jobArn()).add("JobDescription", (Object)(this.jobDescription() == null ? null : "*** Sensitive Data Redacted ***")).add("RoleArn", (Object)this.roleArn()).add("CustomerEncryptionKeyId", (Object)this.customerEncryptionKeyId()).add("JobType", (Object)this.jobTypeAsString()).add("ApplicationType", (Object)this.applicationTypeAsString()).add("EvaluationConfig", (Object)this.evaluationConfig()).add("InferenceConfig", (Object)this.inferenceConfig()).add("OutputDataConfig", (Object)this.outputDataConfig()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("FailureMessages", this.hasFailureMessages() ? this.failureMessages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "jobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "jobDescription": {
                return Optional.ofNullable(clazz.cast(this.jobDescription()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "customerEncryptionKeyId": {
                return Optional.ofNullable(clazz.cast(this.customerEncryptionKeyId()));
            }
            case "jobType": {
                return Optional.ofNullable(clazz.cast(this.jobTypeAsString()));
            }
            case "applicationType": {
                return Optional.ofNullable(clazz.cast(this.applicationTypeAsString()));
            }
            case "evaluationConfig": {
                return Optional.ofNullable(clazz.cast(this.evaluationConfig()));
            }
            case "inferenceConfig": {
                return Optional.ofNullable(clazz.cast(this.inferenceConfig()));
            }
            case "outputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "failureMessages": {
                return Optional.ofNullable(clazz.cast(this.failureMessages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetEvaluationJobResponse, T> g) {
        return obj -> g.apply((GetEvaluationJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private String jobName;
        private String status;
        private String jobArn;
        private String jobDescription;
        private String roleArn;
        private String customerEncryptionKeyId;
        private String jobType;
        private String applicationType;
        private EvaluationConfig evaluationConfig;
        private EvaluationInferenceConfig inferenceConfig;
        private EvaluationOutputDataConfig outputDataConfig;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private List<String> failureMessages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEvaluationJobResponse model) {
            super(model);
            this.jobName(model.jobName);
            this.status(model.status);
            this.jobArn(model.jobArn);
            this.jobDescription(model.jobDescription);
            this.roleArn(model.roleArn);
            this.customerEncryptionKeyId(model.customerEncryptionKeyId);
            this.jobType(model.jobType);
            this.applicationType(model.applicationType);
            this.evaluationConfig(model.evaluationConfig);
            this.inferenceConfig(model.inferenceConfig);
            this.outputDataConfig(model.outputDataConfig);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.failureMessages(model.failureMessages);
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EvaluationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobDescription() {
            return this.jobDescription;
        }

        public final void setJobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
        }

        @Override
        public final Builder jobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getCustomerEncryptionKeyId() {
            return this.customerEncryptionKeyId;
        }

        public final void setCustomerEncryptionKeyId(String customerEncryptionKeyId) {
            this.customerEncryptionKeyId = customerEncryptionKeyId;
        }

        @Override
        public final Builder customerEncryptionKeyId(String customerEncryptionKeyId) {
            this.customerEncryptionKeyId = customerEncryptionKeyId;
            return this;
        }

        public final String getJobType() {
            return this.jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(EvaluationJobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final String getApplicationType() {
            return this.applicationType;
        }

        public final void setApplicationType(String applicationType) {
            this.applicationType = applicationType;
        }

        @Override
        public final Builder applicationType(String applicationType) {
            this.applicationType = applicationType;
            return this;
        }

        @Override
        public final Builder applicationType(ApplicationType applicationType) {
            this.applicationType(applicationType == null ? null : applicationType.toString());
            return this;
        }

        public final EvaluationConfig.Builder getEvaluationConfig() {
            return this.evaluationConfig != null ? this.evaluationConfig.toBuilder() : null;
        }

        public final void setEvaluationConfig(EvaluationConfig.BuilderImpl evaluationConfig) {
            this.evaluationConfig = evaluationConfig != null ? evaluationConfig.build() : null;
        }

        @Override
        public final Builder evaluationConfig(EvaluationConfig evaluationConfig) {
            this.evaluationConfig = evaluationConfig;
            return this;
        }

        public final EvaluationInferenceConfig.Builder getInferenceConfig() {
            return this.inferenceConfig != null ? this.inferenceConfig.toBuilder() : null;
        }

        public final void setInferenceConfig(EvaluationInferenceConfig.BuilderImpl inferenceConfig) {
            this.inferenceConfig = inferenceConfig != null ? inferenceConfig.build() : null;
        }

        @Override
        public final Builder inferenceConfig(EvaluationInferenceConfig inferenceConfig) {
            this.inferenceConfig = inferenceConfig;
            return this;
        }

        public final EvaluationOutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(EvaluationOutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(EvaluationOutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Collection<String> getFailureMessages() {
            if (this.failureMessages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failureMessages;
        }

        public final void setFailureMessages(Collection<String> failureMessages) {
            this.failureMessages = ErrorMessagesCopier.copy(failureMessages);
        }

        @Override
        public final Builder failureMessages(Collection<String> failureMessages) {
            this.failureMessages = ErrorMessagesCopier.copy(failureMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureMessages(String ... failureMessages) {
            this.failureMessages(Arrays.asList(failureMessages));
            return this;
        }

        @Override
        public GetEvaluationJobResponse build() {
            return new GetEvaluationJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEvaluationJobResponse> {
        public Builder jobName(String var1);

        public Builder status(String var1);

        public Builder status(EvaluationJobStatus var1);

        public Builder jobArn(String var1);

        public Builder jobDescription(String var1);

        public Builder roleArn(String var1);

        public Builder customerEncryptionKeyId(String var1);

        public Builder jobType(String var1);

        public Builder jobType(EvaluationJobType var1);

        public Builder applicationType(String var1);

        public Builder applicationType(ApplicationType var1);

        public Builder evaluationConfig(EvaluationConfig var1);

        default public Builder evaluationConfig(Consumer<EvaluationConfig.Builder> evaluationConfig) {
            return this.evaluationConfig((EvaluationConfig)((EvaluationConfig.Builder)EvaluationConfig.builder().applyMutation(evaluationConfig)).build());
        }

        public Builder inferenceConfig(EvaluationInferenceConfig var1);

        default public Builder inferenceConfig(Consumer<EvaluationInferenceConfig.Builder> inferenceConfig) {
            return this.inferenceConfig((EvaluationInferenceConfig)((EvaluationInferenceConfig.Builder)EvaluationInferenceConfig.builder().applyMutation(inferenceConfig)).build());
        }

        public Builder outputDataConfig(EvaluationOutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<EvaluationOutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((EvaluationOutputDataConfig)((EvaluationOutputDataConfig.Builder)EvaluationOutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder failureMessages(Collection<String> var1);

        public Builder failureMessages(String ... var1);
    }
}

