/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.ApplicationType;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.services.bedrock.model.EvaluationConfig;
import software.amazon.awssdk.services.bedrock.model.EvaluationInferenceConfig;
import software.amazon.awssdk.services.bedrock.model.EvaluationOutputDataConfig;
import software.amazon.awssdk.services.bedrock.model.Tag;
import software.amazon.awssdk.services.bedrock.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEvaluationJobRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, CreateEvaluationJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(CreateEvaluationJobRequest.getter(CreateEvaluationJobRequest::jobName)).setter(CreateEvaluationJobRequest.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> JOB_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobDescription").getter(CreateEvaluationJobRequest.getter(CreateEvaluationJobRequest::jobDescription)).setter(CreateEvaluationJobRequest.setter(Builder::jobDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDescription").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(CreateEvaluationJobRequest.getter(CreateEvaluationJobRequest::clientRequestToken)).setter(CreateEvaluationJobRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateEvaluationJobRequest.getter(CreateEvaluationJobRequest::roleArn)).setter(CreateEvaluationJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> CUSTOMER_ENCRYPTION_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerEncryptionKeyId").getter(CreateEvaluationJobRequest.getter(CreateEvaluationJobRequest::customerEncryptionKeyId)).setter(CreateEvaluationJobRequest.setter(Builder::customerEncryptionKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerEncryptionKeyId").build()}).build();
    private static final SdkField<List<Tag>> JOB_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("jobTags").getter(CreateEvaluationJobRequest.getter(CreateEvaluationJobRequest::jobTags)).setter(CreateEvaluationJobRequest.setter(Builder::jobTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> APPLICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationType").getter(CreateEvaluationJobRequest.getter(CreateEvaluationJobRequest::applicationTypeAsString)).setter(CreateEvaluationJobRequest.setter(Builder::applicationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationType").build()}).build();
    private static final SdkField<EvaluationConfig> EVALUATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("evaluationConfig").getter(CreateEvaluationJobRequest.getter(CreateEvaluationJobRequest::evaluationConfig)).setter(CreateEvaluationJobRequest.setter(Builder::evaluationConfig)).constructor(EvaluationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationConfig").build()}).build();
    private static final SdkField<EvaluationInferenceConfig> INFERENCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inferenceConfig").getter(CreateEvaluationJobRequest.getter(CreateEvaluationJobRequest::inferenceConfig)).setter(CreateEvaluationJobRequest.setter(Builder::inferenceConfig)).constructor(EvaluationInferenceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfig").build()}).build();
    private static final SdkField<EvaluationOutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputDataConfig").getter(CreateEvaluationJobRequest.getter(CreateEvaluationJobRequest::outputDataConfig)).setter(CreateEvaluationJobRequest.setter(Builder::outputDataConfig)).constructor(EvaluationOutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDataConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, JOB_DESCRIPTION_FIELD, CLIENT_REQUEST_TOKEN_FIELD, ROLE_ARN_FIELD, CUSTOMER_ENCRYPTION_KEY_ID_FIELD, JOB_TAGS_FIELD, APPLICATION_TYPE_FIELD, EVALUATION_CONFIG_FIELD, INFERENCE_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("jobName", JOB_NAME_FIELD);
            this.put("jobDescription", JOB_DESCRIPTION_FIELD);
            this.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
            this.put("roleArn", ROLE_ARN_FIELD);
            this.put("customerEncryptionKeyId", CUSTOMER_ENCRYPTION_KEY_ID_FIELD);
            this.put("jobTags", JOB_TAGS_FIELD);
            this.put("applicationType", APPLICATION_TYPE_FIELD);
            this.put("evaluationConfig", EVALUATION_CONFIG_FIELD);
            this.put("inferenceConfig", INFERENCE_CONFIG_FIELD);
            this.put("outputDataConfig", OUTPUT_DATA_CONFIG_FIELD);
        }
    });
    private final String jobName;
    private final String jobDescription;
    private final String clientRequestToken;
    private final String roleArn;
    private final String customerEncryptionKeyId;
    private final List<Tag> jobTags;
    private final String applicationType;
    private final EvaluationConfig evaluationConfig;
    private final EvaluationInferenceConfig inferenceConfig;
    private final EvaluationOutputDataConfig outputDataConfig;

    private CreateEvaluationJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.jobDescription = builder.jobDescription;
        this.clientRequestToken = builder.clientRequestToken;
        this.roleArn = builder.roleArn;
        this.customerEncryptionKeyId = builder.customerEncryptionKeyId;
        this.jobTags = builder.jobTags;
        this.applicationType = builder.applicationType;
        this.evaluationConfig = builder.evaluationConfig;
        this.inferenceConfig = builder.inferenceConfig;
        this.outputDataConfig = builder.outputDataConfig;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String jobDescription() {
        return this.jobDescription;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String customerEncryptionKeyId() {
        return this.customerEncryptionKeyId;
    }

    public final boolean hasJobTags() {
        return this.jobTags != null && !(this.jobTags instanceof SdkAutoConstructList);
    }

    public final List<Tag> jobTags() {
        return this.jobTags;
    }

    public final ApplicationType applicationType() {
        return ApplicationType.fromValue(this.applicationType);
    }

    public final String applicationTypeAsString() {
        return this.applicationType;
    }

    public final EvaluationConfig evaluationConfig() {
        return this.evaluationConfig;
    }

    public final EvaluationInferenceConfig inferenceConfig() {
        return this.inferenceConfig;
    }

    public final EvaluationOutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerEncryptionKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobTags() ? this.jobTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEvaluationJobRequest)) {
            return false;
        }
        CreateEvaluationJobRequest other = (CreateEvaluationJobRequest)((Object)obj);
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobDescription(), other.jobDescription()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.customerEncryptionKeyId(), other.customerEncryptionKeyId()) && this.hasJobTags() == other.hasJobTags() && Objects.equals(this.jobTags(), other.jobTags()) && Objects.equals(this.applicationTypeAsString(), other.applicationTypeAsString()) && Objects.equals(this.evaluationConfig(), other.evaluationConfig()) && Objects.equals(this.inferenceConfig(), other.inferenceConfig()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEvaluationJobRequest").add("JobName", (Object)this.jobName()).add("JobDescription", (Object)(this.jobDescription() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientRequestToken", (Object)this.clientRequestToken()).add("RoleArn", (Object)this.roleArn()).add("CustomerEncryptionKeyId", (Object)this.customerEncryptionKeyId()).add("JobTags", this.hasJobTags() ? this.jobTags() : null).add("ApplicationType", (Object)this.applicationTypeAsString()).add("EvaluationConfig", (Object)this.evaluationConfig()).add("InferenceConfig", (Object)this.inferenceConfig()).add("OutputDataConfig", (Object)this.outputDataConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "jobDescription": {
                return Optional.ofNullable(clazz.cast(this.jobDescription()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "customerEncryptionKeyId": {
                return Optional.ofNullable(clazz.cast(this.customerEncryptionKeyId()));
            }
            case "jobTags": {
                return Optional.ofNullable(clazz.cast(this.jobTags()));
            }
            case "applicationType": {
                return Optional.ofNullable(clazz.cast(this.applicationTypeAsString()));
            }
            case "evaluationConfig": {
                return Optional.ofNullable(clazz.cast(this.evaluationConfig()));
            }
            case "inferenceConfig": {
                return Optional.ofNullable(clazz.cast(this.inferenceConfig()));
            }
            case "outputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateEvaluationJobRequest, T> g) {
        return obj -> g.apply((CreateEvaluationJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private String jobName;
        private String jobDescription;
        private String clientRequestToken;
        private String roleArn;
        private String customerEncryptionKeyId;
        private List<Tag> jobTags = DefaultSdkAutoConstructList.getInstance();
        private String applicationType;
        private EvaluationConfig evaluationConfig;
        private EvaluationInferenceConfig inferenceConfig;
        private EvaluationOutputDataConfig outputDataConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEvaluationJobRequest model) {
            super(model);
            this.jobName(model.jobName);
            this.jobDescription(model.jobDescription);
            this.clientRequestToken(model.clientRequestToken);
            this.roleArn(model.roleArn);
            this.customerEncryptionKeyId(model.customerEncryptionKeyId);
            this.jobTags(model.jobTags);
            this.applicationType(model.applicationType);
            this.evaluationConfig(model.evaluationConfig);
            this.inferenceConfig(model.inferenceConfig);
            this.outputDataConfig(model.outputDataConfig);
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobDescription() {
            return this.jobDescription;
        }

        public final void setJobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
        }

        @Override
        public final Builder jobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getCustomerEncryptionKeyId() {
            return this.customerEncryptionKeyId;
        }

        public final void setCustomerEncryptionKeyId(String customerEncryptionKeyId) {
            this.customerEncryptionKeyId = customerEncryptionKeyId;
        }

        @Override
        public final Builder customerEncryptionKeyId(String customerEncryptionKeyId) {
            this.customerEncryptionKeyId = customerEncryptionKeyId;
            return this;
        }

        public final List<Tag.Builder> getJobTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.jobTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobTags(Collection<Tag.BuilderImpl> jobTags) {
            this.jobTags = TagListCopier.copyFromBuilder(jobTags);
        }

        @Override
        public final Builder jobTags(Collection<Tag> jobTags) {
            this.jobTags = TagListCopier.copy(jobTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobTags(Tag ... jobTags) {
            this.jobTags(Arrays.asList(jobTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobTags(Consumer<Tag.Builder> ... jobTags) {
            this.jobTags(Stream.of(jobTags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getApplicationType() {
            return this.applicationType;
        }

        public final void setApplicationType(String applicationType) {
            this.applicationType = applicationType;
        }

        @Override
        public final Builder applicationType(String applicationType) {
            this.applicationType = applicationType;
            return this;
        }

        @Override
        public final Builder applicationType(ApplicationType applicationType) {
            this.applicationType(applicationType == null ? null : applicationType.toString());
            return this;
        }

        public final EvaluationConfig.Builder getEvaluationConfig() {
            return this.evaluationConfig != null ? this.evaluationConfig.toBuilder() : null;
        }

        public final void setEvaluationConfig(EvaluationConfig.BuilderImpl evaluationConfig) {
            this.evaluationConfig = evaluationConfig != null ? evaluationConfig.build() : null;
        }

        @Override
        public final Builder evaluationConfig(EvaluationConfig evaluationConfig) {
            this.evaluationConfig = evaluationConfig;
            return this;
        }

        public final EvaluationInferenceConfig.Builder getInferenceConfig() {
            return this.inferenceConfig != null ? this.inferenceConfig.toBuilder() : null;
        }

        public final void setInferenceConfig(EvaluationInferenceConfig.BuilderImpl inferenceConfig) {
            this.inferenceConfig = inferenceConfig != null ? inferenceConfig.build() : null;
        }

        @Override
        public final Builder inferenceConfig(EvaluationInferenceConfig inferenceConfig) {
            this.inferenceConfig = inferenceConfig;
            return this;
        }

        public final EvaluationOutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(EvaluationOutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(EvaluationOutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEvaluationJobRequest build() {
            return new CreateEvaluationJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEvaluationJobRequest> {
        public Builder jobName(String var1);

        public Builder jobDescription(String var1);

        public Builder clientRequestToken(String var1);

        public Builder roleArn(String var1);

        public Builder customerEncryptionKeyId(String var1);

        public Builder jobTags(Collection<Tag> var1);

        public Builder jobTags(Tag ... var1);

        public Builder jobTags(Consumer<Tag.Builder> ... var1);

        public Builder applicationType(String var1);

        public Builder applicationType(ApplicationType var1);

        public Builder evaluationConfig(EvaluationConfig var1);

        default public Builder evaluationConfig(Consumer<EvaluationConfig.Builder> evaluationConfig) {
            return this.evaluationConfig((EvaluationConfig)((EvaluationConfig.Builder)EvaluationConfig.builder().applyMutation(evaluationConfig)).build());
        }

        public Builder inferenceConfig(EvaluationInferenceConfig var1);

        default public Builder inferenceConfig(Consumer<EvaluationInferenceConfig.Builder> inferenceConfig) {
            return this.inferenceConfig((EvaluationInferenceConfig)((EvaluationInferenceConfig.Builder)EvaluationInferenceConfig.builder().applyMutation(inferenceConfig)).build());
        }

        public Builder outputDataConfig(EvaluationOutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<EvaluationOutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((EvaluationOutputDataConfig)((EvaluationOutputDataConfig.Builder)EvaluationOutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

