/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.EvaluationJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteEvaluationJobItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchDeleteEvaluationJobItem> {
    private static final SdkField<String> JOB_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobIdentifier").getter(BatchDeleteEvaluationJobItem.getter(BatchDeleteEvaluationJobItem::jobIdentifier)).setter(BatchDeleteEvaluationJobItem.setter(Builder::jobIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobIdentifier").build()}).build();
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobStatus").getter(BatchDeleteEvaluationJobItem.getter(BatchDeleteEvaluationJobItem::jobStatusAsString)).setter(BatchDeleteEvaluationJobItem.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_IDENTIFIER_FIELD, JOB_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("jobIdentifier", JOB_IDENTIFIER_FIELD);
            this.put("jobStatus", JOB_STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String jobIdentifier;
    private final String jobStatus;

    private BatchDeleteEvaluationJobItem(BuilderImpl builder) {
        this.jobIdentifier = builder.jobIdentifier;
        this.jobStatus = builder.jobStatus;
    }

    public final String jobIdentifier() {
        return this.jobIdentifier;
    }

    public final EvaluationJobStatus jobStatus() {
        return EvaluationJobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteEvaluationJobItem)) {
            return false;
        }
        BatchDeleteEvaluationJobItem other = (BatchDeleteEvaluationJobItem)obj;
        return Objects.equals(this.jobIdentifier(), other.jobIdentifier()) && Objects.equals(this.jobStatusAsString(), other.jobStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteEvaluationJobItem").add("JobIdentifier", (Object)(this.jobIdentifier() == null ? null : "*** Sensitive Data Redacted ***")).add("JobStatus", (Object)this.jobStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobIdentifier": {
                return Optional.ofNullable(clazz.cast(this.jobIdentifier()));
            }
            case "jobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteEvaluationJobItem, T> g) {
        return obj -> g.apply((BatchDeleteEvaluationJobItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobIdentifier;
        private String jobStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteEvaluationJobItem model) {
            this.jobIdentifier(model.jobIdentifier);
            this.jobStatus(model.jobStatus);
        }

        public final String getJobIdentifier() {
            return this.jobIdentifier;
        }

        public final void setJobIdentifier(String jobIdentifier) {
            this.jobIdentifier = jobIdentifier;
        }

        @Override
        public final Builder jobIdentifier(String jobIdentifier) {
            this.jobIdentifier = jobIdentifier;
            return this;
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(EvaluationJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public BatchDeleteEvaluationJobItem build() {
            return new BatchDeleteEvaluationJobItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchDeleteEvaluationJobItem> {
        public Builder jobIdentifier(String var1);

        public Builder jobStatus(String var1);

        public Builder jobStatus(EvaluationJobStatus var1);
    }
}

