/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.services.bedrock.model.CustomizationType;
import software.amazon.awssdk.services.bedrock.model.ModelCustomizationHyperParametersCopier;
import software.amazon.awssdk.services.bedrock.model.OutputDataConfig;
import software.amazon.awssdk.services.bedrock.model.TrainingDataConfig;
import software.amazon.awssdk.services.bedrock.model.TrainingMetrics;
import software.amazon.awssdk.services.bedrock.model.ValidationDataConfig;
import software.amazon.awssdk.services.bedrock.model.ValidationMetricsCopier;
import software.amazon.awssdk.services.bedrock.model.ValidatorMetric;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCustomModelResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, GetCustomModelResponse> {
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelArn").getter(GetCustomModelResponse.getter(GetCustomModelResponse::modelArn)).setter(GetCustomModelResponse.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()}).build();
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelName").getter(GetCustomModelResponse.getter(GetCustomModelResponse::modelName)).setter(GetCustomModelResponse.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelName").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(GetCustomModelResponse.getter(GetCustomModelResponse::jobName)).setter(GetCustomModelResponse.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobArn").getter(GetCustomModelResponse.getter(GetCustomModelResponse::jobArn)).setter(GetCustomModelResponse.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()}).build();
    private static final SdkField<String> BASE_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("baseModelArn").getter(GetCustomModelResponse.getter(GetCustomModelResponse::baseModelArn)).setter(GetCustomModelResponse.setter(Builder::baseModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseModelArn").build()}).build();
    private static final SdkField<String> CUSTOMIZATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customizationType").getter(GetCustomModelResponse.getter(GetCustomModelResponse::customizationTypeAsString)).setter(GetCustomModelResponse.setter(Builder::customizationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customizationType").build()}).build();
    private static final SdkField<String> MODEL_KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelKmsKeyArn").getter(GetCustomModelResponse.getter(GetCustomModelResponse::modelKmsKeyArn)).setter(GetCustomModelResponse.setter(Builder::modelKmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelKmsKeyArn").build()}).build();
    private static final SdkField<Map<String, String>> HYPER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("hyperParameters").getter(GetCustomModelResponse.getter(GetCustomModelResponse::hyperParameters)).setter(GetCustomModelResponse.setter(Builder::hyperParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hyperParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<TrainingDataConfig> TRAINING_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trainingDataConfig").getter(GetCustomModelResponse.getter(GetCustomModelResponse::trainingDataConfig)).setter(GetCustomModelResponse.setter(Builder::trainingDataConfig)).constructor(TrainingDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataConfig").build()}).build();
    private static final SdkField<ValidationDataConfig> VALIDATION_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("validationDataConfig").getter(GetCustomModelResponse.getter(GetCustomModelResponse::validationDataConfig)).setter(GetCustomModelResponse.setter(Builder::validationDataConfig)).constructor(ValidationDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationDataConfig").build()}).build();
    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputDataConfig").getter(GetCustomModelResponse.getter(GetCustomModelResponse::outputDataConfig)).setter(GetCustomModelResponse.setter(Builder::outputDataConfig)).constructor(OutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDataConfig").build()}).build();
    private static final SdkField<TrainingMetrics> TRAINING_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trainingMetrics").getter(GetCustomModelResponse.getter(GetCustomModelResponse::trainingMetrics)).setter(GetCustomModelResponse.setter(Builder::trainingMetrics)).constructor(TrainingMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingMetrics").build()}).build();
    private static final SdkField<List<ValidatorMetric>> VALIDATION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("validationMetrics").getter(GetCustomModelResponse.getter(GetCustomModelResponse::validationMetrics)).setter(GetCustomModelResponse.setter(Builder::validationMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ValidatorMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetCustomModelResponse.getter(GetCustomModelResponse::creationTime)).setter(GetCustomModelResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ARN_FIELD, MODEL_NAME_FIELD, JOB_NAME_FIELD, JOB_ARN_FIELD, BASE_MODEL_ARN_FIELD, CUSTOMIZATION_TYPE_FIELD, MODEL_KMS_KEY_ARN_FIELD, HYPER_PARAMETERS_FIELD, TRAINING_DATA_CONFIG_FIELD, VALIDATION_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, TRAINING_METRICS_FIELD, VALIDATION_METRICS_FIELD, CREATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("modelArn", MODEL_ARN_FIELD);
            this.put("modelName", MODEL_NAME_FIELD);
            this.put("jobName", JOB_NAME_FIELD);
            this.put("jobArn", JOB_ARN_FIELD);
            this.put("baseModelArn", BASE_MODEL_ARN_FIELD);
            this.put("customizationType", CUSTOMIZATION_TYPE_FIELD);
            this.put("modelKmsKeyArn", MODEL_KMS_KEY_ARN_FIELD);
            this.put("hyperParameters", HYPER_PARAMETERS_FIELD);
            this.put("trainingDataConfig", TRAINING_DATA_CONFIG_FIELD);
            this.put("validationDataConfig", VALIDATION_DATA_CONFIG_FIELD);
            this.put("outputDataConfig", OUTPUT_DATA_CONFIG_FIELD);
            this.put("trainingMetrics", TRAINING_METRICS_FIELD);
            this.put("validationMetrics", VALIDATION_METRICS_FIELD);
            this.put("creationTime", CREATION_TIME_FIELD);
        }
    });
    private final String modelArn;
    private final String modelName;
    private final String jobName;
    private final String jobArn;
    private final String baseModelArn;
    private final String customizationType;
    private final String modelKmsKeyArn;
    private final Map<String, String> hyperParameters;
    private final TrainingDataConfig trainingDataConfig;
    private final ValidationDataConfig validationDataConfig;
    private final OutputDataConfig outputDataConfig;
    private final TrainingMetrics trainingMetrics;
    private final List<ValidatorMetric> validationMetrics;
    private final Instant creationTime;

    private GetCustomModelResponse(BuilderImpl builder) {
        super(builder);
        this.modelArn = builder.modelArn;
        this.modelName = builder.modelName;
        this.jobName = builder.jobName;
        this.jobArn = builder.jobArn;
        this.baseModelArn = builder.baseModelArn;
        this.customizationType = builder.customizationType;
        this.modelKmsKeyArn = builder.modelKmsKeyArn;
        this.hyperParameters = builder.hyperParameters;
        this.trainingDataConfig = builder.trainingDataConfig;
        this.validationDataConfig = builder.validationDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.trainingMetrics = builder.trainingMetrics;
        this.validationMetrics = builder.validationMetrics;
        this.creationTime = builder.creationTime;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String jobArn() {
        return this.jobArn;
    }

    public final String baseModelArn() {
        return this.baseModelArn;
    }

    public final CustomizationType customizationType() {
        return CustomizationType.fromValue(this.customizationType);
    }

    public final String customizationTypeAsString() {
        return this.customizationType;
    }

    public final String modelKmsKeyArn() {
        return this.modelKmsKeyArn;
    }

    public final boolean hasHyperParameters() {
        return this.hyperParameters != null && !(this.hyperParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> hyperParameters() {
        return this.hyperParameters;
    }

    public final TrainingDataConfig trainingDataConfig() {
        return this.trainingDataConfig;
    }

    public final ValidationDataConfig validationDataConfig() {
        return this.validationDataConfig;
    }

    public final OutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public final TrainingMetrics trainingMetrics() {
        return this.trainingMetrics;
    }

    public final boolean hasValidationMetrics() {
        return this.validationMetrics != null && !(this.validationMetrics instanceof SdkAutoConstructList);
    }

    public final List<ValidatorMetric> validationMetrics() {
        return this.validationMetrics;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.customizationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelKmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHyperParameters() ? this.hyperParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidationMetrics() ? this.validationMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCustomModelResponse)) {
            return false;
        }
        GetCustomModelResponse other = (GetCustomModelResponse)((Object)obj);
        return Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobArn(), other.jobArn()) && Objects.equals(this.baseModelArn(), other.baseModelArn()) && Objects.equals(this.customizationTypeAsString(), other.customizationTypeAsString()) && Objects.equals(this.modelKmsKeyArn(), other.modelKmsKeyArn()) && this.hasHyperParameters() == other.hasHyperParameters() && Objects.equals(this.hyperParameters(), other.hyperParameters()) && Objects.equals(this.trainingDataConfig(), other.trainingDataConfig()) && Objects.equals(this.validationDataConfig(), other.validationDataConfig()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && Objects.equals(this.trainingMetrics(), other.trainingMetrics()) && this.hasValidationMetrics() == other.hasValidationMetrics() && Objects.equals(this.validationMetrics(), other.validationMetrics()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetCustomModelResponse").add("ModelArn", (Object)this.modelArn()).add("ModelName", (Object)this.modelName()).add("JobName", (Object)this.jobName()).add("JobArn", (Object)this.jobArn()).add("BaseModelArn", (Object)this.baseModelArn()).add("CustomizationType", (Object)this.customizationTypeAsString()).add("ModelKmsKeyArn", (Object)this.modelKmsKeyArn()).add("HyperParameters", this.hasHyperParameters() ? this.hyperParameters() : null).add("TrainingDataConfig", (Object)this.trainingDataConfig()).add("ValidationDataConfig", (Object)this.validationDataConfig()).add("OutputDataConfig", (Object)this.outputDataConfig()).add("TrainingMetrics", (Object)this.trainingMetrics()).add("ValidationMetrics", this.hasValidationMetrics() ? this.validationMetrics() : null).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "modelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "jobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "baseModelArn": {
                return Optional.ofNullable(clazz.cast(this.baseModelArn()));
            }
            case "customizationType": {
                return Optional.ofNullable(clazz.cast(this.customizationTypeAsString()));
            }
            case "modelKmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.modelKmsKeyArn()));
            }
            case "hyperParameters": {
                return Optional.ofNullable(clazz.cast(this.hyperParameters()));
            }
            case "trainingDataConfig": {
                return Optional.ofNullable(clazz.cast(this.trainingDataConfig()));
            }
            case "validationDataConfig": {
                return Optional.ofNullable(clazz.cast(this.validationDataConfig()));
            }
            case "outputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "trainingMetrics": {
                return Optional.ofNullable(clazz.cast(this.trainingMetrics()));
            }
            case "validationMetrics": {
                return Optional.ofNullable(clazz.cast(this.validationMetrics()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetCustomModelResponse, T> g) {
        return obj -> g.apply((GetCustomModelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private String modelArn;
        private String modelName;
        private String jobName;
        private String jobArn;
        private String baseModelArn;
        private String customizationType;
        private String modelKmsKeyArn;
        private Map<String, String> hyperParameters = DefaultSdkAutoConstructMap.getInstance();
        private TrainingDataConfig trainingDataConfig;
        private ValidationDataConfig validationDataConfig;
        private OutputDataConfig outputDataConfig;
        private TrainingMetrics trainingMetrics;
        private List<ValidatorMetric> validationMetrics = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCustomModelResponse model) {
            super(model);
            this.modelArn(model.modelArn);
            this.modelName(model.modelName);
            this.jobName(model.jobName);
            this.jobArn(model.jobArn);
            this.baseModelArn(model.baseModelArn);
            this.customizationType(model.customizationType);
            this.modelKmsKeyArn(model.modelKmsKeyArn);
            this.hyperParameters(model.hyperParameters);
            this.trainingDataConfig(model.trainingDataConfig);
            this.validationDataConfig(model.validationDataConfig);
            this.outputDataConfig(model.outputDataConfig);
            this.trainingMetrics(model.trainingMetrics);
            this.validationMetrics(model.validationMetrics);
            this.creationTime(model.creationTime);
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getBaseModelArn() {
            return this.baseModelArn;
        }

        public final void setBaseModelArn(String baseModelArn) {
            this.baseModelArn = baseModelArn;
        }

        @Override
        public final Builder baseModelArn(String baseModelArn) {
            this.baseModelArn = baseModelArn;
            return this;
        }

        public final String getCustomizationType() {
            return this.customizationType;
        }

        public final void setCustomizationType(String customizationType) {
            this.customizationType = customizationType;
        }

        @Override
        public final Builder customizationType(String customizationType) {
            this.customizationType = customizationType;
            return this;
        }

        @Override
        public final Builder customizationType(CustomizationType customizationType) {
            this.customizationType(customizationType == null ? null : customizationType.toString());
            return this;
        }

        public final String getModelKmsKeyArn() {
            return this.modelKmsKeyArn;
        }

        public final void setModelKmsKeyArn(String modelKmsKeyArn) {
            this.modelKmsKeyArn = modelKmsKeyArn;
        }

        @Override
        public final Builder modelKmsKeyArn(String modelKmsKeyArn) {
            this.modelKmsKeyArn = modelKmsKeyArn;
            return this;
        }

        public final Map<String, String> getHyperParameters() {
            if (this.hyperParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.hyperParameters;
        }

        public final void setHyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = ModelCustomizationHyperParametersCopier.copy(hyperParameters);
        }

        @Override
        public final Builder hyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = ModelCustomizationHyperParametersCopier.copy(hyperParameters);
            return this;
        }

        public final TrainingDataConfig.Builder getTrainingDataConfig() {
            return this.trainingDataConfig != null ? this.trainingDataConfig.toBuilder() : null;
        }

        public final void setTrainingDataConfig(TrainingDataConfig.BuilderImpl trainingDataConfig) {
            this.trainingDataConfig = trainingDataConfig != null ? trainingDataConfig.build() : null;
        }

        @Override
        public final Builder trainingDataConfig(TrainingDataConfig trainingDataConfig) {
            this.trainingDataConfig = trainingDataConfig;
            return this;
        }

        public final ValidationDataConfig.Builder getValidationDataConfig() {
            return this.validationDataConfig != null ? this.validationDataConfig.toBuilder() : null;
        }

        public final void setValidationDataConfig(ValidationDataConfig.BuilderImpl validationDataConfig) {
            this.validationDataConfig = validationDataConfig != null ? validationDataConfig.build() : null;
        }

        @Override
        public final Builder validationDataConfig(ValidationDataConfig validationDataConfig) {
            this.validationDataConfig = validationDataConfig;
            return this;
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final TrainingMetrics.Builder getTrainingMetrics() {
            return this.trainingMetrics != null ? this.trainingMetrics.toBuilder() : null;
        }

        public final void setTrainingMetrics(TrainingMetrics.BuilderImpl trainingMetrics) {
            this.trainingMetrics = trainingMetrics != null ? trainingMetrics.build() : null;
        }

        @Override
        public final Builder trainingMetrics(TrainingMetrics trainingMetrics) {
            this.trainingMetrics = trainingMetrics;
            return this;
        }

        public final List<ValidatorMetric.Builder> getValidationMetrics() {
            List<ValidatorMetric.Builder> result = ValidationMetricsCopier.copyToBuilder(this.validationMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidationMetrics(Collection<ValidatorMetric.BuilderImpl> validationMetrics) {
            this.validationMetrics = ValidationMetricsCopier.copyFromBuilder(validationMetrics);
        }

        @Override
        public final Builder validationMetrics(Collection<ValidatorMetric> validationMetrics) {
            this.validationMetrics = ValidationMetricsCopier.copy(validationMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationMetrics(ValidatorMetric ... validationMetrics) {
            this.validationMetrics(Arrays.asList(validationMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationMetrics(Consumer<ValidatorMetric.Builder> ... validationMetrics) {
            this.validationMetrics(Stream.of(validationMetrics).map(c -> (ValidatorMetric)((ValidatorMetric.Builder)ValidatorMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public GetCustomModelResponse build() {
            return new GetCustomModelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCustomModelResponse> {
        public Builder modelArn(String var1);

        public Builder modelName(String var1);

        public Builder jobName(String var1);

        public Builder jobArn(String var1);

        public Builder baseModelArn(String var1);

        public Builder customizationType(String var1);

        public Builder customizationType(CustomizationType var1);

        public Builder modelKmsKeyArn(String var1);

        public Builder hyperParameters(Map<String, String> var1);

        public Builder trainingDataConfig(TrainingDataConfig var1);

        default public Builder trainingDataConfig(Consumer<TrainingDataConfig.Builder> trainingDataConfig) {
            return this.trainingDataConfig((TrainingDataConfig)((TrainingDataConfig.Builder)TrainingDataConfig.builder().applyMutation(trainingDataConfig)).build());
        }

        public Builder validationDataConfig(ValidationDataConfig var1);

        default public Builder validationDataConfig(Consumer<ValidationDataConfig.Builder> validationDataConfig) {
            return this.validationDataConfig((ValidationDataConfig)((ValidationDataConfig.Builder)ValidationDataConfig.builder().applyMutation(validationDataConfig)).build());
        }

        public Builder outputDataConfig(OutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((OutputDataConfig)((OutputDataConfig.Builder)OutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder trainingMetrics(TrainingMetrics var1);

        default public Builder trainingMetrics(Consumer<TrainingMetrics.Builder> trainingMetrics) {
            return this.trainingMetrics((TrainingMetrics)((TrainingMetrics.Builder)TrainingMetrics.builder().applyMutation(trainingMetrics)).build());
        }

        public Builder validationMetrics(Collection<ValidatorMetric> var1);

        public Builder validationMetrics(ValidatorMetric ... var1);

        public Builder validationMetrics(Consumer<ValidatorMetric.Builder> ... var1);

        public Builder creationTime(Instant var1);
    }
}

