/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGuardrailResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, CreateGuardrailResponse> {
    private static final SdkField<String> GUARDRAIL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardrailId").getter(CreateGuardrailResponse.getter(CreateGuardrailResponse::guardrailId)).setter(CreateGuardrailResponse.setter(Builder::guardrailId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailId").build()}).build();
    private static final SdkField<String> GUARDRAIL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardrailArn").getter(CreateGuardrailResponse.getter(CreateGuardrailResponse::guardrailArn)).setter(CreateGuardrailResponse.setter(Builder::guardrailArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailArn").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(CreateGuardrailResponse.getter(CreateGuardrailResponse::version)).setter(CreateGuardrailResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(CreateGuardrailResponse.getter(CreateGuardrailResponse::createdAt)).setter(CreateGuardrailResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GUARDRAIL_ID_FIELD, GUARDRAIL_ARN_FIELD, VERSION_FIELD, CREATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("guardrailId", GUARDRAIL_ID_FIELD);
            this.put("guardrailArn", GUARDRAIL_ARN_FIELD);
            this.put("version", VERSION_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
        }
    });
    private final String guardrailId;
    private final String guardrailArn;
    private final String version;
    private final Instant createdAt;

    private CreateGuardrailResponse(BuilderImpl builder) {
        super(builder);
        this.guardrailId = builder.guardrailId;
        this.guardrailArn = builder.guardrailArn;
        this.version = builder.version;
        this.createdAt = builder.createdAt;
    }

    public final String guardrailId() {
        return this.guardrailId;
    }

    public final String guardrailArn() {
        return this.guardrailArn;
    }

    public final String version() {
        return this.version;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailId());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGuardrailResponse)) {
            return false;
        }
        CreateGuardrailResponse other = (CreateGuardrailResponse)((Object)obj);
        return Objects.equals(this.guardrailId(), other.guardrailId()) && Objects.equals(this.guardrailArn(), other.guardrailArn()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.createdAt(), other.createdAt());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGuardrailResponse").add("GuardrailId", (Object)this.guardrailId()).add("GuardrailArn", (Object)this.guardrailArn()).add("Version", (Object)this.version()).add("CreatedAt", (Object)this.createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "guardrailId": {
                return Optional.ofNullable(clazz.cast(this.guardrailId()));
            }
            case "guardrailArn": {
                return Optional.ofNullable(clazz.cast(this.guardrailArn()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateGuardrailResponse, T> g) {
        return obj -> g.apply((CreateGuardrailResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private String guardrailId;
        private String guardrailArn;
        private String version;
        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGuardrailResponse model) {
            super(model);
            this.guardrailId(model.guardrailId);
            this.guardrailArn(model.guardrailArn);
            this.version(model.version);
            this.createdAt(model.createdAt);
        }

        public final String getGuardrailId() {
            return this.guardrailId;
        }

        public final void setGuardrailId(String guardrailId) {
            this.guardrailId = guardrailId;
        }

        @Override
        public final Builder guardrailId(String guardrailId) {
            this.guardrailId = guardrailId;
            return this;
        }

        public final String getGuardrailArn() {
            return this.guardrailArn;
        }

        public final void setGuardrailArn(String guardrailArn) {
            this.guardrailArn = guardrailArn;
        }

        @Override
        public final Builder guardrailArn(String guardrailArn) {
            this.guardrailArn = guardrailArn;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public CreateGuardrailResponse build() {
            return new CreateGuardrailResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGuardrailResponse> {
        public Builder guardrailId(String var1);

        public Builder guardrailArn(String var1);

        public Builder version(String var1);

        public Builder createdAt(Instant var1);
    }
}

