/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationBedrockModel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationBedrockModel> {
    private static final SdkField<String> MODEL_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelIdentifier").getter(EvaluationBedrockModel.getter(EvaluationBedrockModel::modelIdentifier)).setter(EvaluationBedrockModel.setter(Builder::modelIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelIdentifier").build()}).build();
    private static final SdkField<String> INFERENCE_PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inferenceParams").getter(EvaluationBedrockModel.getter(EvaluationBedrockModel::inferenceParams)).setter(EvaluationBedrockModel.setter(Builder::inferenceParams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceParams").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_IDENTIFIER_FIELD, INFERENCE_PARAMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("modelIdentifier", MODEL_IDENTIFIER_FIELD);
            this.put("inferenceParams", INFERENCE_PARAMS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String modelIdentifier;
    private final String inferenceParams;

    private EvaluationBedrockModel(BuilderImpl builder) {
        this.modelIdentifier = builder.modelIdentifier;
        this.inferenceParams = builder.inferenceParams;
    }

    public final String modelIdentifier() {
        return this.modelIdentifier;
    }

    public final String inferenceParams() {
        return this.inferenceParams;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceParams());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationBedrockModel)) {
            return false;
        }
        EvaluationBedrockModel other = (EvaluationBedrockModel)obj;
        return Objects.equals(this.modelIdentifier(), other.modelIdentifier()) && Objects.equals(this.inferenceParams(), other.inferenceParams());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationBedrockModel").add("ModelIdentifier", (Object)this.modelIdentifier()).add("InferenceParams", (Object)(this.inferenceParams() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelIdentifier": {
                return Optional.ofNullable(clazz.cast(this.modelIdentifier()));
            }
            case "inferenceParams": {
                return Optional.ofNullable(clazz.cast(this.inferenceParams()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EvaluationBedrockModel, T> g) {
        return obj -> g.apply((EvaluationBedrockModel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelIdentifier;
        private String inferenceParams;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationBedrockModel model) {
            this.modelIdentifier(model.modelIdentifier);
            this.inferenceParams(model.inferenceParams);
        }

        public final String getModelIdentifier() {
            return this.modelIdentifier;
        }

        public final void setModelIdentifier(String modelIdentifier) {
            this.modelIdentifier = modelIdentifier;
        }

        @Override
        public final Builder modelIdentifier(String modelIdentifier) {
            this.modelIdentifier = modelIdentifier;
            return this;
        }

        public final String getInferenceParams() {
            return this.inferenceParams;
        }

        public final void setInferenceParams(String inferenceParams) {
            this.inferenceParams = inferenceParams;
        }

        @Override
        public final Builder inferenceParams(String inferenceParams) {
            this.inferenceParams = inferenceParams;
            return this;
        }

        public EvaluationBedrockModel build() {
            return new EvaluationBedrockModel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationBedrockModel> {
        public Builder modelIdentifier(String var1);

        public Builder inferenceParams(String var1);
    }
}

