/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.services.bedrock.model.ModelDataSource;
import software.amazon.awssdk.services.bedrock.model.Tag;
import software.amazon.awssdk.services.bedrock.model.TagListCopier;
import software.amazon.awssdk.services.bedrock.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateModelImportJobRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, CreateModelImportJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(CreateModelImportJobRequest.getter(CreateModelImportJobRequest::jobName)).setter(CreateModelImportJobRequest.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> IMPORTED_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importedModelName").getter(CreateModelImportJobRequest.getter(CreateModelImportJobRequest::importedModelName)).setter(CreateModelImportJobRequest.setter(Builder::importedModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importedModelName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateModelImportJobRequest.getter(CreateModelImportJobRequest::roleArn)).setter(CreateModelImportJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<ModelDataSource> MODEL_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("modelDataSource").getter(CreateModelImportJobRequest.getter(CreateModelImportJobRequest::modelDataSource)).setter(CreateModelImportJobRequest.setter(Builder::modelDataSource)).constructor(ModelDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelDataSource").build()}).build();
    private static final SdkField<List<Tag>> JOB_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("jobTags").getter(CreateModelImportJobRequest.getter(CreateModelImportJobRequest::jobTags)).setter(CreateModelImportJobRequest.setter(Builder::jobTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> IMPORTED_MODEL_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("importedModelTags").getter(CreateModelImportJobRequest.getter(CreateModelImportJobRequest::importedModelTags)).setter(CreateModelImportJobRequest.setter(Builder::importedModelTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importedModelTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(CreateModelImportJobRequest.getter(CreateModelImportJobRequest::clientRequestToken)).setter(CreateModelImportJobRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcConfig").getter(CreateModelImportJobRequest.getter(CreateModelImportJobRequest::vpcConfig)).setter(CreateModelImportJobRequest.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()}).build();
    private static final SdkField<String> IMPORTED_MODEL_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importedModelKmsKeyId").getter(CreateModelImportJobRequest.getter(CreateModelImportJobRequest::importedModelKmsKeyId)).setter(CreateModelImportJobRequest.setter(Builder::importedModelKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importedModelKmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, IMPORTED_MODEL_NAME_FIELD, ROLE_ARN_FIELD, MODEL_DATA_SOURCE_FIELD, JOB_TAGS_FIELD, IMPORTED_MODEL_TAGS_FIELD, CLIENT_REQUEST_TOKEN_FIELD, VPC_CONFIG_FIELD, IMPORTED_MODEL_KMS_KEY_ID_FIELD));
    private final String jobName;
    private final String importedModelName;
    private final String roleArn;
    private final ModelDataSource modelDataSource;
    private final List<Tag> jobTags;
    private final List<Tag> importedModelTags;
    private final String clientRequestToken;
    private final VpcConfig vpcConfig;
    private final String importedModelKmsKeyId;

    private CreateModelImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.importedModelName = builder.importedModelName;
        this.roleArn = builder.roleArn;
        this.modelDataSource = builder.modelDataSource;
        this.jobTags = builder.jobTags;
        this.importedModelTags = builder.importedModelTags;
        this.clientRequestToken = builder.clientRequestToken;
        this.vpcConfig = builder.vpcConfig;
        this.importedModelKmsKeyId = builder.importedModelKmsKeyId;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String importedModelName() {
        return this.importedModelName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final ModelDataSource modelDataSource() {
        return this.modelDataSource;
    }

    public final boolean hasJobTags() {
        return this.jobTags != null && !(this.jobTags instanceof SdkAutoConstructList);
    }

    public final List<Tag> jobTags() {
        return this.jobTags;
    }

    public final boolean hasImportedModelTags() {
        return this.importedModelTags != null && !(this.importedModelTags instanceof SdkAutoConstructList);
    }

    public final List<Tag> importedModelTags() {
        return this.importedModelTags;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final String importedModelKmsKeyId() {
        return this.importedModelKmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobTags() ? this.jobTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImportedModelTags() ? this.importedModelTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedModelKmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelImportJobRequest)) {
            return false;
        }
        CreateModelImportJobRequest other = (CreateModelImportJobRequest)((Object)obj);
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.importedModelName(), other.importedModelName()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.modelDataSource(), other.modelDataSource()) && this.hasJobTags() == other.hasJobTags() && Objects.equals(this.jobTags(), other.jobTags()) && this.hasImportedModelTags() == other.hasImportedModelTags() && Objects.equals(this.importedModelTags(), other.importedModelTags()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.importedModelKmsKeyId(), other.importedModelKmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateModelImportJobRequest").add("JobName", (Object)this.jobName()).add("ImportedModelName", (Object)this.importedModelName()).add("RoleArn", (Object)this.roleArn()).add("ModelDataSource", (Object)this.modelDataSource()).add("JobTags", this.hasJobTags() ? this.jobTags() : null).add("ImportedModelTags", this.hasImportedModelTags() ? this.importedModelTags() : null).add("ClientRequestToken", (Object)this.clientRequestToken()).add("VpcConfig", (Object)this.vpcConfig()).add("ImportedModelKmsKeyId", (Object)this.importedModelKmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "importedModelName": {
                return Optional.ofNullable(clazz.cast(this.importedModelName()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "modelDataSource": {
                return Optional.ofNullable(clazz.cast(this.modelDataSource()));
            }
            case "jobTags": {
                return Optional.ofNullable(clazz.cast(this.jobTags()));
            }
            case "importedModelTags": {
                return Optional.ofNullable(clazz.cast(this.importedModelTags()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "vpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "importedModelKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.importedModelKmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateModelImportJobRequest, T> g) {
        return obj -> g.apply((CreateModelImportJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private String jobName;
        private String importedModelName;
        private String roleArn;
        private ModelDataSource modelDataSource;
        private List<Tag> jobTags = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> importedModelTags = DefaultSdkAutoConstructList.getInstance();
        private String clientRequestToken;
        private VpcConfig vpcConfig;
        private String importedModelKmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelImportJobRequest model) {
            super(model);
            this.jobName(model.jobName);
            this.importedModelName(model.importedModelName);
            this.roleArn(model.roleArn);
            this.modelDataSource(model.modelDataSource);
            this.jobTags(model.jobTags);
            this.importedModelTags(model.importedModelTags);
            this.clientRequestToken(model.clientRequestToken);
            this.vpcConfig(model.vpcConfig);
            this.importedModelKmsKeyId(model.importedModelKmsKeyId);
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getImportedModelName() {
            return this.importedModelName;
        }

        public final void setImportedModelName(String importedModelName) {
            this.importedModelName = importedModelName;
        }

        @Override
        public final Builder importedModelName(String importedModelName) {
            this.importedModelName = importedModelName;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final ModelDataSource.Builder getModelDataSource() {
            return this.modelDataSource != null ? this.modelDataSource.toBuilder() : null;
        }

        public final void setModelDataSource(ModelDataSource.BuilderImpl modelDataSource) {
            this.modelDataSource = modelDataSource != null ? modelDataSource.build() : null;
        }

        @Override
        public final Builder modelDataSource(ModelDataSource modelDataSource) {
            this.modelDataSource = modelDataSource;
            return this;
        }

        public final List<Tag.Builder> getJobTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.jobTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobTags(Collection<Tag.BuilderImpl> jobTags) {
            this.jobTags = TagListCopier.copyFromBuilder(jobTags);
        }

        @Override
        public final Builder jobTags(Collection<Tag> jobTags) {
            this.jobTags = TagListCopier.copy(jobTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobTags(Tag ... jobTags) {
            this.jobTags(Arrays.asList(jobTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobTags(Consumer<Tag.Builder> ... jobTags) {
            this.jobTags(Stream.of(jobTags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getImportedModelTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.importedModelTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImportedModelTags(Collection<Tag.BuilderImpl> importedModelTags) {
            this.importedModelTags = TagListCopier.copyFromBuilder(importedModelTags);
        }

        @Override
        public final Builder importedModelTags(Collection<Tag> importedModelTags) {
            this.importedModelTags = TagListCopier.copy(importedModelTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importedModelTags(Tag ... importedModelTags) {
            this.importedModelTags(Arrays.asList(importedModelTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importedModelTags(Consumer<Tag.Builder> ... importedModelTags) {
            this.importedModelTags(Stream.of(importedModelTags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final String getImportedModelKmsKeyId() {
            return this.importedModelKmsKeyId;
        }

        public final void setImportedModelKmsKeyId(String importedModelKmsKeyId) {
            this.importedModelKmsKeyId = importedModelKmsKeyId;
        }

        @Override
        public final Builder importedModelKmsKeyId(String importedModelKmsKeyId) {
            this.importedModelKmsKeyId = importedModelKmsKeyId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateModelImportJobRequest build() {
            return new CreateModelImportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateModelImportJobRequest> {
        public Builder jobName(String var1);

        public Builder importedModelName(String var1);

        public Builder roleArn(String var1);

        public Builder modelDataSource(ModelDataSource var1);

        default public Builder modelDataSource(Consumer<ModelDataSource.Builder> modelDataSource) {
            return this.modelDataSource((ModelDataSource)((ModelDataSource.Builder)ModelDataSource.builder().applyMutation(modelDataSource)).build());
        }

        public Builder jobTags(Collection<Tag> var1);

        public Builder jobTags(Tag ... var1);

        public Builder jobTags(Consumer<Tag.Builder> ... var1);

        public Builder importedModelTags(Collection<Tag> var1);

        public Builder importedModelTags(Tag ... var1);

        public Builder importedModelTags(Consumer<Tag.Builder> ... var1);

        public Builder clientRequestToken(String var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder importedModelKmsKeyId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

