/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEvaluationJobRequest extends BedrockRequest implements
        ToCopyableBuilder<CreateEvaluationJobRequest.Builder, CreateEvaluationJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(CreateEvaluationJobRequest::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> JOB_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobDescription").getter(getter(CreateEvaluationJobRequest::jobDescription))
            .setter(setter(Builder::jobDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDescription").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(CreateEvaluationJobRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateEvaluationJobRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> CUSTOMER_ENCRYPTION_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerEncryptionKeyId").getter(getter(CreateEvaluationJobRequest::customerEncryptionKeyId))
            .setter(setter(Builder::customerEncryptionKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerEncryptionKeyId").build())
            .build();

    private static final SdkField<List<Tag>> JOB_TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("jobTags")
            .getter(getter(CreateEvaluationJobRequest::jobTags))
            .setter(setter(Builder::jobTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EvaluationConfig> EVALUATION_CONFIG_FIELD = SdkField
            .<EvaluationConfig> builder(MarshallingType.SDK_POJO).memberName("evaluationConfig")
            .getter(getter(CreateEvaluationJobRequest::evaluationConfig)).setter(setter(Builder::evaluationConfig))
            .constructor(EvaluationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationConfig").build()).build();

    private static final SdkField<EvaluationInferenceConfig> INFERENCE_CONFIG_FIELD = SdkField
            .<EvaluationInferenceConfig> builder(MarshallingType.SDK_POJO).memberName("inferenceConfig")
            .getter(getter(CreateEvaluationJobRequest::inferenceConfig)).setter(setter(Builder::inferenceConfig))
            .constructor(EvaluationInferenceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfig").build()).build();

    private static final SdkField<EvaluationOutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<EvaluationOutputDataConfig> builder(MarshallingType.SDK_POJO).memberName("outputDataConfig")
            .getter(getter(CreateEvaluationJobRequest::outputDataConfig)).setter(setter(Builder::outputDataConfig))
            .constructor(EvaluationOutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDataConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            JOB_DESCRIPTION_FIELD, CLIENT_REQUEST_TOKEN_FIELD, ROLE_ARN_FIELD, CUSTOMER_ENCRYPTION_KEY_ID_FIELD, JOB_TAGS_FIELD,
            EVALUATION_CONFIG_FIELD, INFERENCE_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD));

    private final String jobName;

    private final String jobDescription;

    private final String clientRequestToken;

    private final String roleArn;

    private final String customerEncryptionKeyId;

    private final List<Tag> jobTags;

    private final EvaluationConfig evaluationConfig;

    private final EvaluationInferenceConfig inferenceConfig;

    private final EvaluationOutputDataConfig outputDataConfig;

    private CreateEvaluationJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.jobDescription = builder.jobDescription;
        this.clientRequestToken = builder.clientRequestToken;
        this.roleArn = builder.roleArn;
        this.customerEncryptionKeyId = builder.customerEncryptionKeyId;
        this.jobTags = builder.jobTags;
        this.evaluationConfig = builder.evaluationConfig;
        this.inferenceConfig = builder.inferenceConfig;
        this.outputDataConfig = builder.outputDataConfig;
    }

    /**
     * <p>
     * The name of the model evaluation job. Model evaluation job names must unique with your AWS account, and your
     * account's AWS region.
     * </p>
     * 
     * @return The name of the model evaluation job. Model evaluation job names must unique with your AWS account, and
     *         your account's AWS region.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * A description of the model evaluation job.
     * </p>
     * 
     * @return A description of the model evaluation job.
     */
    public final String jobDescription() {
        return jobDescription;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token
     * matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If
     *         this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         idempotency</a>.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM service role that Amazon Bedrock can assume to perform tasks on your
     * behalf. The service role must have Amazon Bedrock as the service principal, and provide access to any Amazon S3
     * buckets specified in the <code>EvaluationConfig</code> object. To pass this role to Amazon Bedrock, the caller of
     * this API must have the <code>iam:PassRole</code> permission. To learn more about the required permissions, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation-security.html">Required
     * permissions</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM service role that Amazon Bedrock can assume to perform tasks on
     *         your behalf. The service role must have Amazon Bedrock as the service principal, and provide access to
     *         any Amazon S3 buckets specified in the <code>EvaluationConfig</code> object. To pass this role to Amazon
     *         Bedrock, the caller of this API must have the <code>iam:PassRole</code> permission. To learn more about
     *         the required permissions, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation-security.html">Required
     *         permissions</a>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Specify your customer managed key ARN that will be used to encrypt your model evaluation job.
     * </p>
     * 
     * @return Specify your customer managed key ARN that will be used to encrypt your model evaluation job.
     */
    public final String customerEncryptionKeyId() {
        return customerEncryptionKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobTags property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasJobTags() {
        return jobTags != null && !(jobTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags to attach to the model evaluation job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobTags} method.
     * </p>
     * 
     * @return Tags to attach to the model evaluation job.
     */
    public final List<Tag> jobTags() {
        return jobTags;
    }

    /**
     * <p>
     * Specifies whether the model evaluation job is automatic or uses human worker.
     * </p>
     * 
     * @return Specifies whether the model evaluation job is automatic or uses human worker.
     */
    public final EvaluationConfig evaluationConfig() {
        return evaluationConfig;
    }

    /**
     * <p>
     * Specify the models you want to use in your model evaluation job. Automatic model evaluation jobs support a single
     * model, and model evaluation job that use human workers support two models.
     * </p>
     * 
     * @return Specify the models you want to use in your model evaluation job. Automatic model evaluation jobs support
     *         a single model, and model evaluation job that use human workers support two models.
     */
    public final EvaluationInferenceConfig inferenceConfig() {
        return inferenceConfig;
    }

    /**
     * <p>
     * An object that defines where the results of model evaluation job will be saved in Amazon S3.
     * </p>
     * 
     * @return An object that defines where the results of model evaluation job will be saved in Amazon S3.
     */
    public final EvaluationOutputDataConfig outputDataConfig() {
        return outputDataConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobDescription());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(customerEncryptionKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasJobTags() ? jobTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(evaluationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(outputDataConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEvaluationJobRequest)) {
            return false;
        }
        CreateEvaluationJobRequest other = (CreateEvaluationJobRequest) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(jobDescription(), other.jobDescription())
                && Objects.equals(clientRequestToken(), other.clientRequestToken()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(customerEncryptionKeyId(), other.customerEncryptionKeyId())
                && hasJobTags() == other.hasJobTags() && Objects.equals(jobTags(), other.jobTags())
                && Objects.equals(evaluationConfig(), other.evaluationConfig())
                && Objects.equals(inferenceConfig(), other.inferenceConfig())
                && Objects.equals(outputDataConfig(), other.outputDataConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEvaluationJobRequest").add("JobName", jobName())
                .add("JobDescription", jobDescription() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ClientRequestToken", clientRequestToken()).add("RoleArn", roleArn())
                .add("CustomerEncryptionKeyId", customerEncryptionKeyId()).add("JobTags", hasJobTags() ? jobTags() : null)
                .add("EvaluationConfig", evaluationConfig()).add("InferenceConfig", inferenceConfig())
                .add("OutputDataConfig", outputDataConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "jobDescription":
            return Optional.ofNullable(clazz.cast(jobDescription()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "customerEncryptionKeyId":
            return Optional.ofNullable(clazz.cast(customerEncryptionKeyId()));
        case "jobTags":
            return Optional.ofNullable(clazz.cast(jobTags()));
        case "evaluationConfig":
            return Optional.ofNullable(clazz.cast(evaluationConfig()));
        case "inferenceConfig":
            return Optional.ofNullable(clazz.cast(inferenceConfig()));
        case "outputDataConfig":
            return Optional.ofNullable(clazz.cast(outputDataConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEvaluationJobRequest, T> g) {
        return obj -> g.apply((CreateEvaluationJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateEvaluationJobRequest> {
        /**
         * <p>
         * The name of the model evaluation job. Model evaluation job names must unique with your AWS account, and your
         * account's AWS region.
         * </p>
         * 
         * @param jobName
         *        The name of the model evaluation job. Model evaluation job names must unique with your AWS account,
         *        and your account's AWS region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * A description of the model evaluation job.
         * </p>
         * 
         * @param jobDescription
         *        A description of the model evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDescription(String jobDescription);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this
         * token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * idempotency</a>.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If
         *        this token matches a previous request, Amazon Bedrock ignores the request, but does not return an
         *        error. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM service role that Amazon Bedrock can assume to perform tasks on your
         * behalf. The service role must have Amazon Bedrock as the service principal, and provide access to any Amazon
         * S3 buckets specified in the <code>EvaluationConfig</code> object. To pass this role to Amazon Bedrock, the
         * caller of this API must have the <code>iam:PassRole</code> permission. To learn more about the required
         * permissions, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation-security.html">Required
         * permissions</a>.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM service role that Amazon Bedrock can assume to perform tasks
         *        on your behalf. The service role must have Amazon Bedrock as the service principal, and provide access
         *        to any Amazon S3 buckets specified in the <code>EvaluationConfig</code> object. To pass this role to
         *        Amazon Bedrock, the caller of this API must have the <code>iam:PassRole</code> permission. To learn
         *        more about the required permissions, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation-security.html">Required
         *        permissions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Specify your customer managed key ARN that will be used to encrypt your model evaluation job.
         * </p>
         * 
         * @param customerEncryptionKeyId
         *        Specify your customer managed key ARN that will be used to encrypt your model evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerEncryptionKeyId(String customerEncryptionKeyId);

        /**
         * <p>
         * Tags to attach to the model evaluation job.
         * </p>
         * 
         * @param jobTags
         *        Tags to attach to the model evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTags(Collection<Tag> jobTags);

        /**
         * <p>
         * Tags to attach to the model evaluation job.
         * </p>
         * 
         * @param jobTags
         *        Tags to attach to the model evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTags(Tag... jobTags);

        /**
         * <p>
         * Tags to attach to the model evaluation job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.bedrock.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #jobTags(List<Tag>)}.
         * 
         * @param jobTags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.bedrock.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobTags(java.util.Collection<Tag>)
         */
        Builder jobTags(Consumer<Tag.Builder>... jobTags);

        /**
         * <p>
         * Specifies whether the model evaluation job is automatic or uses human worker.
         * </p>
         * 
         * @param evaluationConfig
         *        Specifies whether the model evaluation job is automatic or uses human worker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationConfig(EvaluationConfig evaluationConfig);

        /**
         * <p>
         * Specifies whether the model evaluation job is automatic or uses human worker.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationConfig.Builder} avoiding the
         * need to create one manually via {@link EvaluationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #evaluationConfig(EvaluationConfig)}.
         * 
         * @param evaluationConfig
         *        a consumer that will call methods on {@link EvaluationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluationConfig(EvaluationConfig)
         */
        default Builder evaluationConfig(Consumer<EvaluationConfig.Builder> evaluationConfig) {
            return evaluationConfig(EvaluationConfig.builder().applyMutation(evaluationConfig).build());
        }

        /**
         * <p>
         * Specify the models you want to use in your model evaluation job. Automatic model evaluation jobs support a
         * single model, and model evaluation job that use human workers support two models.
         * </p>
         * 
         * @param inferenceConfig
         *        Specify the models you want to use in your model evaluation job. Automatic model evaluation jobs
         *        support a single model, and model evaluation job that use human workers support two models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceConfig(EvaluationInferenceConfig inferenceConfig);

        /**
         * <p>
         * Specify the models you want to use in your model evaluation job. Automatic model evaluation jobs support a
         * single model, and model evaluation job that use human workers support two models.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationInferenceConfig.Builder}
         * avoiding the need to create one manually via {@link EvaluationInferenceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationInferenceConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #inferenceConfig(EvaluationInferenceConfig)}.
         * 
         * @param inferenceConfig
         *        a consumer that will call methods on {@link EvaluationInferenceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceConfig(EvaluationInferenceConfig)
         */
        default Builder inferenceConfig(Consumer<EvaluationInferenceConfig.Builder> inferenceConfig) {
            return inferenceConfig(EvaluationInferenceConfig.builder().applyMutation(inferenceConfig).build());
        }

        /**
         * <p>
         * An object that defines where the results of model evaluation job will be saved in Amazon S3.
         * </p>
         * 
         * @param outputDataConfig
         *        An object that defines where the results of model evaluation job will be saved in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDataConfig(EvaluationOutputDataConfig outputDataConfig);

        /**
         * <p>
         * An object that defines where the results of model evaluation job will be saved in Amazon S3.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationOutputDataConfig.Builder}
         * avoiding the need to create one manually via {@link EvaluationOutputDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationOutputDataConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #outputDataConfig(EvaluationOutputDataConfig)}.
         * 
         * @param outputDataConfig
         *        a consumer that will call methods on {@link EvaluationOutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDataConfig(EvaluationOutputDataConfig)
         */
        default Builder outputDataConfig(Consumer<EvaluationOutputDataConfig.Builder> outputDataConfig) {
            return outputDataConfig(EvaluationOutputDataConfig.builder().applyMutation(outputDataConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private String jobName;

        private String jobDescription;

        private String clientRequestToken;

        private String roleArn;

        private String customerEncryptionKeyId;

        private List<Tag> jobTags = DefaultSdkAutoConstructList.getInstance();

        private EvaluationConfig evaluationConfig;

        private EvaluationInferenceConfig inferenceConfig;

        private EvaluationOutputDataConfig outputDataConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEvaluationJobRequest model) {
            super(model);
            jobName(model.jobName);
            jobDescription(model.jobDescription);
            clientRequestToken(model.clientRequestToken);
            roleArn(model.roleArn);
            customerEncryptionKeyId(model.customerEncryptionKeyId);
            jobTags(model.jobTags);
            evaluationConfig(model.evaluationConfig);
            inferenceConfig(model.inferenceConfig);
            outputDataConfig(model.outputDataConfig);
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobDescription() {
            return jobDescription;
        }

        public final void setJobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
        }

        @Override
        public final Builder jobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getCustomerEncryptionKeyId() {
            return customerEncryptionKeyId;
        }

        public final void setCustomerEncryptionKeyId(String customerEncryptionKeyId) {
            this.customerEncryptionKeyId = customerEncryptionKeyId;
        }

        @Override
        public final Builder customerEncryptionKeyId(String customerEncryptionKeyId) {
            this.customerEncryptionKeyId = customerEncryptionKeyId;
            return this;
        }

        public final List<Tag.Builder> getJobTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.jobTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobTags(Collection<Tag.BuilderImpl> jobTags) {
            this.jobTags = TagListCopier.copyFromBuilder(jobTags);
        }

        @Override
        public final Builder jobTags(Collection<Tag> jobTags) {
            this.jobTags = TagListCopier.copy(jobTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobTags(Tag... jobTags) {
            jobTags(Arrays.asList(jobTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobTags(Consumer<Tag.Builder>... jobTags) {
            jobTags(Stream.of(jobTags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final EvaluationConfig.Builder getEvaluationConfig() {
            return evaluationConfig != null ? evaluationConfig.toBuilder() : null;
        }

        public final void setEvaluationConfig(EvaluationConfig.BuilderImpl evaluationConfig) {
            this.evaluationConfig = evaluationConfig != null ? evaluationConfig.build() : null;
        }

        @Override
        public final Builder evaluationConfig(EvaluationConfig evaluationConfig) {
            this.evaluationConfig = evaluationConfig;
            return this;
        }

        public final EvaluationInferenceConfig.Builder getInferenceConfig() {
            return inferenceConfig != null ? inferenceConfig.toBuilder() : null;
        }

        public final void setInferenceConfig(EvaluationInferenceConfig.BuilderImpl inferenceConfig) {
            this.inferenceConfig = inferenceConfig != null ? inferenceConfig.build() : null;
        }

        @Override
        public final Builder inferenceConfig(EvaluationInferenceConfig inferenceConfig) {
            this.inferenceConfig = inferenceConfig;
            return this;
        }

        public final EvaluationOutputDataConfig.Builder getOutputDataConfig() {
            return outputDataConfig != null ? outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(EvaluationOutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(EvaluationOutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEvaluationJobRequest build() {
            return new CreateEvaluationJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
