/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InferenceType {
    ON_DEMAND("ON_DEMAND"),
    PROVISIONED("PROVISIONED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InferenceType> VALUE_MAP;
    private final String value;

    private InferenceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InferenceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InferenceType> knownValues() {
        EnumSet<InferenceType> knownValues = EnumSet.allOf(InferenceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InferenceType.class, InferenceType::toString);
    }
}

