/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.services.bedrock.model.ModelInvocationJobInputDataConfig;
import software.amazon.awssdk.services.bedrock.model.ModelInvocationJobOutputDataConfig;
import software.amazon.awssdk.services.bedrock.model.Tag;
import software.amazon.awssdk.services.bedrock.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateModelInvocationJobRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, CreateModelInvocationJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(CreateModelInvocationJobRequest.getter(CreateModelInvocationJobRequest::jobName)).setter(CreateModelInvocationJobRequest.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateModelInvocationJobRequest.getter(CreateModelInvocationJobRequest::roleArn)).setter(CreateModelInvocationJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(CreateModelInvocationJobRequest.getter(CreateModelInvocationJobRequest::clientRequestToken)).setter(CreateModelInvocationJobRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(CreateModelInvocationJobRequest.getter(CreateModelInvocationJobRequest::modelId)).setter(CreateModelInvocationJobRequest.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final SdkField<ModelInvocationJobInputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inputDataConfig").getter(CreateModelInvocationJobRequest.getter(CreateModelInvocationJobRequest::inputDataConfig)).setter(CreateModelInvocationJobRequest.setter(Builder::inputDataConfig)).constructor(ModelInvocationJobInputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDataConfig").build()}).build();
    private static final SdkField<ModelInvocationJobOutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputDataConfig").getter(CreateModelInvocationJobRequest.getter(CreateModelInvocationJobRequest::outputDataConfig)).setter(CreateModelInvocationJobRequest.setter(Builder::outputDataConfig)).constructor(ModelInvocationJobOutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDataConfig").build()}).build();
    private static final SdkField<Integer> TIMEOUT_DURATION_IN_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("timeoutDurationInHours").getter(CreateModelInvocationJobRequest.getter(CreateModelInvocationJobRequest::timeoutDurationInHours)).setter(CreateModelInvocationJobRequest.setter(Builder::timeoutDurationInHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutDurationInHours").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateModelInvocationJobRequest.getter(CreateModelInvocationJobRequest::tags)).setter(CreateModelInvocationJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, ROLE_ARN_FIELD, CLIENT_REQUEST_TOKEN_FIELD, MODEL_ID_FIELD, INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, TIMEOUT_DURATION_IN_HOURS_FIELD, TAGS_FIELD));
    private final String jobName;
    private final String roleArn;
    private final String clientRequestToken;
    private final String modelId;
    private final ModelInvocationJobInputDataConfig inputDataConfig;
    private final ModelInvocationJobOutputDataConfig outputDataConfig;
    private final Integer timeoutDurationInHours;
    private final List<Tag> tags;

    private CreateModelInvocationJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.roleArn = builder.roleArn;
        this.clientRequestToken = builder.clientRequestToken;
        this.modelId = builder.modelId;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.timeoutDurationInHours = builder.timeoutDurationInHours;
        this.tags = builder.tags;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final ModelInvocationJobInputDataConfig inputDataConfig() {
        return this.inputDataConfig;
    }

    public final ModelInvocationJobOutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public final Integer timeoutDurationInHours() {
        return this.timeoutDurationInHours;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutDurationInHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelInvocationJobRequest)) {
            return false;
        }
        CreateModelInvocationJobRequest other = (CreateModelInvocationJobRequest)((Object)obj);
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.modelId(), other.modelId()) && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && Objects.equals(this.timeoutDurationInHours(), other.timeoutDurationInHours()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateModelInvocationJobRequest").add("JobName", (Object)this.jobName()).add("RoleArn", (Object)this.roleArn()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("ModelId", (Object)this.modelId()).add("InputDataConfig", (Object)this.inputDataConfig()).add("OutputDataConfig", (Object)this.outputDataConfig()).add("TimeoutDurationInHours", (Object)this.timeoutDurationInHours()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "inputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "outputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "timeoutDurationInHours": {
                return Optional.ofNullable(clazz.cast(this.timeoutDurationInHours()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateModelInvocationJobRequest, T> g) {
        return obj -> g.apply((CreateModelInvocationJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private String jobName;
        private String roleArn;
        private String clientRequestToken;
        private String modelId;
        private ModelInvocationJobInputDataConfig inputDataConfig;
        private ModelInvocationJobOutputDataConfig outputDataConfig;
        private Integer timeoutDurationInHours;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelInvocationJobRequest model) {
            super(model);
            this.jobName(model.jobName);
            this.roleArn(model.roleArn);
            this.clientRequestToken(model.clientRequestToken);
            this.modelId(model.modelId);
            this.inputDataConfig(model.inputDataConfig);
            this.outputDataConfig(model.outputDataConfig);
            this.timeoutDurationInHours(model.timeoutDurationInHours);
            this.tags(model.tags);
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final ModelInvocationJobInputDataConfig.Builder getInputDataConfig() {
            return this.inputDataConfig != null ? this.inputDataConfig.toBuilder() : null;
        }

        public final void setInputDataConfig(ModelInvocationJobInputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        @Override
        public final Builder inputDataConfig(ModelInvocationJobInputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final ModelInvocationJobOutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(ModelInvocationJobOutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(ModelInvocationJobOutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final Integer getTimeoutDurationInHours() {
            return this.timeoutDurationInHours;
        }

        public final void setTimeoutDurationInHours(Integer timeoutDurationInHours) {
            this.timeoutDurationInHours = timeoutDurationInHours;
        }

        @Override
        public final Builder timeoutDurationInHours(Integer timeoutDurationInHours) {
            this.timeoutDurationInHours = timeoutDurationInHours;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateModelInvocationJobRequest build() {
            return new CreateModelInvocationJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateModelInvocationJobRequest> {
        public Builder jobName(String var1);

        public Builder roleArn(String var1);

        public Builder clientRequestToken(String var1);

        public Builder modelId(String var1);

        public Builder inputDataConfig(ModelInvocationJobInputDataConfig var1);

        default public Builder inputDataConfig(Consumer<ModelInvocationJobInputDataConfig.Builder> inputDataConfig) {
            return this.inputDataConfig((ModelInvocationJobInputDataConfig)((ModelInvocationJobInputDataConfig.Builder)ModelInvocationJobInputDataConfig.builder().applyMutation(inputDataConfig)).build());
        }

        public Builder outputDataConfig(ModelInvocationJobOutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<ModelInvocationJobOutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((ModelInvocationJobOutputDataConfig)((ModelInvocationJobOutputDataConfig.Builder)ModelInvocationJobOutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder timeoutDurationInHours(Integer var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

