/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.bedrock.BedrockClient;
import software.amazon.awssdk.services.bedrock.BedrockClientBuilder;
import software.amazon.awssdk.services.bedrock.BedrockServiceClientConfiguration;
import software.amazon.awssdk.services.bedrock.DefaultBedrockBaseClientBuilder;
import software.amazon.awssdk.services.bedrock.DefaultBedrockClient;
import software.amazon.awssdk.services.bedrock.endpoints.BedrockEndpointProvider;

@SdkInternalApi
final class DefaultBedrockClientBuilder
extends DefaultBedrockBaseClientBuilder<BedrockClientBuilder, BedrockClient>
implements BedrockClientBuilder {
    DefaultBedrockClientBuilder() {
    }

    @Override
    public DefaultBedrockClientBuilder endpointProvider(BedrockEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final BedrockClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultBedrockClientBuilder.validateClientOptions(clientConfiguration);
        BedrockServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultBedrockClient client = new DefaultBedrockClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private BedrockServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return BedrockServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

