/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.services.bedrock.model.ModelCustomizationHyperParametersCopier;
import software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobStatus;
import software.amazon.awssdk.services.bedrock.model.OutputDataConfig;
import software.amazon.awssdk.services.bedrock.model.TrainingDataConfig;
import software.amazon.awssdk.services.bedrock.model.TrainingMetrics;
import software.amazon.awssdk.services.bedrock.model.ValidationDataConfig;
import software.amazon.awssdk.services.bedrock.model.ValidationMetricsCopier;
import software.amazon.awssdk.services.bedrock.model.ValidatorMetric;
import software.amazon.awssdk.services.bedrock.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetModelCustomizationJobResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, GetModelCustomizationJobResponse> {
    private static final SdkField<String> BASE_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("baseModelArn").getter(GetModelCustomizationJobResponse.getter(GetModelCustomizationJobResponse::baseModelArn)).setter(GetModelCustomizationJobResponse.setter(Builder::baseModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseModelArn").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(GetModelCustomizationJobResponse.getter(GetModelCustomizationJobResponse::clientRequestToken)).setter(GetModelCustomizationJobResponse.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetModelCustomizationJobResponse.getter(GetModelCustomizationJobResponse::creationTime)).setter(GetModelCustomizationJobResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(GetModelCustomizationJobResponse.getter(GetModelCustomizationJobResponse::endTime)).setter(GetModelCustomizationJobResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureMessage").getter(GetModelCustomizationJobResponse.getter(GetModelCustomizationJobResponse::failureMessage)).setter(GetModelCustomizationJobResponse.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()}).build();
    private static final SdkField<Map<String, String>> HYPER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("hyperParameters").getter(GetModelCustomizationJobResponse.getter(GetModelCustomizationJobResponse::hyperParameters)).setter(GetModelCustomizationJobResponse.setter(Builder::hyperParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hyperParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobArn").getter(GetModelCustomizationJobResponse.getter(GetModelCustomizationJobResponse::jobArn)).setter(GetModelCustomizationJobResponse.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(GetModelCustomizationJobResponse.getter(GetModelCustomizationJobResponse::jobName)).setter(GetModelCustomizationJobResponse.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTime").getter(GetModelCustomizationJobResponse.getter(GetModelCustomizationJobResponse::lastModifiedTime)).setter(GetModelCustomizationJobResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputDataConfig").getter(GetModelCustomizationJobResponse.getter(GetModelCustomizationJobResponse::outputDataConfig)).setter(GetModelCustomizationJobResponse.setter(Builder::outputDataConfig)).constructor(OutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDataConfig").build()}).build();
    private static final SdkField<String> OUTPUT_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputModelArn").getter(GetModelCustomizationJobResponse.getter(GetModelCustomizationJobResponse::outputModelArn)).setter(GetModelCustomizationJobResponse.setter(Builder::outputModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputModelArn").build()}).build();
    private static final SdkField<String> OUTPUT_MODEL_KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputModelKmsKeyArn").getter(GetModelCustomizationJobResponse.getter(GetModelCustomizationJobResponse::outputModelKmsKeyArn)).setter(GetModelCustomizationJobResponse.setter(Builder::outputModelKmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputModelKmsKeyArn").build()}).build();
    private static final SdkField<String> OUTPUT_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputModelName").getter(GetModelCustomizationJobResponse.getter(GetModelCustomizationJobResponse::outputModelName)).setter(GetModelCustomizationJobResponse.setter(Builder::outputModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputModelName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(GetModelCustomizationJobResponse.getter(GetModelCustomizationJobResponse::roleArn)).setter(GetModelCustomizationJobResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetModelCustomizationJobResponse.getter(GetModelCustomizationJobResponse::statusAsString)).setter(GetModelCustomizationJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<TrainingDataConfig> TRAINING_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trainingDataConfig").getter(GetModelCustomizationJobResponse.getter(GetModelCustomizationJobResponse::trainingDataConfig)).setter(GetModelCustomizationJobResponse.setter(Builder::trainingDataConfig)).constructor(TrainingDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataConfig").build()}).build();
    private static final SdkField<TrainingMetrics> TRAINING_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trainingMetrics").getter(GetModelCustomizationJobResponse.getter(GetModelCustomizationJobResponse::trainingMetrics)).setter(GetModelCustomizationJobResponse.setter(Builder::trainingMetrics)).constructor(TrainingMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingMetrics").build()}).build();
    private static final SdkField<ValidationDataConfig> VALIDATION_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("validationDataConfig").getter(GetModelCustomizationJobResponse.getter(GetModelCustomizationJobResponse::validationDataConfig)).setter(GetModelCustomizationJobResponse.setter(Builder::validationDataConfig)).constructor(ValidationDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationDataConfig").build()}).build();
    private static final SdkField<List<ValidatorMetric>> VALIDATION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("validationMetrics").getter(GetModelCustomizationJobResponse.getter(GetModelCustomizationJobResponse::validationMetrics)).setter(GetModelCustomizationJobResponse.setter(Builder::validationMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ValidatorMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcConfig").getter(GetModelCustomizationJobResponse.getter(GetModelCustomizationJobResponse::vpcConfig)).setter(GetModelCustomizationJobResponse.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_MODEL_ARN_FIELD, CLIENT_REQUEST_TOKEN_FIELD, CREATION_TIME_FIELD, END_TIME_FIELD, FAILURE_MESSAGE_FIELD, HYPER_PARAMETERS_FIELD, JOB_ARN_FIELD, JOB_NAME_FIELD, LAST_MODIFIED_TIME_FIELD, OUTPUT_DATA_CONFIG_FIELD, OUTPUT_MODEL_ARN_FIELD, OUTPUT_MODEL_KMS_KEY_ARN_FIELD, OUTPUT_MODEL_NAME_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, TRAINING_DATA_CONFIG_FIELD, TRAINING_METRICS_FIELD, VALIDATION_DATA_CONFIG_FIELD, VALIDATION_METRICS_FIELD, VPC_CONFIG_FIELD));
    private final String baseModelArn;
    private final String clientRequestToken;
    private final Instant creationTime;
    private final Instant endTime;
    private final String failureMessage;
    private final Map<String, String> hyperParameters;
    private final String jobArn;
    private final String jobName;
    private final Instant lastModifiedTime;
    private final OutputDataConfig outputDataConfig;
    private final String outputModelArn;
    private final String outputModelKmsKeyArn;
    private final String outputModelName;
    private final String roleArn;
    private final String status;
    private final TrainingDataConfig trainingDataConfig;
    private final TrainingMetrics trainingMetrics;
    private final ValidationDataConfig validationDataConfig;
    private final List<ValidatorMetric> validationMetrics;
    private final VpcConfig vpcConfig;

    private GetModelCustomizationJobResponse(BuilderImpl builder) {
        super(builder);
        this.baseModelArn = builder.baseModelArn;
        this.clientRequestToken = builder.clientRequestToken;
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
        this.failureMessage = builder.failureMessage;
        this.hyperParameters = builder.hyperParameters;
        this.jobArn = builder.jobArn;
        this.jobName = builder.jobName;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.outputDataConfig = builder.outputDataConfig;
        this.outputModelArn = builder.outputModelArn;
        this.outputModelKmsKeyArn = builder.outputModelKmsKeyArn;
        this.outputModelName = builder.outputModelName;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.trainingDataConfig = builder.trainingDataConfig;
        this.trainingMetrics = builder.trainingMetrics;
        this.validationDataConfig = builder.validationDataConfig;
        this.validationMetrics = builder.validationMetrics;
        this.vpcConfig = builder.vpcConfig;
    }

    public final String baseModelArn() {
        return this.baseModelArn;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public final boolean hasHyperParameters() {
        return this.hyperParameters != null && !(this.hyperParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> hyperParameters() {
        return this.hyperParameters;
    }

    public final String jobArn() {
        return this.jobArn;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final OutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public final String outputModelArn() {
        return this.outputModelArn;
    }

    public final String outputModelKmsKeyArn() {
        return this.outputModelKmsKeyArn;
    }

    public final String outputModelName() {
        return this.outputModelName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final ModelCustomizationJobStatus status() {
        return ModelCustomizationJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final TrainingDataConfig trainingDataConfig() {
        return this.trainingDataConfig;
    }

    public final TrainingMetrics trainingMetrics() {
        return this.trainingMetrics;
    }

    public final ValidationDataConfig validationDataConfig() {
        return this.validationDataConfig;
    }

    public final boolean hasValidationMetrics() {
        return this.validationMetrics != null && !(this.validationMetrics instanceof SdkAutoConstructList);
    }

    public final List<ValidatorMetric> validationMetrics() {
        return this.validationMetrics;
    }

    public final VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.baseModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHyperParameters() ? this.hyperParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputModelKmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidationMetrics() ? this.validationMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetModelCustomizationJobResponse)) {
            return false;
        }
        GetModelCustomizationJobResponse other = (GetModelCustomizationJobResponse)((Object)obj);
        return Objects.equals(this.baseModelArn(), other.baseModelArn()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.failureMessage(), other.failureMessage()) && this.hasHyperParameters() == other.hasHyperParameters() && Objects.equals(this.hyperParameters(), other.hyperParameters()) && Objects.equals(this.jobArn(), other.jobArn()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && Objects.equals(this.outputModelArn(), other.outputModelArn()) && Objects.equals(this.outputModelKmsKeyArn(), other.outputModelKmsKeyArn()) && Objects.equals(this.outputModelName(), other.outputModelName()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.trainingDataConfig(), other.trainingDataConfig()) && Objects.equals(this.trainingMetrics(), other.trainingMetrics()) && Objects.equals(this.validationDataConfig(), other.validationDataConfig()) && this.hasValidationMetrics() == other.hasValidationMetrics() && Objects.equals(this.validationMetrics(), other.validationMetrics()) && Objects.equals(this.vpcConfig(), other.vpcConfig());
    }

    public final String toString() {
        return ToString.builder((String)"GetModelCustomizationJobResponse").add("BaseModelArn", (Object)this.baseModelArn()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("CreationTime", (Object)this.creationTime()).add("EndTime", (Object)this.endTime()).add("FailureMessage", (Object)this.failureMessage()).add("HyperParameters", this.hasHyperParameters() ? this.hyperParameters() : null).add("JobArn", (Object)this.jobArn()).add("JobName", (Object)this.jobName()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("OutputDataConfig", (Object)this.outputDataConfig()).add("OutputModelArn", (Object)this.outputModelArn()).add("OutputModelKmsKeyArn", (Object)this.outputModelKmsKeyArn()).add("OutputModelName", (Object)this.outputModelName()).add("RoleArn", (Object)this.roleArn()).add("Status", (Object)this.statusAsString()).add("TrainingDataConfig", (Object)this.trainingDataConfig()).add("TrainingMetrics", (Object)this.trainingMetrics()).add("ValidationDataConfig", (Object)this.validationDataConfig()).add("ValidationMetrics", this.hasValidationMetrics() ? this.validationMetrics() : null).add("VpcConfig", (Object)this.vpcConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "baseModelArn": {
                return Optional.ofNullable(clazz.cast(this.baseModelArn()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "failureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "hyperParameters": {
                return Optional.ofNullable(clazz.cast(this.hyperParameters()));
            }
            case "jobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "outputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "outputModelArn": {
                return Optional.ofNullable(clazz.cast(this.outputModelArn()));
            }
            case "outputModelKmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.outputModelKmsKeyArn()));
            }
            case "outputModelName": {
                return Optional.ofNullable(clazz.cast(this.outputModelName()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "trainingDataConfig": {
                return Optional.ofNullable(clazz.cast(this.trainingDataConfig()));
            }
            case "trainingMetrics": {
                return Optional.ofNullable(clazz.cast(this.trainingMetrics()));
            }
            case "validationDataConfig": {
                return Optional.ofNullable(clazz.cast(this.validationDataConfig()));
            }
            case "validationMetrics": {
                return Optional.ofNullable(clazz.cast(this.validationMetrics()));
            }
            case "vpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetModelCustomizationJobResponse, T> g) {
        return obj -> g.apply((GetModelCustomizationJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private String baseModelArn;
        private String clientRequestToken;
        private Instant creationTime;
        private Instant endTime;
        private String failureMessage;
        private Map<String, String> hyperParameters = DefaultSdkAutoConstructMap.getInstance();
        private String jobArn;
        private String jobName;
        private Instant lastModifiedTime;
        private OutputDataConfig outputDataConfig;
        private String outputModelArn;
        private String outputModelKmsKeyArn;
        private String outputModelName;
        private String roleArn;
        private String status;
        private TrainingDataConfig trainingDataConfig;
        private TrainingMetrics trainingMetrics;
        private ValidationDataConfig validationDataConfig;
        private List<ValidatorMetric> validationMetrics = DefaultSdkAutoConstructList.getInstance();
        private VpcConfig vpcConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GetModelCustomizationJobResponse model) {
            super(model);
            this.baseModelArn(model.baseModelArn);
            this.clientRequestToken(model.clientRequestToken);
            this.creationTime(model.creationTime);
            this.endTime(model.endTime);
            this.failureMessage(model.failureMessage);
            this.hyperParameters(model.hyperParameters);
            this.jobArn(model.jobArn);
            this.jobName(model.jobName);
            this.lastModifiedTime(model.lastModifiedTime);
            this.outputDataConfig(model.outputDataConfig);
            this.outputModelArn(model.outputModelArn);
            this.outputModelKmsKeyArn(model.outputModelKmsKeyArn);
            this.outputModelName(model.outputModelName);
            this.roleArn(model.roleArn);
            this.status(model.status);
            this.trainingDataConfig(model.trainingDataConfig);
            this.trainingMetrics(model.trainingMetrics);
            this.validationDataConfig(model.validationDataConfig);
            this.validationMetrics(model.validationMetrics);
            this.vpcConfig(model.vpcConfig);
        }

        public final String getBaseModelArn() {
            return this.baseModelArn;
        }

        public final void setBaseModelArn(String baseModelArn) {
            this.baseModelArn = baseModelArn;
        }

        @Override
        public final Builder baseModelArn(String baseModelArn) {
            this.baseModelArn = baseModelArn;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final Map<String, String> getHyperParameters() {
            if (this.hyperParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.hyperParameters;
        }

        public final void setHyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = ModelCustomizationHyperParametersCopier.copy(hyperParameters);
        }

        @Override
        public final Builder hyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = ModelCustomizationHyperParametersCopier.copy(hyperParameters);
            return this;
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final String getOutputModelArn() {
            return this.outputModelArn;
        }

        public final void setOutputModelArn(String outputModelArn) {
            this.outputModelArn = outputModelArn;
        }

        @Override
        public final Builder outputModelArn(String outputModelArn) {
            this.outputModelArn = outputModelArn;
            return this;
        }

        public final String getOutputModelKmsKeyArn() {
            return this.outputModelKmsKeyArn;
        }

        public final void setOutputModelKmsKeyArn(String outputModelKmsKeyArn) {
            this.outputModelKmsKeyArn = outputModelKmsKeyArn;
        }

        @Override
        public final Builder outputModelKmsKeyArn(String outputModelKmsKeyArn) {
            this.outputModelKmsKeyArn = outputModelKmsKeyArn;
            return this;
        }

        public final String getOutputModelName() {
            return this.outputModelName;
        }

        public final void setOutputModelName(String outputModelName) {
            this.outputModelName = outputModelName;
        }

        @Override
        public final Builder outputModelName(String outputModelName) {
            this.outputModelName = outputModelName;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelCustomizationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final TrainingDataConfig.Builder getTrainingDataConfig() {
            return this.trainingDataConfig != null ? this.trainingDataConfig.toBuilder() : null;
        }

        public final void setTrainingDataConfig(TrainingDataConfig.BuilderImpl trainingDataConfig) {
            this.trainingDataConfig = trainingDataConfig != null ? trainingDataConfig.build() : null;
        }

        @Override
        public final Builder trainingDataConfig(TrainingDataConfig trainingDataConfig) {
            this.trainingDataConfig = trainingDataConfig;
            return this;
        }

        public final TrainingMetrics.Builder getTrainingMetrics() {
            return this.trainingMetrics != null ? this.trainingMetrics.toBuilder() : null;
        }

        public final void setTrainingMetrics(TrainingMetrics.BuilderImpl trainingMetrics) {
            this.trainingMetrics = trainingMetrics != null ? trainingMetrics.build() : null;
        }

        @Override
        public final Builder trainingMetrics(TrainingMetrics trainingMetrics) {
            this.trainingMetrics = trainingMetrics;
            return this;
        }

        public final ValidationDataConfig.Builder getValidationDataConfig() {
            return this.validationDataConfig != null ? this.validationDataConfig.toBuilder() : null;
        }

        public final void setValidationDataConfig(ValidationDataConfig.BuilderImpl validationDataConfig) {
            this.validationDataConfig = validationDataConfig != null ? validationDataConfig.build() : null;
        }

        @Override
        public final Builder validationDataConfig(ValidationDataConfig validationDataConfig) {
            this.validationDataConfig = validationDataConfig;
            return this;
        }

        public final List<ValidatorMetric.Builder> getValidationMetrics() {
            List<ValidatorMetric.Builder> result = ValidationMetricsCopier.copyToBuilder(this.validationMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidationMetrics(Collection<ValidatorMetric.BuilderImpl> validationMetrics) {
            this.validationMetrics = ValidationMetricsCopier.copyFromBuilder(validationMetrics);
        }

        @Override
        public final Builder validationMetrics(Collection<ValidatorMetric> validationMetrics) {
            this.validationMetrics = ValidationMetricsCopier.copy(validationMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationMetrics(ValidatorMetric ... validationMetrics) {
            this.validationMetrics(Arrays.asList(validationMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationMetrics(Consumer<ValidatorMetric.Builder> ... validationMetrics) {
            this.validationMetrics(Stream.of(validationMetrics).map(c -> (ValidatorMetric)((ValidatorMetric.Builder)ValidatorMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        @Override
        public GetModelCustomizationJobResponse build() {
            return new GetModelCustomizationJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetModelCustomizationJobResponse> {
        public Builder baseModelArn(String var1);

        public Builder clientRequestToken(String var1);

        public Builder creationTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder failureMessage(String var1);

        public Builder hyperParameters(Map<String, String> var1);

        public Builder jobArn(String var1);

        public Builder jobName(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder outputDataConfig(OutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((OutputDataConfig)((OutputDataConfig.Builder)OutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder outputModelArn(String var1);

        public Builder outputModelKmsKeyArn(String var1);

        public Builder outputModelName(String var1);

        public Builder roleArn(String var1);

        public Builder status(String var1);

        public Builder status(ModelCustomizationJobStatus var1);

        public Builder trainingDataConfig(TrainingDataConfig var1);

        default public Builder trainingDataConfig(Consumer<TrainingDataConfig.Builder> trainingDataConfig) {
            return this.trainingDataConfig((TrainingDataConfig)((TrainingDataConfig.Builder)TrainingDataConfig.builder().applyMutation(trainingDataConfig)).build());
        }

        public Builder trainingMetrics(TrainingMetrics var1);

        default public Builder trainingMetrics(Consumer<TrainingMetrics.Builder> trainingMetrics) {
            return this.trainingMetrics((TrainingMetrics)((TrainingMetrics.Builder)TrainingMetrics.builder().applyMutation(trainingMetrics)).build());
        }

        public Builder validationDataConfig(ValidationDataConfig var1);

        default public Builder validationDataConfig(Consumer<ValidationDataConfig.Builder> validationDataConfig) {
            return this.validationDataConfig((ValidationDataConfig)((ValidationDataConfig.Builder)ValidationDataConfig.builder().applyMutation(validationDataConfig)).build());
        }

        public Builder validationMetrics(Collection<ValidatorMetric> var1);

        public Builder validationMetrics(ValidatorMetric ... var1);

        public Builder validationMetrics(Consumer<ValidatorMetric.Builder> ... var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }
    }
}

