/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.S3Config;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudWatchConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudWatchConfig> {
    private static final SdkField<S3Config> LARGE_DATA_DELIVERY_S3_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("largeDataDeliveryS3Config").getter(CloudWatchConfig.getter(CloudWatchConfig::largeDataDeliveryS3Config)).setter(CloudWatchConfig.setter(Builder::largeDataDeliveryS3Config)).constructor(S3Config::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("largeDataDeliveryS3Config").build()}).build();
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupName").getter(CloudWatchConfig.getter(CloudWatchConfig::logGroupName)).setter(CloudWatchConfig.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CloudWatchConfig.getter(CloudWatchConfig::roleArn)).setter(CloudWatchConfig.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LARGE_DATA_DELIVERY_S3_CONFIG_FIELD, LOG_GROUP_NAME_FIELD, ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final S3Config largeDataDeliveryS3Config;
    private final String logGroupName;
    private final String roleArn;

    private CloudWatchConfig(BuilderImpl builder) {
        this.largeDataDeliveryS3Config = builder.largeDataDeliveryS3Config;
        this.logGroupName = builder.logGroupName;
        this.roleArn = builder.roleArn;
    }

    public final S3Config largeDataDeliveryS3Config() {
        return this.largeDataDeliveryS3Config;
    }

    public final String logGroupName() {
        return this.logGroupName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.largeDataDeliveryS3Config());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchConfig)) {
            return false;
        }
        CloudWatchConfig other = (CloudWatchConfig)obj;
        return Objects.equals(this.largeDataDeliveryS3Config(), other.largeDataDeliveryS3Config()) && Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"CloudWatchConfig").add("LargeDataDeliveryS3Config", (Object)this.largeDataDeliveryS3Config()).add("LogGroupName", (Object)this.logGroupName()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "largeDataDeliveryS3Config": {
                return Optional.ofNullable(clazz.cast(this.largeDataDeliveryS3Config()));
            }
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchConfig, T> g) {
        return obj -> g.apply((CloudWatchConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3Config largeDataDeliveryS3Config;
        private String logGroupName;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchConfig model) {
            this.largeDataDeliveryS3Config(model.largeDataDeliveryS3Config);
            this.logGroupName(model.logGroupName);
            this.roleArn(model.roleArn);
        }

        public final S3Config.Builder getLargeDataDeliveryS3Config() {
            return this.largeDataDeliveryS3Config != null ? this.largeDataDeliveryS3Config.toBuilder() : null;
        }

        public final void setLargeDataDeliveryS3Config(S3Config.BuilderImpl largeDataDeliveryS3Config) {
            this.largeDataDeliveryS3Config = largeDataDeliveryS3Config != null ? largeDataDeliveryS3Config.build() : null;
        }

        @Override
        public final Builder largeDataDeliveryS3Config(S3Config largeDataDeliveryS3Config) {
            this.largeDataDeliveryS3Config = largeDataDeliveryS3Config;
            return this;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public CloudWatchConfig build() {
            return new CloudWatchConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudWatchConfig> {
        public Builder largeDataDeliveryS3Config(S3Config var1);

        default public Builder largeDataDeliveryS3Config(Consumer<S3Config.Builder> largeDataDeliveryS3Config) {
            return this.largeDataDeliveryS3Config((S3Config)((S3Config.Builder)S3Config.builder().applyMutation(largeDataDeliveryS3Config)).build());
        }

        public Builder logGroupName(String var1);

        public Builder roleArn(String var1);
    }
}

