/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BcmPricingCalculatorResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BillInterval;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BillScenarioStatus;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GroupSharingPreferenceEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBillScenarioResponse
extends BcmPricingCalculatorResponse
implements ToCopyableBuilder<Builder, GetBillScenarioResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetBillScenarioResponse.getter(GetBillScenarioResponse::id)).setter(GetBillScenarioResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetBillScenarioResponse.getter(GetBillScenarioResponse::name)).setter(GetBillScenarioResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<BillInterval> BILL_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("billInterval").getter(GetBillScenarioResponse.getter(GetBillScenarioResponse::billInterval)).setter(GetBillScenarioResponse.setter(Builder::billInterval)).constructor(BillInterval::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billInterval").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetBillScenarioResponse.getter(GetBillScenarioResponse::statusAsString)).setter(GetBillScenarioResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetBillScenarioResponse.getter(GetBillScenarioResponse::createdAt)).setter(GetBillScenarioResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expiresAt").getter(GetBillScenarioResponse.getter(GetBillScenarioResponse::expiresAt)).setter(GetBillScenarioResponse.setter(Builder::expiresAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresAt").build()}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureMessage").getter(GetBillScenarioResponse.getter(GetBillScenarioResponse::failureMessage)).setter(GetBillScenarioResponse.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()}).build();
    private static final SdkField<String> GROUP_SHARING_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupSharingPreference").getter(GetBillScenarioResponse.getter(GetBillScenarioResponse::groupSharingPreferenceAsString)).setter(GetBillScenarioResponse.setter(Builder::groupSharingPreference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupSharingPreference").build()}).build();
    private static final SdkField<String> COST_CATEGORY_GROUP_SHARING_PREFERENCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("costCategoryGroupSharingPreferenceArn").getter(GetBillScenarioResponse.getter(GetBillScenarioResponse::costCategoryGroupSharingPreferenceArn)).setter(GetBillScenarioResponse.setter(Builder::costCategoryGroupSharingPreferenceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("costCategoryGroupSharingPreferenceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, BILL_INTERVAL_FIELD, STATUS_FIELD, CREATED_AT_FIELD, EXPIRES_AT_FIELD, FAILURE_MESSAGE_FIELD, GROUP_SHARING_PREFERENCE_FIELD, COST_CATEGORY_GROUP_SHARING_PREFERENCE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetBillScenarioResponse.memberNameToFieldInitializer();
    private final String id;
    private final String name;
    private final BillInterval billInterval;
    private final String status;
    private final Instant createdAt;
    private final Instant expiresAt;
    private final String failureMessage;
    private final String groupSharingPreference;
    private final String costCategoryGroupSharingPreferenceArn;

    private GetBillScenarioResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.billInterval = builder.billInterval;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.expiresAt = builder.expiresAt;
        this.failureMessage = builder.failureMessage;
        this.groupSharingPreference = builder.groupSharingPreference;
        this.costCategoryGroupSharingPreferenceArn = builder.costCategoryGroupSharingPreferenceArn;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final BillInterval billInterval() {
        return this.billInterval;
    }

    public final BillScenarioStatus status() {
        return BillScenarioStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant expiresAt() {
        return this.expiresAt;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public final GroupSharingPreferenceEnum groupSharingPreference() {
        return GroupSharingPreferenceEnum.fromValue(this.groupSharingPreference);
    }

    public final String groupSharingPreferenceAsString() {
        return this.groupSharingPreference;
    }

    public final String costCategoryGroupSharingPreferenceArn() {
        return this.costCategoryGroupSharingPreferenceArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.billInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupSharingPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.costCategoryGroupSharingPreferenceArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBillScenarioResponse)) {
            return false;
        }
        GetBillScenarioResponse other = (GetBillScenarioResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.billInterval(), other.billInterval()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.expiresAt(), other.expiresAt()) && Objects.equals(this.failureMessage(), other.failureMessage()) && Objects.equals(this.groupSharingPreferenceAsString(), other.groupSharingPreferenceAsString()) && Objects.equals(this.costCategoryGroupSharingPreferenceArn(), other.costCategoryGroupSharingPreferenceArn());
    }

    public final String toString() {
        return ToString.builder((String)"GetBillScenarioResponse").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("BillInterval", (Object)this.billInterval()).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("ExpiresAt", (Object)this.expiresAt()).add("FailureMessage", (Object)this.failureMessage()).add("GroupSharingPreference", (Object)this.groupSharingPreferenceAsString()).add("CostCategoryGroupSharingPreferenceArn", (Object)this.costCategoryGroupSharingPreferenceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "billInterval": {
                return Optional.ofNullable(clazz.cast(this.billInterval()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "expiresAt": {
                return Optional.ofNullable(clazz.cast(this.expiresAt()));
            }
            case "failureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "groupSharingPreference": {
                return Optional.ofNullable(clazz.cast(this.groupSharingPreferenceAsString()));
            }
            case "costCategoryGroupSharingPreferenceArn": {
                return Optional.ofNullable(clazz.cast(this.costCategoryGroupSharingPreferenceArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("billInterval", BILL_INTERVAL_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("expiresAt", EXPIRES_AT_FIELD);
        map.put("failureMessage", FAILURE_MESSAGE_FIELD);
        map.put("groupSharingPreference", GROUP_SHARING_PREFERENCE_FIELD);
        map.put("costCategoryGroupSharingPreferenceArn", COST_CATEGORY_GROUP_SHARING_PREFERENCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBillScenarioResponse, T> g) {
        return obj -> g.apply((GetBillScenarioResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BcmPricingCalculatorResponse.BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private BillInterval billInterval;
        private String status;
        private Instant createdAt;
        private Instant expiresAt;
        private String failureMessage;
        private String groupSharingPreference;
        private String costCategoryGroupSharingPreferenceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBillScenarioResponse model) {
            super(model);
            this.id(model.id);
            this.name(model.name);
            this.billInterval(model.billInterval);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.expiresAt(model.expiresAt);
            this.failureMessage(model.failureMessage);
            this.groupSharingPreference(model.groupSharingPreference);
            this.costCategoryGroupSharingPreferenceArn(model.costCategoryGroupSharingPreferenceArn);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final BillInterval.Builder getBillInterval() {
            return this.billInterval != null ? this.billInterval.toBuilder() : null;
        }

        public final void setBillInterval(BillInterval.BuilderImpl billInterval) {
            this.billInterval = billInterval != null ? billInterval.build() : null;
        }

        @Override
        public final Builder billInterval(BillInterval billInterval) {
            this.billInterval = billInterval;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BillScenarioStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getExpiresAt() {
            return this.expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final String getGroupSharingPreference() {
            return this.groupSharingPreference;
        }

        public final void setGroupSharingPreference(String groupSharingPreference) {
            this.groupSharingPreference = groupSharingPreference;
        }

        @Override
        public final Builder groupSharingPreference(String groupSharingPreference) {
            this.groupSharingPreference = groupSharingPreference;
            return this;
        }

        @Override
        public final Builder groupSharingPreference(GroupSharingPreferenceEnum groupSharingPreference) {
            this.groupSharingPreference(groupSharingPreference == null ? null : groupSharingPreference.toString());
            return this;
        }

        public final String getCostCategoryGroupSharingPreferenceArn() {
            return this.costCategoryGroupSharingPreferenceArn;
        }

        public final void setCostCategoryGroupSharingPreferenceArn(String costCategoryGroupSharingPreferenceArn) {
            this.costCategoryGroupSharingPreferenceArn = costCategoryGroupSharingPreferenceArn;
        }

        @Override
        public final Builder costCategoryGroupSharingPreferenceArn(String costCategoryGroupSharingPreferenceArn) {
            this.costCategoryGroupSharingPreferenceArn = costCategoryGroupSharingPreferenceArn;
            return this;
        }

        @Override
        public GetBillScenarioResponse build() {
            return new GetBillScenarioResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BcmPricingCalculatorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBillScenarioResponse> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder billInterval(BillInterval var1);

        default public Builder billInterval(Consumer<BillInterval.Builder> billInterval) {
            return this.billInterval((BillInterval)((BillInterval.Builder)BillInterval.builder().applyMutation(billInterval)).build());
        }

        public Builder status(String var1);

        public Builder status(BillScenarioStatus var1);

        public Builder createdAt(Instant var1);

        public Builder expiresAt(Instant var1);

        public Builder failureMessage(String var1);

        public Builder groupSharingPreference(String var1);

        public Builder groupSharingPreference(GroupSharingPreferenceEnum var1);

        public Builder costCategoryGroupSharingPreferenceArn(String var1);
    }
}

