/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBillScenarioRequest extends BcmPricingCalculatorRequest implements
        ToCopyableBuilder<UpdateBillScenarioRequest.Builder, UpdateBillScenarioRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(UpdateBillScenarioRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateBillScenarioRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("expiresAt").getter(getter(UpdateBillScenarioRequest::expiresAt)).setter(setter(Builder::expiresAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresAt").build()).build();

    private static final SdkField<String> GROUP_SHARING_PREFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupSharingPreference").getter(getter(UpdateBillScenarioRequest::groupSharingPreferenceAsString))
            .setter(setter(Builder::groupSharingPreference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupSharingPreference").build())
            .build();

    private static final SdkField<String> COST_CATEGORY_GROUP_SHARING_PREFERENCE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("costCategoryGroupSharingPreferenceArn")
            .getter(getter(UpdateBillScenarioRequest::costCategoryGroupSharingPreferenceArn))
            .setter(setter(Builder::costCategoryGroupSharingPreferenceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("costCategoryGroupSharingPreferenceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, NAME_FIELD,
            EXPIRES_AT_FIELD, GROUP_SHARING_PREFERENCE_FIELD, COST_CATEGORY_GROUP_SHARING_PREFERENCE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identifier;

    private final String name;

    private final Instant expiresAt;

    private final String groupSharingPreference;

    private final String costCategoryGroupSharingPreferenceArn;

    private UpdateBillScenarioRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.name = builder.name;
        this.expiresAt = builder.expiresAt;
        this.groupSharingPreference = builder.groupSharingPreference;
        this.costCategoryGroupSharingPreferenceArn = builder.costCategoryGroupSharingPreferenceArn;
    }

    /**
     * <p>
     * The unique identifier of the bill scenario to update.
     * </p>
     * 
     * @return The unique identifier of the bill scenario to update.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The new name for the bill scenario.
     * </p>
     * 
     * @return The new name for the bill scenario.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The new expiration date for the bill scenario.
     * </p>
     * 
     * @return The new expiration date for the bill scenario.
     */
    public final Instant expiresAt() {
        return expiresAt;
    }

    /**
     * <p>
     * The setting for the reserved instance and savings plan group sharing used in this estimate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #groupSharingPreference} will return {@link GroupSharingPreferenceEnum#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #groupSharingPreferenceAsString}.
     * </p>
     * 
     * @return The setting for the reserved instance and savings plan group sharing used in this estimate.
     * @see GroupSharingPreferenceEnum
     */
    public final GroupSharingPreferenceEnum groupSharingPreference() {
        return GroupSharingPreferenceEnum.fromValue(groupSharingPreference);
    }

    /**
     * <p>
     * The setting for the reserved instance and savings plan group sharing used in this estimate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #groupSharingPreference} will return {@link GroupSharingPreferenceEnum#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #groupSharingPreferenceAsString}.
     * </p>
     * 
     * @return The setting for the reserved instance and savings plan group sharing used in this estimate.
     * @see GroupSharingPreferenceEnum
     */
    public final String groupSharingPreferenceAsString() {
        return groupSharingPreference;
    }

    /**
     * <p>
     * The arn of the cost category used in the reserved and prioritized group sharing.
     * </p>
     * 
     * @return The arn of the cost category used in the reserved and prioritized group sharing.
     */
    public final String costCategoryGroupSharingPreferenceArn() {
        return costCategoryGroupSharingPreferenceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(expiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(groupSharingPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(costCategoryGroupSharingPreferenceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBillScenarioRequest)) {
            return false;
        }
        UpdateBillScenarioRequest other = (UpdateBillScenarioRequest) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(name(), other.name())
                && Objects.equals(expiresAt(), other.expiresAt())
                && Objects.equals(groupSharingPreferenceAsString(), other.groupSharingPreferenceAsString())
                && Objects.equals(costCategoryGroupSharingPreferenceArn(), other.costCategoryGroupSharingPreferenceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBillScenarioRequest").add("Identifier", identifier()).add("Name", name())
                .add("ExpiresAt", expiresAt()).add("GroupSharingPreference", groupSharingPreferenceAsString())
                .add("CostCategoryGroupSharingPreferenceArn", costCategoryGroupSharingPreferenceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "expiresAt":
            return Optional.ofNullable(clazz.cast(expiresAt()));
        case "groupSharingPreference":
            return Optional.ofNullable(clazz.cast(groupSharingPreferenceAsString()));
        case "costCategoryGroupSharingPreferenceArn":
            return Optional.ofNullable(clazz.cast(costCategoryGroupSharingPreferenceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("expiresAt", EXPIRES_AT_FIELD);
        map.put("groupSharingPreference", GROUP_SHARING_PREFERENCE_FIELD);
        map.put("costCategoryGroupSharingPreferenceArn", COST_CATEGORY_GROUP_SHARING_PREFERENCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBillScenarioRequest, T> g) {
        return obj -> g.apply((UpdateBillScenarioRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BcmPricingCalculatorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateBillScenarioRequest> {
        /**
         * <p>
         * The unique identifier of the bill scenario to update.
         * </p>
         * 
         * @param identifier
         *        The unique identifier of the bill scenario to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The new name for the bill scenario.
         * </p>
         * 
         * @param name
         *        The new name for the bill scenario.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The new expiration date for the bill scenario.
         * </p>
         * 
         * @param expiresAt
         *        The new expiration date for the bill scenario.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresAt(Instant expiresAt);

        /**
         * <p>
         * The setting for the reserved instance and savings plan group sharing used in this estimate.
         * </p>
         * 
         * @param groupSharingPreference
         *        The setting for the reserved instance and savings plan group sharing used in this estimate.
         * @see GroupSharingPreferenceEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupSharingPreferenceEnum
         */
        Builder groupSharingPreference(String groupSharingPreference);

        /**
         * <p>
         * The setting for the reserved instance and savings plan group sharing used in this estimate.
         * </p>
         * 
         * @param groupSharingPreference
         *        The setting for the reserved instance and savings plan group sharing used in this estimate.
         * @see GroupSharingPreferenceEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupSharingPreferenceEnum
         */
        Builder groupSharingPreference(GroupSharingPreferenceEnum groupSharingPreference);

        /**
         * <p>
         * The arn of the cost category used in the reserved and prioritized group sharing.
         * </p>
         * 
         * @param costCategoryGroupSharingPreferenceArn
         *        The arn of the cost category used in the reserved and prioritized group sharing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costCategoryGroupSharingPreferenceArn(String costCategoryGroupSharingPreferenceArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BcmPricingCalculatorRequest.BuilderImpl implements Builder {
        private String identifier;

        private String name;

        private Instant expiresAt;

        private String groupSharingPreference;

        private String costCategoryGroupSharingPreferenceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBillScenarioRequest model) {
            super(model);
            identifier(model.identifier);
            name(model.name);
            expiresAt(model.expiresAt);
            groupSharingPreference(model.groupSharingPreference);
            costCategoryGroupSharingPreferenceArn(model.costCategoryGroupSharingPreferenceArn);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getExpiresAt() {
            return expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public final String getGroupSharingPreference() {
            return groupSharingPreference;
        }

        public final void setGroupSharingPreference(String groupSharingPreference) {
            this.groupSharingPreference = groupSharingPreference;
        }

        @Override
        public final Builder groupSharingPreference(String groupSharingPreference) {
            this.groupSharingPreference = groupSharingPreference;
            return this;
        }

        @Override
        public final Builder groupSharingPreference(GroupSharingPreferenceEnum groupSharingPreference) {
            this.groupSharingPreference(groupSharingPreference == null ? null : groupSharingPreference.toString());
            return this;
        }

        public final String getCostCategoryGroupSharingPreferenceArn() {
            return costCategoryGroupSharingPreferenceArn;
        }

        public final void setCostCategoryGroupSharingPreferenceArn(String costCategoryGroupSharingPreferenceArn) {
            this.costCategoryGroupSharingPreferenceArn = costCategoryGroupSharingPreferenceArn;
        }

        @Override
        public final Builder costCategoryGroupSharingPreferenceArn(String costCategoryGroupSharingPreferenceArn) {
            this.costCategoryGroupSharingPreferenceArn = costCategoryGroupSharingPreferenceArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBillScenarioRequest build() {
            return new UpdateBillScenarioRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
