/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the difference between historical and estimated costs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CostDifference implements SdkPojo, Serializable, ToCopyableBuilder<CostDifference.Builder, CostDifference> {
    private static final SdkField<CostAmount> HISTORICAL_COST_FIELD = SdkField.<CostAmount> builder(MarshallingType.SDK_POJO)
            .memberName("historicalCost").getter(getter(CostDifference::historicalCost)).setter(setter(Builder::historicalCost))
            .constructor(CostAmount::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("historicalCost").build()).build();

    private static final SdkField<CostAmount> ESTIMATED_COST_FIELD = SdkField.<CostAmount> builder(MarshallingType.SDK_POJO)
            .memberName("estimatedCost").getter(getter(CostDifference::estimatedCost)).setter(setter(Builder::estimatedCost))
            .constructor(CostAmount::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedCost").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HISTORICAL_COST_FIELD,
            ESTIMATED_COST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CostAmount historicalCost;

    private final CostAmount estimatedCost;

    private CostDifference(BuilderImpl builder) {
        this.historicalCost = builder.historicalCost;
        this.estimatedCost = builder.estimatedCost;
    }

    /**
     * <p>
     * The historical cost amount.
     * </p>
     * 
     * @return The historical cost amount.
     */
    public final CostAmount historicalCost() {
        return historicalCost;
    }

    /**
     * <p>
     * The estimated cost amount.
     * </p>
     * 
     * @return The estimated cost amount.
     */
    public final CostAmount estimatedCost() {
        return estimatedCost;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(historicalCost());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedCost());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostDifference)) {
            return false;
        }
        CostDifference other = (CostDifference) obj;
        return Objects.equals(historicalCost(), other.historicalCost()) && Objects.equals(estimatedCost(), other.estimatedCost());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CostDifference").add("HistoricalCost", historicalCost()).add("EstimatedCost", estimatedCost())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "historicalCost":
            return Optional.ofNullable(clazz.cast(historicalCost()));
        case "estimatedCost":
            return Optional.ofNullable(clazz.cast(estimatedCost()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("historicalCost", HISTORICAL_COST_FIELD);
        map.put("estimatedCost", ESTIMATED_COST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CostDifference, T> g) {
        return obj -> g.apply((CostDifference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CostDifference> {
        /**
         * <p>
         * The historical cost amount.
         * </p>
         * 
         * @param historicalCost
         *        The historical cost amount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder historicalCost(CostAmount historicalCost);

        /**
         * <p>
         * The historical cost amount.
         * </p>
         * This is a convenience method that creates an instance of the {@link CostAmount.Builder} avoiding the need to
         * create one manually via {@link CostAmount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CostAmount.Builder#build()} is called immediately and its result
         * is passed to {@link #historicalCost(CostAmount)}.
         * 
         * @param historicalCost
         *        a consumer that will call methods on {@link CostAmount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #historicalCost(CostAmount)
         */
        default Builder historicalCost(Consumer<CostAmount.Builder> historicalCost) {
            return historicalCost(CostAmount.builder().applyMutation(historicalCost).build());
        }

        /**
         * <p>
         * The estimated cost amount.
         * </p>
         * 
         * @param estimatedCost
         *        The estimated cost amount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedCost(CostAmount estimatedCost);

        /**
         * <p>
         * The estimated cost amount.
         * </p>
         * This is a convenience method that creates an instance of the {@link CostAmount.Builder} avoiding the need to
         * create one manually via {@link CostAmount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CostAmount.Builder#build()} is called immediately and its result
         * is passed to {@link #estimatedCost(CostAmount)}.
         * 
         * @param estimatedCost
         *        a consumer that will call methods on {@link CostAmount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #estimatedCost(CostAmount)
         */
        default Builder estimatedCost(Consumer<CostAmount.Builder> estimatedCost) {
            return estimatedCost(CostAmount.builder().applyMutation(estimatedCost).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CostAmount historicalCost;

        private CostAmount estimatedCost;

        private BuilderImpl() {
        }

        private BuilderImpl(CostDifference model) {
            historicalCost(model.historicalCost);
            estimatedCost(model.estimatedCost);
        }

        public final CostAmount.Builder getHistoricalCost() {
            return historicalCost != null ? historicalCost.toBuilder() : null;
        }

        public final void setHistoricalCost(CostAmount.BuilderImpl historicalCost) {
            this.historicalCost = historicalCost != null ? historicalCost.build() : null;
        }

        @Override
        public final Builder historicalCost(CostAmount historicalCost) {
            this.historicalCost = historicalCost;
            return this;
        }

        public final CostAmount.Builder getEstimatedCost() {
            return estimatedCost != null ? estimatedCost.toBuilder() : null;
        }

        public final void setEstimatedCost(CostAmount.BuilderImpl estimatedCost) {
            this.estimatedCost = estimatedCost != null ? estimatedCost.build() : null;
        }

        @Override
        public final Builder estimatedCost(CostAmount estimatedCost) {
            this.estimatedCost = estimatedCost;
            return this;
        }

        @Override
        public CostDifference build() {
            return new CostDifference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
