/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteWorkloadEstimateUsageRequest extends BcmPricingCalculatorRequest implements
        ToCopyableBuilder<BatchDeleteWorkloadEstimateUsageRequest.Builder, BatchDeleteWorkloadEstimateUsageRequest> {
    private static final SdkField<String> WORKLOAD_ESTIMATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workloadEstimateId").getter(getter(BatchDeleteWorkloadEstimateUsageRequest::workloadEstimateId))
            .setter(setter(Builder::workloadEstimateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadEstimateId").build())
            .build();

    private static final SdkField<List<String>> IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ids")
            .getter(getter(BatchDeleteWorkloadEstimateUsageRequest::ids))
            .setter(setter(Builder::ids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ids").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ESTIMATE_ID_FIELD,
            IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workloadEstimateId;

    private final List<String> ids;

    private BatchDeleteWorkloadEstimateUsageRequest(BuilderImpl builder) {
        super(builder);
        this.workloadEstimateId = builder.workloadEstimateId;
        this.ids = builder.ids;
    }

    /**
     * <p>
     * The ID of the Workload estimate for which you want to delete the modeled usage.
     * </p>
     * 
     * @return The ID of the Workload estimate for which you want to delete the modeled usage.
     */
    public final String workloadEstimateId() {
        return workloadEstimateId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ids property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasIds() {
        return ids != null && !(ids instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of usage that you want to delete from the Workload estimate.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIds} method.
     * </p>
     * 
     * @return List of usage that you want to delete from the Workload estimate.
     */
    public final List<String> ids() {
        return ids;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workloadEstimateId());
        hashCode = 31 * hashCode + Objects.hashCode(hasIds() ? ids() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteWorkloadEstimateUsageRequest)) {
            return false;
        }
        BatchDeleteWorkloadEstimateUsageRequest other = (BatchDeleteWorkloadEstimateUsageRequest) obj;
        return Objects.equals(workloadEstimateId(), other.workloadEstimateId()) && hasIds() == other.hasIds()
                && Objects.equals(ids(), other.ids());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteWorkloadEstimateUsageRequest").add("WorkloadEstimateId", workloadEstimateId())
                .add("Ids", hasIds() ? ids() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workloadEstimateId":
            return Optional.ofNullable(clazz.cast(workloadEstimateId()));
        case "ids":
            return Optional.ofNullable(clazz.cast(ids()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("workloadEstimateId", WORKLOAD_ESTIMATE_ID_FIELD);
        map.put("ids", IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteWorkloadEstimateUsageRequest, T> g) {
        return obj -> g.apply((BatchDeleteWorkloadEstimateUsageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BcmPricingCalculatorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchDeleteWorkloadEstimateUsageRequest> {
        /**
         * <p>
         * The ID of the Workload estimate for which you want to delete the modeled usage.
         * </p>
         * 
         * @param workloadEstimateId
         *        The ID of the Workload estimate for which you want to delete the modeled usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadEstimateId(String workloadEstimateId);

        /**
         * <p>
         * List of usage that you want to delete from the Workload estimate.
         * </p>
         * 
         * @param ids
         *        List of usage that you want to delete from the Workload estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ids(Collection<String> ids);

        /**
         * <p>
         * List of usage that you want to delete from the Workload estimate.
         * </p>
         * 
         * @param ids
         *        List of usage that you want to delete from the Workload estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ids(String... ids);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BcmPricingCalculatorRequest.BuilderImpl implements Builder {
        private String workloadEstimateId;

        private List<String> ids = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteWorkloadEstimateUsageRequest model) {
            super(model);
            workloadEstimateId(model.workloadEstimateId);
            ids(model.ids);
        }

        public final String getWorkloadEstimateId() {
            return workloadEstimateId;
        }

        public final void setWorkloadEstimateId(String workloadEstimateId) {
            this.workloadEstimateId = workloadEstimateId;
        }

        @Override
        public final Builder workloadEstimateId(String workloadEstimateId) {
            this.workloadEstimateId = workloadEstimateId;
            return this;
        }

        public final Collection<String> getIds() {
            if (ids instanceof SdkAutoConstructList) {
                return null;
            }
            return ids;
        }

        public final void setIds(Collection<String> ids) {
            this.ids = BatchDeleteWorkloadEstimateUsageEntriesCopier.copy(ids);
        }

        @Override
        public final Builder ids(Collection<String> ids) {
            this.ids = BatchDeleteWorkloadEstimateUsageEntriesCopier.copy(ids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ids(String... ids) {
            ids(Arrays.asList(ids));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteWorkloadEstimateUsageRequest build() {
            return new BatchDeleteWorkloadEstimateUsageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
