/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an entry in a batch operation to create workload estimate usage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCreateWorkloadEstimateUsageEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchCreateWorkloadEstimateUsageEntry.Builder, BatchCreateWorkloadEstimateUsageEntry> {
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceCode").getter(getter(BatchCreateWorkloadEstimateUsageEntry::serviceCode))
            .setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCode").build()).build();

    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageType").getter(getter(BatchCreateWorkloadEstimateUsageEntry::usageType))
            .setter(setter(Builder::usageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageType").build()).build();

    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operation").getter(getter(BatchCreateWorkloadEstimateUsageEntry::operation))
            .setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(BatchCreateWorkloadEstimateUsageEntry::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<String> GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("group")
            .getter(getter(BatchCreateWorkloadEstimateUsageEntry::group)).setter(setter(Builder::group))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()).build();

    private static final SdkField<String> USAGE_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageAccountId").getter(getter(BatchCreateWorkloadEstimateUsageEntry::usageAccountId))
            .setter(setter(Builder::usageAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageAccountId").build()).build();

    private static final SdkField<Double> AMOUNT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("amount")
            .getter(getter(BatchCreateWorkloadEstimateUsageEntry::amount)).setter(setter(Builder::amount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amount").build()).build();

    private static final SdkField<HistoricalUsageEntity> HISTORICAL_USAGE_FIELD = SdkField
            .<HistoricalUsageEntity> builder(MarshallingType.SDK_POJO).memberName("historicalUsage")
            .getter(getter(BatchCreateWorkloadEstimateUsageEntry::historicalUsage)).setter(setter(Builder::historicalUsage))
            .constructor(HistoricalUsageEntity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("historicalUsage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_FIELD,
            USAGE_TYPE_FIELD, OPERATION_FIELD, KEY_FIELD, GROUP_FIELD, USAGE_ACCOUNT_ID_FIELD, AMOUNT_FIELD,
            HISTORICAL_USAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String serviceCode;

    private final String usageType;

    private final String operation;

    private final String key;

    private final String group;

    private final String usageAccountId;

    private final Double amount;

    private final HistoricalUsageEntity historicalUsage;

    private BatchCreateWorkloadEstimateUsageEntry(BuilderImpl builder) {
        this.serviceCode = builder.serviceCode;
        this.usageType = builder.usageType;
        this.operation = builder.operation;
        this.key = builder.key;
        this.group = builder.group;
        this.usageAccountId = builder.usageAccountId;
        this.amount = builder.amount;
        this.historicalUsage = builder.historicalUsage;
    }

    /**
     * <p>
     * The Amazon Web Services service code for this usage estimate.
     * </p>
     * 
     * @return The Amazon Web Services service code for this usage estimate.
     */
    public final String serviceCode() {
        return serviceCode;
    }

    /**
     * <p>
     * The type of usage being estimated.
     * </p>
     * 
     * @return The type of usage being estimated.
     */
    public final String usageType() {
        return usageType;
    }

    /**
     * <p>
     * The specific operation associated with this usage estimate.
     * </p>
     * 
     * @return The specific operation associated with this usage estimate.
     */
    public final String operation() {
        return operation;
    }

    /**
     * <p>
     * A unique identifier for this entry in the batch operation.
     * </p>
     * 
     * @return A unique identifier for this entry in the batch operation.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * An optional group identifier for the usage estimate.
     * </p>
     * 
     * @return An optional group identifier for the usage estimate.
     */
    public final String group() {
        return group;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with this usage estimate.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with this usage estimate.
     */
    public final String usageAccountId() {
        return usageAccountId;
    }

    /**
     * <p>
     * The estimated usage amount.
     * </p>
     * 
     * @return The estimated usage amount.
     */
    public final Double amount() {
        return amount;
    }

    /**
     * <p>
     * Historical usage data associated with this estimate, if available.
     * </p>
     * 
     * @return Historical usage data associated with this estimate, if available.
     */
    public final HistoricalUsageEntity historicalUsage() {
        return historicalUsage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(usageType());
        hashCode = 31 * hashCode + Objects.hashCode(operation());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(group());
        hashCode = 31 * hashCode + Objects.hashCode(usageAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(amount());
        hashCode = 31 * hashCode + Objects.hashCode(historicalUsage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateWorkloadEstimateUsageEntry)) {
            return false;
        }
        BatchCreateWorkloadEstimateUsageEntry other = (BatchCreateWorkloadEstimateUsageEntry) obj;
        return Objects.equals(serviceCode(), other.serviceCode()) && Objects.equals(usageType(), other.usageType())
                && Objects.equals(operation(), other.operation()) && Objects.equals(key(), other.key())
                && Objects.equals(group(), other.group()) && Objects.equals(usageAccountId(), other.usageAccountId())
                && Objects.equals(amount(), other.amount()) && Objects.equals(historicalUsage(), other.historicalUsage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchCreateWorkloadEstimateUsageEntry").add("ServiceCode", serviceCode())
                .add("UsageType", usageType()).add("Operation", operation()).add("Key", key()).add("Group", group())
                .add("UsageAccountId", usageAccountId()).add("Amount", amount()).add("HistoricalUsage", historicalUsage())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceCode":
            return Optional.ofNullable(clazz.cast(serviceCode()));
        case "usageType":
            return Optional.ofNullable(clazz.cast(usageType()));
        case "operation":
            return Optional.ofNullable(clazz.cast(operation()));
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "group":
            return Optional.ofNullable(clazz.cast(group()));
        case "usageAccountId":
            return Optional.ofNullable(clazz.cast(usageAccountId()));
        case "amount":
            return Optional.ofNullable(clazz.cast(amount()));
        case "historicalUsage":
            return Optional.ofNullable(clazz.cast(historicalUsage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceCode", SERVICE_CODE_FIELD);
        map.put("usageType", USAGE_TYPE_FIELD);
        map.put("operation", OPERATION_FIELD);
        map.put("key", KEY_FIELD);
        map.put("group", GROUP_FIELD);
        map.put("usageAccountId", USAGE_ACCOUNT_ID_FIELD);
        map.put("amount", AMOUNT_FIELD);
        map.put("historicalUsage", HISTORICAL_USAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateWorkloadEstimateUsageEntry, T> g) {
        return obj -> g.apply((BatchCreateWorkloadEstimateUsageEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchCreateWorkloadEstimateUsageEntry> {
        /**
         * <p>
         * The Amazon Web Services service code for this usage estimate.
         * </p>
         * 
         * @param serviceCode
         *        The Amazon Web Services service code for this usage estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);

        /**
         * <p>
         * The type of usage being estimated.
         * </p>
         * 
         * @param usageType
         *        The type of usage being estimated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageType(String usageType);

        /**
         * <p>
         * The specific operation associated with this usage estimate.
         * </p>
         * 
         * @param operation
         *        The specific operation associated with this usage estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(String operation);

        /**
         * <p>
         * A unique identifier for this entry in the batch operation.
         * </p>
         * 
         * @param key
         *        A unique identifier for this entry in the batch operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * An optional group identifier for the usage estimate.
         * </p>
         * 
         * @param group
         *        An optional group identifier for the usage estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(String group);

        /**
         * <p>
         * The Amazon Web Services account ID associated with this usage estimate.
         * </p>
         * 
         * @param usageAccountId
         *        The Amazon Web Services account ID associated with this usage estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageAccountId(String usageAccountId);

        /**
         * <p>
         * The estimated usage amount.
         * </p>
         * 
         * @param amount
         *        The estimated usage amount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amount(Double amount);

        /**
         * <p>
         * Historical usage data associated with this estimate, if available.
         * </p>
         * 
         * @param historicalUsage
         *        Historical usage data associated with this estimate, if available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder historicalUsage(HistoricalUsageEntity historicalUsage);

        /**
         * <p>
         * Historical usage data associated with this estimate, if available.
         * </p>
         * This is a convenience method that creates an instance of the {@link HistoricalUsageEntity.Builder} avoiding
         * the need to create one manually via {@link HistoricalUsageEntity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HistoricalUsageEntity.Builder#build()} is called immediately and
         * its result is passed to {@link #historicalUsage(HistoricalUsageEntity)}.
         * 
         * @param historicalUsage
         *        a consumer that will call methods on {@link HistoricalUsageEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #historicalUsage(HistoricalUsageEntity)
         */
        default Builder historicalUsage(Consumer<HistoricalUsageEntity.Builder> historicalUsage) {
            return historicalUsage(HistoricalUsageEntity.builder().applyMutation(historicalUsage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String serviceCode;

        private String usageType;

        private String operation;

        private String key;

        private String group;

        private String usageAccountId;

        private Double amount;

        private HistoricalUsageEntity historicalUsage;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateWorkloadEstimateUsageEntry model) {
            serviceCode(model.serviceCode);
            usageType(model.usageType);
            operation(model.operation);
            key(model.key);
            group(model.group);
            usageAccountId(model.usageAccountId);
            amount(model.amount);
            historicalUsage(model.historicalUsage);
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final String getUsageType() {
            return usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        public final String getOperation() {
            return operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getGroup() {
            return group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final String getUsageAccountId() {
            return usageAccountId;
        }

        public final void setUsageAccountId(String usageAccountId) {
            this.usageAccountId = usageAccountId;
        }

        @Override
        public final Builder usageAccountId(String usageAccountId) {
            this.usageAccountId = usageAccountId;
            return this;
        }

        public final Double getAmount() {
            return amount;
        }

        public final void setAmount(Double amount) {
            this.amount = amount;
        }

        @Override
        public final Builder amount(Double amount) {
            this.amount = amount;
            return this;
        }

        public final HistoricalUsageEntity.Builder getHistoricalUsage() {
            return historicalUsage != null ? historicalUsage.toBuilder() : null;
        }

        public final void setHistoricalUsage(HistoricalUsageEntity.BuilderImpl historicalUsage) {
            this.historicalUsage = historicalUsage != null ? historicalUsage.build() : null;
        }

        @Override
        public final Builder historicalUsage(HistoricalUsageEntity historicalUsage) {
            this.historicalUsage = historicalUsage;
            return this;
        }

        @Override
        public BatchCreateWorkloadEstimateUsageEntry build() {
            return new BatchCreateWorkloadEstimateUsageEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
