/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an error that occurred during a batch create operation for bill scenario commitment modifications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCreateBillScenarioCommitmentModificationError
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<BatchCreateBillScenarioCommitmentModificationError.Builder, BatchCreateBillScenarioCommitmentModificationError> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(BatchCreateBillScenarioCommitmentModificationError::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(BatchCreateBillScenarioCommitmentModificationError::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(BatchCreateBillScenarioCommitmentModificationError::errorCodeAsString))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD,
            ERROR_MESSAGE_FIELD, ERROR_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String errorMessage;

    private final String errorCode;

    private BatchCreateBillScenarioCommitmentModificationError(BuilderImpl builder) {
        this.key = builder.key;
        this.errorMessage = builder.errorMessage;
        this.errorCode = builder.errorCode;
    }

    /**
     * <p>
     * The key of the entry that caused the error.
     * </p>
     * 
     * @return The key of the entry that caused the error.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * A descriptive message for the error that occurred.
     * </p>
     * 
     * @return A descriptive message for the error that occurred.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The error code associated with the failed operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link BatchCreateBillScenarioCommitmentModificationErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code associated with the failed operation.
     * @see BatchCreateBillScenarioCommitmentModificationErrorCode
     */
    public final BatchCreateBillScenarioCommitmentModificationErrorCode errorCode() {
        return BatchCreateBillScenarioCommitmentModificationErrorCode.fromValue(errorCode);
    }

    /**
     * <p>
     * The error code associated with the failed operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link BatchCreateBillScenarioCommitmentModificationErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code associated with the failed operation.
     * @see BatchCreateBillScenarioCommitmentModificationErrorCode
     */
    public final String errorCodeAsString() {
        return errorCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateBillScenarioCommitmentModificationError)) {
            return false;
        }
        BatchCreateBillScenarioCommitmentModificationError other = (BatchCreateBillScenarioCommitmentModificationError) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(errorCodeAsString(), other.errorCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchCreateBillScenarioCommitmentModificationError").add("Key", key())
                .add("ErrorMessage", errorMessage()).add("ErrorCode", errorCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("key", KEY_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("errorCode", ERROR_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateBillScenarioCommitmentModificationError, T> g) {
        return obj -> g.apply((BatchCreateBillScenarioCommitmentModificationError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchCreateBillScenarioCommitmentModificationError> {
        /**
         * <p>
         * The key of the entry that caused the error.
         * </p>
         * 
         * @param key
         *        The key of the entry that caused the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * A descriptive message for the error that occurred.
         * </p>
         * 
         * @param errorMessage
         *        A descriptive message for the error that occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The error code associated with the failed operation.
         * </p>
         * 
         * @param errorCode
         *        The error code associated with the failed operation.
         * @see BatchCreateBillScenarioCommitmentModificationErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchCreateBillScenarioCommitmentModificationErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error code associated with the failed operation.
         * </p>
         * 
         * @param errorCode
         *        The error code associated with the failed operation.
         * @see BatchCreateBillScenarioCommitmentModificationErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchCreateBillScenarioCommitmentModificationErrorCode
         */
        Builder errorCode(BatchCreateBillScenarioCommitmentModificationErrorCode errorCode);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String errorMessage;

        private String errorCode;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateBillScenarioCommitmentModificationError model) {
            key(model.key);
            errorMessage(model.errorMessage);
            errorCode(model.errorCode);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(BatchCreateBillScenarioCommitmentModificationErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        @Override
        public BatchCreateBillScenarioCommitmentModificationError build() {
            return new BatchCreateBillScenarioCommitmentModificationError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
