/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.bcmpricingcalculator.internal.BcmPricingCalculatorServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.bcmpricingcalculator.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.bcmpricingcalculator.model.AccessDeniedException;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioCommitmentModificationRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioCommitmentModificationResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioUsageModificationRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioUsageModificationResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateWorkloadEstimateUsageRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateWorkloadEstimateUsageResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteBillScenarioCommitmentModificationRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteBillScenarioCommitmentModificationResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteBillScenarioUsageModificationRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteBillScenarioUsageModificationResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteWorkloadEstimateUsageRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchDeleteWorkloadEstimateUsageResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioCommitmentModificationRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioCommitmentModificationResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioUsageModificationRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioUsageModificationResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateWorkloadEstimateUsageRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateWorkloadEstimateUsageResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BcmPricingCalculatorException;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ConflictException;
import software.amazon.awssdk.services.bcmpricingcalculator.model.CreateBillEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.CreateBillEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.CreateBillScenarioRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.CreateBillScenarioResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.CreateWorkloadEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.CreateWorkloadEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.DataUnavailableException;
import software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteBillEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteBillEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteBillScenarioRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteBillScenarioResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteWorkloadEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.DeleteWorkloadEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetBillEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetBillEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetBillScenarioRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetBillScenarioResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetPreferencesRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetPreferencesResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetWorkloadEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GetWorkloadEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.InternalServerException;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateCommitmentsResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputCommitmentModificationsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputCommitmentModificationsResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimatesResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioCommitmentModificationsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioCommitmentModificationsResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimateUsageRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimateUsageResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ResourceNotFoundException;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.bcmpricingcalculator.model.TagResourceRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.TagResourceResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ThrottlingException;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UntagResourceRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UntagResourceResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateBillEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateBillEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateBillScenarioRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateBillScenarioResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdatePreferencesRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdatePreferencesResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateWorkloadEstimateRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UpdateWorkloadEstimateResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ValidationException;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.BatchCreateBillScenarioCommitmentModificationRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.BatchCreateBillScenarioUsageModificationRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.BatchCreateWorkloadEstimateUsageRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.BatchDeleteBillScenarioCommitmentModificationRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.BatchDeleteBillScenarioUsageModificationRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.BatchDeleteWorkloadEstimateUsageRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.BatchUpdateBillScenarioCommitmentModificationRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.BatchUpdateBillScenarioUsageModificationRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.BatchUpdateWorkloadEstimateUsageRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.CreateBillEstimateRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.CreateBillScenarioRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.CreateWorkloadEstimateRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.DeleteBillEstimateRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.DeleteBillScenarioRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.DeleteWorkloadEstimateRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.GetBillEstimateRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.GetBillScenarioRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.GetPreferencesRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.GetWorkloadEstimateRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.ListBillEstimateCommitmentsRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.ListBillEstimateInputCommitmentModificationsRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.ListBillEstimateInputUsageModificationsRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.ListBillEstimateLineItemsRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.ListBillEstimatesRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.ListBillScenarioCommitmentModificationsRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.ListBillScenarioUsageModificationsRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.ListBillScenariosRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.ListWorkloadEstimateUsageRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.ListWorkloadEstimatesRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.UpdateBillEstimateRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.UpdateBillScenarioRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.UpdatePreferencesRequestMarshaller;
import software.amazon.awssdk.services.bcmpricingcalculator.transform.UpdateWorkloadEstimateRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link BcmPricingCalculatorClient}.
 *
 * @see BcmPricingCalculatorClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultBcmPricingCalculatorClient implements BcmPricingCalculatorClient {
    private static final Logger log = Logger.loggerFor(DefaultBcmPricingCalculatorClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultBcmPricingCalculatorClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "BCM_Pricing_Calculator" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Create Compute Savings Plans, EC2 Instance Savings Plans, or EC2 Reserved Instances commitments that you want to
     * model in a Bill Scenario.
     * </p>
     * <note>
     * <p>
     * The <code>BatchCreateBillScenarioCommitmentModification</code> operation doesn't have its own IAM permission. To
     * authorize this operation for Amazon Web Services principals, include the permission
     * <code>bcm-pricing-calculator:CreateBillScenarioCommitmentModification</code> in your policies.
     * </p>
     * </note>
     *
     * @param batchCreateBillScenarioCommitmentModificationRequest
     * @return Result of the BatchCreateBillScenarioCommitmentModification operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.BatchCreateBillScenarioCommitmentModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchCreateBillScenarioCommitmentModification"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchCreateBillScenarioCommitmentModificationResponse batchCreateBillScenarioCommitmentModification(
            BatchCreateBillScenarioCommitmentModificationRequest batchCreateBillScenarioCommitmentModificationRequest)
            throws ConflictException, ValidationException, DataUnavailableException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchCreateBillScenarioCommitmentModificationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, BatchCreateBillScenarioCommitmentModificationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                batchCreateBillScenarioCommitmentModificationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchCreateBillScenarioCommitmentModificationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchCreateBillScenarioCommitmentModification");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchCreateBillScenarioCommitmentModificationRequest, BatchCreateBillScenarioCommitmentModificationResponse>()
                            .withOperationName("BatchCreateBillScenarioCommitmentModification")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(batchCreateBillScenarioCommitmentModificationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchCreateBillScenarioCommitmentModificationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create Amazon Web Services service usage that you want to model in a Bill Scenario.
     * </p>
     * <note>
     * <p>
     * The <code>BatchCreateBillScenarioUsageModification</code> operation doesn't have its own IAM permission. To
     * authorize this operation for Amazon Web Services principals, include the permission
     * <code>bcm-pricing-calculator:CreateBillScenarioUsageModification</code> in your policies.
     * </p>
     * </note>
     *
     * @param batchCreateBillScenarioUsageModificationRequest
     * @return Result of the BatchCreateBillScenarioUsageModification operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.BatchCreateBillScenarioUsageModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchCreateBillScenarioUsageModification"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchCreateBillScenarioUsageModificationResponse batchCreateBillScenarioUsageModification(
            BatchCreateBillScenarioUsageModificationRequest batchCreateBillScenarioUsageModificationRequest)
            throws ConflictException, ValidationException, DataUnavailableException, ServiceQuotaExceededException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchCreateBillScenarioUsageModificationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, BatchCreateBillScenarioUsageModificationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                batchCreateBillScenarioUsageModificationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchCreateBillScenarioUsageModificationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchCreateBillScenarioUsageModification");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchCreateBillScenarioUsageModificationRequest, BatchCreateBillScenarioUsageModificationResponse>()
                            .withOperationName("BatchCreateBillScenarioUsageModification").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(batchCreateBillScenarioUsageModificationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchCreateBillScenarioUsageModificationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create Amazon Web Services service usage that you want to model in a Workload Estimate.
     * </p>
     * <note>
     * <p>
     * The <code>BatchCreateWorkloadEstimateUsage</code> operation doesn't have its own IAM permission. To authorize
     * this operation for Amazon Web Services principals, include the permission
     * <code>bcm-pricing-calculator:CreateWorkloadEstimateUsage</code> in your policies.
     * </p>
     * </note>
     *
     * @param batchCreateWorkloadEstimateUsageRequest
     * @return Result of the BatchCreateWorkloadEstimateUsage operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.BatchCreateWorkloadEstimateUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchCreateWorkloadEstimateUsage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchCreateWorkloadEstimateUsageResponse batchCreateWorkloadEstimateUsage(
            BatchCreateWorkloadEstimateUsageRequest batchCreateWorkloadEstimateUsageRequest) throws ConflictException,
            ValidationException, DataUnavailableException, ServiceQuotaExceededException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchCreateWorkloadEstimateUsageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchCreateWorkloadEstimateUsageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchCreateWorkloadEstimateUsageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchCreateWorkloadEstimateUsageRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchCreateWorkloadEstimateUsage");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchCreateWorkloadEstimateUsageRequest, BatchCreateWorkloadEstimateUsageResponse>()
                            .withOperationName("BatchCreateWorkloadEstimateUsage").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchCreateWorkloadEstimateUsageRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchCreateWorkloadEstimateUsageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete commitment that you have created in a Bill Scenario. You can only delete a commitment that you had added
     * and cannot model deletion (or removal) of a existing commitment. If you want model deletion of an existing
     * commitment, see the negate <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BillScenarioCommitmentModificationAction.html"
     * > BillScenarioCommitmentModificationAction</a> of <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchCreateBillScenarioUsageModification.html"
     * > BatchCreateBillScenarioCommitmentModification</a> operation.
     * </p>
     * <note>
     * <p>
     * The <code>BatchDeleteBillScenarioCommitmentModification</code> operation doesn't have its own IAM permission. To
     * authorize this operation for Amazon Web Services principals, include the permission
     * <code>bcm-pricing-calculator:DeleteBillScenarioCommitmentModification</code> in your policies.
     * </p>
     * </note>
     *
     * @param batchDeleteBillScenarioCommitmentModificationRequest
     * @return Result of the BatchDeleteBillScenarioCommitmentModification operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.BatchDeleteBillScenarioCommitmentModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchDeleteBillScenarioCommitmentModification"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchDeleteBillScenarioCommitmentModificationResponse batchDeleteBillScenarioCommitmentModification(
            BatchDeleteBillScenarioCommitmentModificationRequest batchDeleteBillScenarioCommitmentModificationRequest)
            throws ConflictException, ValidationException, DataUnavailableException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDeleteBillScenarioCommitmentModificationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, BatchDeleteBillScenarioCommitmentModificationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                batchDeleteBillScenarioCommitmentModificationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchDeleteBillScenarioCommitmentModificationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteBillScenarioCommitmentModification");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchDeleteBillScenarioCommitmentModificationRequest, BatchDeleteBillScenarioCommitmentModificationResponse>()
                            .withOperationName("BatchDeleteBillScenarioCommitmentModification")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(batchDeleteBillScenarioCommitmentModificationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchDeleteBillScenarioCommitmentModificationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete usage that you have created in a Bill Scenario. You can only delete usage that you had added and cannot
     * model deletion (or removal) of a existing usage. If you want model removal of an existing usage, see <a href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchUpdateBillScenarioUsageModification.html"
     * > BatchUpdateBillScenarioUsageModification</a>.
     * </p>
     * <note>
     * <p>
     * The <code>BatchDeleteBillScenarioUsageModification</code> operation doesn't have its own IAM permission. To
     * authorize this operation for Amazon Web Services principals, include the permission
     * <code>bcm-pricing-calculator:DeleteBillScenarioUsageModification</code> in your policies.
     * </p>
     * </note>
     *
     * @param batchDeleteBillScenarioUsageModificationRequest
     * @return Result of the BatchDeleteBillScenarioUsageModification operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.BatchDeleteBillScenarioUsageModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchDeleteBillScenarioUsageModification"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchDeleteBillScenarioUsageModificationResponse batchDeleteBillScenarioUsageModification(
            BatchDeleteBillScenarioUsageModificationRequest batchDeleteBillScenarioUsageModificationRequest)
            throws ConflictException, ValidationException, DataUnavailableException, ServiceQuotaExceededException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDeleteBillScenarioUsageModificationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, BatchDeleteBillScenarioUsageModificationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                batchDeleteBillScenarioUsageModificationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchDeleteBillScenarioUsageModificationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteBillScenarioUsageModification");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchDeleteBillScenarioUsageModificationRequest, BatchDeleteBillScenarioUsageModificationResponse>()
                            .withOperationName("BatchDeleteBillScenarioUsageModification").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(batchDeleteBillScenarioUsageModificationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchDeleteBillScenarioUsageModificationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete usage that you have created in a Workload estimate. You can only delete usage that you had added and
     * cannot model deletion (or removal) of a existing usage. If you want model removal of an existing usage, see <a
     * href=
     * "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchUpdateWorkloadEstimateUsage.html"
     * > BatchUpdateWorkloadEstimateUsage</a>.
     * </p>
     * <note>
     * <p>
     * The <code>BatchDeleteWorkloadEstimateUsage</code> operation doesn't have its own IAM permission. To authorize
     * this operation for Amazon Web Services principals, include the permission
     * <code>bcm-pricing-calculator:DeleteWorkloadEstimateUsage</code> in your policies.
     * </p>
     * </note>
     *
     * @param batchDeleteWorkloadEstimateUsageRequest
     * @return Result of the BatchDeleteWorkloadEstimateUsage operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.BatchDeleteWorkloadEstimateUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchDeleteWorkloadEstimateUsage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchDeleteWorkloadEstimateUsageResponse batchDeleteWorkloadEstimateUsage(
            BatchDeleteWorkloadEstimateUsageRequest batchDeleteWorkloadEstimateUsageRequest) throws ValidationException,
            DataUnavailableException, ServiceQuotaExceededException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDeleteWorkloadEstimateUsageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchDeleteWorkloadEstimateUsageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDeleteWorkloadEstimateUsageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchDeleteWorkloadEstimateUsageRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteWorkloadEstimateUsage");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchDeleteWorkloadEstimateUsageRequest, BatchDeleteWorkloadEstimateUsageResponse>()
                            .withOperationName("BatchDeleteWorkloadEstimateUsage").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchDeleteWorkloadEstimateUsageRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchDeleteWorkloadEstimateUsageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update a newly added or existing commitment. You can update the commitment group based on a commitment ID and a
     * Bill scenario ID.
     * </p>
     * <note>
     * <p>
     * The <code>BatchUpdateBillScenarioCommitmentModification</code> operation doesn't have its own IAM permission. To
     * authorize this operation for Amazon Web Services principals, include the permission
     * <code>bcm-pricing-calculator:UpdateBillScenarioCommitmentModification</code> in your policies.
     * </p>
     * </note>
     *
     * @param batchUpdateBillScenarioCommitmentModificationRequest
     * @return Result of the BatchUpdateBillScenarioCommitmentModification operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.BatchUpdateBillScenarioCommitmentModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchUpdateBillScenarioCommitmentModification"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchUpdateBillScenarioCommitmentModificationResponse batchUpdateBillScenarioCommitmentModification(
            BatchUpdateBillScenarioCommitmentModificationRequest batchUpdateBillScenarioCommitmentModificationRequest)
            throws ConflictException, ValidationException, DataUnavailableException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchUpdateBillScenarioCommitmentModificationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, BatchUpdateBillScenarioCommitmentModificationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                batchUpdateBillScenarioCommitmentModificationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchUpdateBillScenarioCommitmentModificationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchUpdateBillScenarioCommitmentModification");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchUpdateBillScenarioCommitmentModificationRequest, BatchUpdateBillScenarioCommitmentModificationResponse>()
                            .withOperationName("BatchUpdateBillScenarioCommitmentModification")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(batchUpdateBillScenarioCommitmentModificationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchUpdateBillScenarioCommitmentModificationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update a newly added or existing usage lines. You can update the usage amounts, usage hour, and usage group based
     * on a usage ID and a Bill scenario ID.
     * </p>
     * <note>
     * <p>
     * The <code>BatchUpdateBillScenarioUsageModification</code> operation doesn't have its own IAM permission. To
     * authorize this operation for Amazon Web Services principals, include the permission
     * <code>bcm-pricing-calculator:UpdateBillScenarioUsageModification</code> in your policies.
     * </p>
     * </note>
     *
     * @param batchUpdateBillScenarioUsageModificationRequest
     * @return Result of the BatchUpdateBillScenarioUsageModification operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.BatchUpdateBillScenarioUsageModification
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchUpdateBillScenarioUsageModification"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchUpdateBillScenarioUsageModificationResponse batchUpdateBillScenarioUsageModification(
            BatchUpdateBillScenarioUsageModificationRequest batchUpdateBillScenarioUsageModificationRequest)
            throws ConflictException, ValidationException, DataUnavailableException, ServiceQuotaExceededException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchUpdateBillScenarioUsageModificationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, BatchUpdateBillScenarioUsageModificationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                batchUpdateBillScenarioUsageModificationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchUpdateBillScenarioUsageModificationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchUpdateBillScenarioUsageModification");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchUpdateBillScenarioUsageModificationRequest, BatchUpdateBillScenarioUsageModificationResponse>()
                            .withOperationName("BatchUpdateBillScenarioUsageModification").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(batchUpdateBillScenarioUsageModificationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchUpdateBillScenarioUsageModificationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update a newly added or existing usage lines. You can update the usage amounts and usage group based on a usage
     * ID and a Workload estimate ID.
     * </p>
     * <note>
     * <p>
     * The <code>BatchUpdateWorkloadEstimateUsage</code> operation doesn't have its own IAM permission. To authorize
     * this operation for Amazon Web Services principals, include the permission
     * <code>bcm-pricing-calculator:UpdateWorkloadEstimateUsage</code> in your policies.
     * </p>
     * </note>
     *
     * @param batchUpdateWorkloadEstimateUsageRequest
     * @return Result of the BatchUpdateWorkloadEstimateUsage operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.BatchUpdateWorkloadEstimateUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/BatchUpdateWorkloadEstimateUsage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchUpdateWorkloadEstimateUsageResponse batchUpdateWorkloadEstimateUsage(
            BatchUpdateWorkloadEstimateUsageRequest batchUpdateWorkloadEstimateUsageRequest) throws ValidationException,
            DataUnavailableException, ServiceQuotaExceededException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchUpdateWorkloadEstimateUsageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchUpdateWorkloadEstimateUsageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchUpdateWorkloadEstimateUsageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchUpdateWorkloadEstimateUsageRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchUpdateWorkloadEstimateUsage");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchUpdateWorkloadEstimateUsageRequest, BatchUpdateWorkloadEstimateUsageResponse>()
                            .withOperationName("BatchUpdateWorkloadEstimateUsage").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchUpdateWorkloadEstimateUsageRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchUpdateWorkloadEstimateUsageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a Bill estimate from a Bill scenario. In the Bill scenario you can model usage addition, usage changes,
     * and usage removal. You can also model commitment addition and commitment removal. After all changes in a Bill
     * scenario is made satisfactorily, you can call this API with a Bill scenario ID to generate the Bill estimate.
     * Bill estimate calculates the pre-tax cost for your consolidated billing family, incorporating all modeled usage
     * and commitments alongside existing usage and commitments from your most recent completed anniversary bill, with
     * any applicable discounts applied.
     * </p>
     *
     * @param createBillEstimateRequest
     * @return Result of the CreateBillEstimate operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.CreateBillEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/CreateBillEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateBillEstimateResponse createBillEstimate(CreateBillEstimateRequest createBillEstimateRequest)
            throws ConflictException, ValidationException, DataUnavailableException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBillEstimateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateBillEstimateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBillEstimateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBillEstimateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBillEstimate");

            return clientHandler.execute(new ClientExecutionParams<CreateBillEstimateRequest, CreateBillEstimateResponse>()
                    .withOperationName("CreateBillEstimate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createBillEstimateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBillEstimateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new bill scenario to model potential changes to Amazon Web Services usage and costs.
     * </p>
     *
     * @param createBillScenarioRequest
     * @return Result of the CreateBillScenario operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.CreateBillScenario
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/CreateBillScenario"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateBillScenarioResponse createBillScenario(CreateBillScenarioRequest createBillScenarioRequest)
            throws ConflictException, ValidationException, DataUnavailableException, ServiceQuotaExceededException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBillScenarioResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateBillScenarioResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBillScenarioRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBillScenarioRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBillScenario");

            return clientHandler.execute(new ClientExecutionParams<CreateBillScenarioRequest, CreateBillScenarioResponse>()
                    .withOperationName("CreateBillScenario").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createBillScenarioRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBillScenarioRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new workload estimate to model costs for a specific workload.
     * </p>
     *
     * @param createWorkloadEstimateRequest
     * @return Result of the CreateWorkloadEstimate operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.CreateWorkloadEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/CreateWorkloadEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateWorkloadEstimateResponse createWorkloadEstimate(CreateWorkloadEstimateRequest createWorkloadEstimateRequest)
            throws ConflictException, ValidationException, DataUnavailableException, ServiceQuotaExceededException,
            InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWorkloadEstimateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateWorkloadEstimateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWorkloadEstimateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkloadEstimateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkloadEstimate");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateWorkloadEstimateRequest, CreateWorkloadEstimateResponse>()
                            .withOperationName("CreateWorkloadEstimate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createWorkloadEstimateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateWorkloadEstimateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an existing bill estimate.
     * </p>
     *
     * @param deleteBillEstimateRequest
     * @return Result of the DeleteBillEstimate operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.DeleteBillEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/DeleteBillEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteBillEstimateResponse deleteBillEstimate(DeleteBillEstimateRequest deleteBillEstimateRequest)
            throws ConflictException, ValidationException, DataUnavailableException, InternalServerException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBillEstimateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteBillEstimateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBillEstimateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBillEstimateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBillEstimate");

            return clientHandler.execute(new ClientExecutionParams<DeleteBillEstimateRequest, DeleteBillEstimateResponse>()
                    .withOperationName("DeleteBillEstimate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteBillEstimateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBillEstimateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an existing bill scenario.
     * </p>
     *
     * @param deleteBillScenarioRequest
     * @return Result of the DeleteBillScenario operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.DeleteBillScenario
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/DeleteBillScenario"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteBillScenarioResponse deleteBillScenario(DeleteBillScenarioRequest deleteBillScenarioRequest)
            throws ConflictException, ValidationException, DataUnavailableException, InternalServerException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBillScenarioResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteBillScenarioResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBillScenarioRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBillScenarioRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBillScenario");

            return clientHandler.execute(new ClientExecutionParams<DeleteBillScenarioRequest, DeleteBillScenarioResponse>()
                    .withOperationName("DeleteBillScenario").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteBillScenarioRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBillScenarioRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an existing workload estimate.
     * </p>
     *
     * @param deleteWorkloadEstimateRequest
     * @return Result of the DeleteWorkloadEstimate operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.DeleteWorkloadEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/DeleteWorkloadEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteWorkloadEstimateResponse deleteWorkloadEstimate(DeleteWorkloadEstimateRequest deleteWorkloadEstimateRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteWorkloadEstimateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteWorkloadEstimateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWorkloadEstimateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorkloadEstimateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorkloadEstimate");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteWorkloadEstimateRequest, DeleteWorkloadEstimateResponse>()
                            .withOperationName("DeleteWorkloadEstimate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteWorkloadEstimateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteWorkloadEstimateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves details of a specific bill estimate.
     * </p>
     *
     * @param getBillEstimateRequest
     * @return Result of the GetBillEstimate operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.GetBillEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/GetBillEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetBillEstimateResponse getBillEstimate(GetBillEstimateRequest getBillEstimateRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBillEstimateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetBillEstimateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBillEstimateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBillEstimateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBillEstimate");

            return clientHandler.execute(new ClientExecutionParams<GetBillEstimateRequest, GetBillEstimateResponse>()
                    .withOperationName("GetBillEstimate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getBillEstimateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetBillEstimateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves details of a specific bill scenario.
     * </p>
     *
     * @param getBillScenarioRequest
     * @return Result of the GetBillScenario operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.GetBillScenario
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/GetBillScenario"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetBillScenarioResponse getBillScenario(GetBillScenarioRequest getBillScenarioRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBillScenarioResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetBillScenarioResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBillScenarioRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBillScenarioRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBillScenario");

            return clientHandler.execute(new ClientExecutionParams<GetBillScenarioRequest, GetBillScenarioResponse>()
                    .withOperationName("GetBillScenario").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getBillScenarioRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetBillScenarioRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the current preferences for Pricing Calculator.
     * </p>
     *
     * @param getPreferencesRequest
     * @return Result of the GetPreferences operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.GetPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/GetPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetPreferencesResponse getPreferences(GetPreferencesRequest getPreferencesRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPreferencesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetPreferencesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPreferencesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPreferencesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPreferences");

            return clientHandler.execute(new ClientExecutionParams<GetPreferencesRequest, GetPreferencesResponse>()
                    .withOperationName("GetPreferences").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getPreferencesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetPreferencesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves details of a specific workload estimate.
     * </p>
     *
     * @param getWorkloadEstimateRequest
     * @return Result of the GetWorkloadEstimate operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.GetWorkloadEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/GetWorkloadEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetWorkloadEstimateResponse getWorkloadEstimate(GetWorkloadEstimateRequest getWorkloadEstimateRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetWorkloadEstimateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetWorkloadEstimateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWorkloadEstimateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWorkloadEstimateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorkloadEstimate");

            return clientHandler.execute(new ClientExecutionParams<GetWorkloadEstimateRequest, GetWorkloadEstimateResponse>()
                    .withOperationName("GetWorkloadEstimate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getWorkloadEstimateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetWorkloadEstimateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the commitments associated with a bill estimate.
     * </p>
     *
     * @param listBillEstimateCommitmentsRequest
     * @return Result of the ListBillEstimateCommitments operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillEstimateCommitments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateCommitments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBillEstimateCommitmentsResponse listBillEstimateCommitments(
            ListBillEstimateCommitmentsRequest listBillEstimateCommitmentsRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBillEstimateCommitmentsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListBillEstimateCommitmentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBillEstimateCommitmentsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBillEstimateCommitmentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBillEstimateCommitments");

            return clientHandler
                    .execute(new ClientExecutionParams<ListBillEstimateCommitmentsRequest, ListBillEstimateCommitmentsResponse>()
                            .withOperationName("ListBillEstimateCommitments").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listBillEstimateCommitmentsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListBillEstimateCommitmentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the input commitment modifications associated with a bill estimate.
     * </p>
     *
     * @param listBillEstimateInputCommitmentModificationsRequest
     * @return Result of the ListBillEstimateInputCommitmentModifications operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillEstimateInputCommitmentModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateInputCommitmentModifications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBillEstimateInputCommitmentModificationsResponse listBillEstimateInputCommitmentModifications(
            ListBillEstimateInputCommitmentModificationsRequest listBillEstimateInputCommitmentModificationsRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBillEstimateInputCommitmentModificationsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListBillEstimateInputCommitmentModificationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                listBillEstimateInputCommitmentModificationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listBillEstimateInputCommitmentModificationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBillEstimateInputCommitmentModifications");

            return clientHandler
                    .execute(new ClientExecutionParams<ListBillEstimateInputCommitmentModificationsRequest, ListBillEstimateInputCommitmentModificationsResponse>()
                            .withOperationName("ListBillEstimateInputCommitmentModifications")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(listBillEstimateInputCommitmentModificationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListBillEstimateInputCommitmentModificationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the input usage modifications associated with a bill estimate.
     * </p>
     *
     * @param listBillEstimateInputUsageModificationsRequest
     * @return Result of the ListBillEstimateInputUsageModifications operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillEstimateInputUsageModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateInputUsageModifications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBillEstimateInputUsageModificationsResponse listBillEstimateInputUsageModifications(
            ListBillEstimateInputUsageModificationsRequest listBillEstimateInputUsageModificationsRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBillEstimateInputUsageModificationsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListBillEstimateInputUsageModificationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBillEstimateInputUsageModificationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listBillEstimateInputUsageModificationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBillEstimateInputUsageModifications");

            return clientHandler
                    .execute(new ClientExecutionParams<ListBillEstimateInputUsageModificationsRequest, ListBillEstimateInputUsageModificationsResponse>()
                            .withOperationName("ListBillEstimateInputUsageModifications").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(listBillEstimateInputUsageModificationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListBillEstimateInputUsageModificationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the line items associated with a bill estimate.
     * </p>
     *
     * @param listBillEstimateLineItemsRequest
     * @return Result of the ListBillEstimateLineItems operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillEstimateLineItems
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimateLineItems"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBillEstimateLineItemsResponse listBillEstimateLineItems(
            ListBillEstimateLineItemsRequest listBillEstimateLineItemsRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBillEstimateLineItemsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListBillEstimateLineItemsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBillEstimateLineItemsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBillEstimateLineItemsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBillEstimateLineItems");

            return clientHandler
                    .execute(new ClientExecutionParams<ListBillEstimateLineItemsRequest, ListBillEstimateLineItemsResponse>()
                            .withOperationName("ListBillEstimateLineItems").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listBillEstimateLineItemsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListBillEstimateLineItemsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all bill estimates for the account.
     * </p>
     *
     * @param listBillEstimatesRequest
     * @return Result of the ListBillEstimates operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillEstimates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillEstimates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBillEstimatesResponse listBillEstimates(ListBillEstimatesRequest listBillEstimatesRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBillEstimatesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListBillEstimatesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBillEstimatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBillEstimatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBillEstimates");

            return clientHandler.execute(new ClientExecutionParams<ListBillEstimatesRequest, ListBillEstimatesResponse>()
                    .withOperationName("ListBillEstimates").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listBillEstimatesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListBillEstimatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the commitment modifications associated with a bill scenario.
     * </p>
     *
     * @param listBillScenarioCommitmentModificationsRequest
     * @return Result of the ListBillScenarioCommitmentModifications operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillScenarioCommitmentModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarioCommitmentModifications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBillScenarioCommitmentModificationsResponse listBillScenarioCommitmentModifications(
            ListBillScenarioCommitmentModificationsRequest listBillScenarioCommitmentModificationsRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBillScenarioCommitmentModificationsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListBillScenarioCommitmentModificationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBillScenarioCommitmentModificationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listBillScenarioCommitmentModificationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBillScenarioCommitmentModifications");

            return clientHandler
                    .execute(new ClientExecutionParams<ListBillScenarioCommitmentModificationsRequest, ListBillScenarioCommitmentModificationsResponse>()
                            .withOperationName("ListBillScenarioCommitmentModifications").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(listBillScenarioCommitmentModificationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListBillScenarioCommitmentModificationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the usage modifications associated with a bill scenario.
     * </p>
     *
     * @param listBillScenarioUsageModificationsRequest
     * @return Result of the ListBillScenarioUsageModifications operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillScenarioUsageModifications
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarioUsageModifications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBillScenarioUsageModificationsResponse listBillScenarioUsageModifications(
            ListBillScenarioUsageModificationsRequest listBillScenarioUsageModificationsRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBillScenarioUsageModificationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListBillScenarioUsageModificationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBillScenarioUsageModificationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listBillScenarioUsageModificationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBillScenarioUsageModifications");

            return clientHandler
                    .execute(new ClientExecutionParams<ListBillScenarioUsageModificationsRequest, ListBillScenarioUsageModificationsResponse>()
                            .withOperationName("ListBillScenarioUsageModifications").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listBillScenarioUsageModificationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListBillScenarioUsageModificationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all bill scenarios for the account.
     * </p>
     *
     * @param listBillScenariosRequest
     * @return Result of the ListBillScenarios operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListBillScenarios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListBillScenarios"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBillScenariosResponse listBillScenarios(ListBillScenariosRequest listBillScenariosRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBillScenariosResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListBillScenariosResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBillScenariosRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBillScenariosRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBillScenarios");

            return clientHandler.execute(new ClientExecutionParams<ListBillScenariosRequest, ListBillScenariosResponse>()
                    .withOperationName("ListBillScenarios").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listBillScenariosRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListBillScenariosRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all tags associated with a specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the usage associated with a workload estimate.
     * </p>
     *
     * @param listWorkloadEstimateUsageRequest
     * @return Result of the ListWorkloadEstimateUsage operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListWorkloadEstimateUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListWorkloadEstimateUsage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListWorkloadEstimateUsageResponse listWorkloadEstimateUsage(
            ListWorkloadEstimateUsageRequest listWorkloadEstimateUsageRequest) throws ValidationException,
            DataUnavailableException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListWorkloadEstimateUsageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListWorkloadEstimateUsageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWorkloadEstimateUsageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorkloadEstimateUsageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkloadEstimateUsage");

            return clientHandler
                    .execute(new ClientExecutionParams<ListWorkloadEstimateUsageRequest, ListWorkloadEstimateUsageResponse>()
                            .withOperationName("ListWorkloadEstimateUsage").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listWorkloadEstimateUsageRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListWorkloadEstimateUsageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all workload estimates for the account.
     * </p>
     *
     * @param listWorkloadEstimatesRequest
     * @return Result of the ListWorkloadEstimates operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.ListWorkloadEstimates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/ListWorkloadEstimates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListWorkloadEstimatesResponse listWorkloadEstimates(ListWorkloadEstimatesRequest listWorkloadEstimatesRequest)
            throws ValidationException, DataUnavailableException, InternalServerException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListWorkloadEstimatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListWorkloadEstimatesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWorkloadEstimatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorkloadEstimatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkloadEstimates");

            return clientHandler.execute(new ClientExecutionParams<ListWorkloadEstimatesRequest, ListWorkloadEstimatesResponse>()
                    .withOperationName("ListWorkloadEstimates").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listWorkloadEstimatesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListWorkloadEstimatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds one or more tags to a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            ServiceQuotaExceededException, InternalServerException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes one or more tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing bill estimate.
     * </p>
     *
     * @param updateBillEstimateRequest
     * @return Result of the UpdateBillEstimate operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.UpdateBillEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UpdateBillEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateBillEstimateResponse updateBillEstimate(UpdateBillEstimateRequest updateBillEstimateRequest)
            throws ConflictException, ValidationException, DataUnavailableException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBillEstimateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateBillEstimateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBillEstimateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBillEstimateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBillEstimate");

            return clientHandler.execute(new ClientExecutionParams<UpdateBillEstimateRequest, UpdateBillEstimateResponse>()
                    .withOperationName("UpdateBillEstimate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateBillEstimateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateBillEstimateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing bill scenario.
     * </p>
     *
     * @param updateBillScenarioRequest
     * @return Result of the UpdateBillScenario operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.UpdateBillScenario
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UpdateBillScenario"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateBillScenarioResponse updateBillScenario(UpdateBillScenarioRequest updateBillScenarioRequest)
            throws ConflictException, ValidationException, DataUnavailableException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBillScenarioResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateBillScenarioResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBillScenarioRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBillScenarioRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBillScenario");

            return clientHandler.execute(new ClientExecutionParams<UpdateBillScenarioRequest, UpdateBillScenarioResponse>()
                    .withOperationName("UpdateBillScenario").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateBillScenarioRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateBillScenarioRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the preferences for Pricing Calculator.
     * </p>
     *
     * @param updatePreferencesRequest
     * @return Result of the UpdatePreferences operation returned by the service.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws ServiceQuotaExceededException
     *         The request would cause you to exceed your service quota.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.UpdatePreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UpdatePreferences"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdatePreferencesResponse updatePreferences(UpdatePreferencesRequest updatePreferencesRequest)
            throws ValidationException, DataUnavailableException, ServiceQuotaExceededException, InternalServerException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePreferencesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdatePreferencesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updatePreferencesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePreferencesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePreferences");

            return clientHandler.execute(new ClientExecutionParams<UpdatePreferencesRequest, UpdatePreferencesResponse>()
                    .withOperationName("UpdatePreferences").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updatePreferencesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdatePreferencesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing workload estimate.
     * </p>
     *
     * @param updateWorkloadEstimateRequest
     * @return Result of the UpdateWorkloadEstimate operation returned by the service.
     * @throws ConflictException
     *         The request could not be processed because of conflict in the current state of the resource.
     * @throws ValidationException
     *         The input provided fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws DataUnavailableException
     *         The requested data is currently unavailable.
     * @throws InternalServerException
     *         An internal error has occurred. Retry your request, but if the problem persists, contact Amazon Web
     *         Services support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmPricingCalculatorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmPricingCalculatorClient.UpdateWorkloadEstimate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-pricing-calculator-2024-06-19/UpdateWorkloadEstimate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateWorkloadEstimateResponse updateWorkloadEstimate(UpdateWorkloadEstimateRequest updateWorkloadEstimateRequest)
            throws ConflictException, ValidationException, DataUnavailableException, InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmPricingCalculatorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateWorkloadEstimateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateWorkloadEstimateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DataUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateWorkloadEstimateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWorkloadEstimateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "BCM Pricing Calculator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWorkloadEstimate");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateWorkloadEstimateRequest, UpdateWorkloadEstimateResponse>()
                            .withOperationName("UpdateWorkloadEstimate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateWorkloadEstimateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateWorkloadEstimateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        BcmPricingCalculatorServiceClientConfigurationBuilder serviceConfigBuilder = new BcmPricingCalculatorServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder.clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(BcmPricingCalculatorException::builder).protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.0");
    }

    @Override
    public final BcmPricingCalculatorServiceClientConfiguration serviceClientConfiguration() {
        return new BcmPricingCalculatorServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
