/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BcmPricingCalculatorRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.FilterTimestamp;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesFilter;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkloadEstimatesRequest
extends BcmPricingCalculatorRequest
implements ToCopyableBuilder<Builder, ListWorkloadEstimatesRequest> {
    private static final SdkField<FilterTimestamp> CREATED_AT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("createdAtFilter").getter(ListWorkloadEstimatesRequest.getter(ListWorkloadEstimatesRequest::createdAtFilter)).setter(ListWorkloadEstimatesRequest.setter(Builder::createdAtFilter)).constructor(FilterTimestamp::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAtFilter").build()}).build();
    private static final SdkField<FilterTimestamp> EXPIRES_AT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("expiresAtFilter").getter(ListWorkloadEstimatesRequest.getter(ListWorkloadEstimatesRequest::expiresAtFilter)).setter(ListWorkloadEstimatesRequest.setter(Builder::expiresAtFilter)).constructor(FilterTimestamp::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresAtFilter").build()}).build();
    private static final SdkField<List<ListWorkloadEstimatesFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filters").getter(ListWorkloadEstimatesRequest.getter(ListWorkloadEstimatesRequest::filters)).setter(ListWorkloadEstimatesRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListWorkloadEstimatesFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListWorkloadEstimatesRequest.getter(ListWorkloadEstimatesRequest::nextToken)).setter(ListWorkloadEstimatesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListWorkloadEstimatesRequest.getter(ListWorkloadEstimatesRequest::maxResults)).setter(ListWorkloadEstimatesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FILTER_FIELD, EXPIRES_AT_FILTER_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListWorkloadEstimatesRequest.memberNameToFieldInitializer();
    private final FilterTimestamp createdAtFilter;
    private final FilterTimestamp expiresAtFilter;
    private final List<ListWorkloadEstimatesFilter> filters;
    private final String nextToken;
    private final Integer maxResults;

    private ListWorkloadEstimatesRequest(BuilderImpl builder) {
        super(builder);
        this.createdAtFilter = builder.createdAtFilter;
        this.expiresAtFilter = builder.expiresAtFilter;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final FilterTimestamp createdAtFilter() {
        return this.createdAtFilter;
    }

    public final FilterTimestamp expiresAtFilter() {
        return this.expiresAtFilter;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<ListWorkloadEstimatesFilter> filters() {
        return this.filters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAtFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresAtFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkloadEstimatesRequest)) {
            return false;
        }
        ListWorkloadEstimatesRequest other = (ListWorkloadEstimatesRequest)((Object)obj);
        return Objects.equals(this.createdAtFilter(), other.createdAtFilter()) && Objects.equals(this.expiresAtFilter(), other.expiresAtFilter()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkloadEstimatesRequest").add("CreatedAtFilter", (Object)this.createdAtFilter()).add("ExpiresAtFilter", (Object)this.expiresAtFilter()).add("Filters", this.hasFilters() ? this.filters() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAtFilter": {
                return Optional.ofNullable(clazz.cast(this.createdAtFilter()));
            }
            case "expiresAtFilter": {
                return Optional.ofNullable(clazz.cast(this.expiresAtFilter()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createdAtFilter", CREATED_AT_FILTER_FIELD);
        map.put("expiresAtFilter", EXPIRES_AT_FILTER_FIELD);
        map.put("filters", FILTERS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWorkloadEstimatesRequest, T> g) {
        return obj -> g.apply((ListWorkloadEstimatesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BcmPricingCalculatorRequest.BuilderImpl
    implements Builder {
        private FilterTimestamp createdAtFilter;
        private FilterTimestamp expiresAtFilter;
        private List<ListWorkloadEstimatesFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkloadEstimatesRequest model) {
            super(model);
            this.createdAtFilter(model.createdAtFilter);
            this.expiresAtFilter(model.expiresAtFilter);
            this.filters(model.filters);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final FilterTimestamp.Builder getCreatedAtFilter() {
            return this.createdAtFilter != null ? this.createdAtFilter.toBuilder() : null;
        }

        public final void setCreatedAtFilter(FilterTimestamp.BuilderImpl createdAtFilter) {
            this.createdAtFilter = createdAtFilter != null ? createdAtFilter.build() : null;
        }

        @Override
        public final Builder createdAtFilter(FilterTimestamp createdAtFilter) {
            this.createdAtFilter = createdAtFilter;
            return this;
        }

        public final FilterTimestamp.Builder getExpiresAtFilter() {
            return this.expiresAtFilter != null ? this.expiresAtFilter.toBuilder() : null;
        }

        public final void setExpiresAtFilter(FilterTimestamp.BuilderImpl expiresAtFilter) {
            this.expiresAtFilter = expiresAtFilter != null ? expiresAtFilter.build() : null;
        }

        @Override
        public final Builder expiresAtFilter(FilterTimestamp expiresAtFilter) {
            this.expiresAtFilter = expiresAtFilter;
            return this;
        }

        public final List<ListWorkloadEstimatesFilter.Builder> getFilters() {
            List<ListWorkloadEstimatesFilter.Builder> result = ListWorkloadEstimatesFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<ListWorkloadEstimatesFilter.BuilderImpl> filters) {
            this.filters = ListWorkloadEstimatesFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<ListWorkloadEstimatesFilter> filters) {
            this.filters = ListWorkloadEstimatesFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ListWorkloadEstimatesFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ListWorkloadEstimatesFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (ListWorkloadEstimatesFilter)((ListWorkloadEstimatesFilter.Builder)ListWorkloadEstimatesFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListWorkloadEstimatesRequest build() {
            return new ListWorkloadEstimatesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BcmPricingCalculatorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkloadEstimatesRequest> {
        public Builder createdAtFilter(FilterTimestamp var1);

        default public Builder createdAtFilter(Consumer<FilterTimestamp.Builder> createdAtFilter) {
            return this.createdAtFilter((FilterTimestamp)((FilterTimestamp.Builder)FilterTimestamp.builder().applyMutation(createdAtFilter)).build());
        }

        public Builder expiresAtFilter(FilterTimestamp var1);

        default public Builder expiresAtFilter(Consumer<FilterTimestamp.Builder> expiresAtFilter) {
            return this.expiresAtFilter((FilterTimestamp)((FilterTimestamp.Builder)FilterTimestamp.builder().applyMutation(expiresAtFilter)).build());
        }

        public Builder filters(Collection<ListWorkloadEstimatesFilter> var1);

        public Builder filters(ListWorkloadEstimatesFilter ... var1);

        public Builder filters(Consumer<ListWorkloadEstimatesFilter.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

