/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.BcmPricingCalculatorAsyncClient;
import software.amazon.awssdk.services.bcmpricingcalculator.internal.UserAgentUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BillScenarioCommitmentModificationItem;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioCommitmentModificationsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioCommitmentModificationsResponse;

public class ListBillScenarioCommitmentModificationsPublisher
implements SdkPublisher<ListBillScenarioCommitmentModificationsResponse> {
    private final BcmPricingCalculatorAsyncClient client;
    private final ListBillScenarioCommitmentModificationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBillScenarioCommitmentModificationsPublisher(BcmPricingCalculatorAsyncClient client, ListBillScenarioCommitmentModificationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBillScenarioCommitmentModificationsPublisher(BcmPricingCalculatorAsyncClient client, ListBillScenarioCommitmentModificationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBillScenarioCommitmentModificationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBillScenarioCommitmentModificationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BillScenarioCommitmentModificationItem> items() {
        Function<ListBillScenarioCommitmentModificationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBillScenarioCommitmentModificationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBillScenarioCommitmentModificationsResponseFetcher
    implements AsyncPageFetcher<ListBillScenarioCommitmentModificationsResponse> {
        private ListBillScenarioCommitmentModificationsResponseFetcher() {
        }

        public boolean hasNextPage(ListBillScenarioCommitmentModificationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBillScenarioCommitmentModificationsResponse> nextPage(ListBillScenarioCommitmentModificationsResponse previousPage) {
            if (previousPage == null) {
                return ListBillScenarioCommitmentModificationsPublisher.this.client.listBillScenarioCommitmentModifications(ListBillScenarioCommitmentModificationsPublisher.this.firstRequest);
            }
            return ListBillScenarioCommitmentModificationsPublisher.this.client.listBillScenarioCommitmentModifications((ListBillScenarioCommitmentModificationsRequest)((Object)ListBillScenarioCommitmentModificationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

