/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateWorkloadEstimateUsageError;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateWorkloadEstimateUsageErrorsCopier;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BcmPricingCalculatorResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.WorkloadEstimateUsageItem;
import software.amazon.awssdk.services.bcmpricingcalculator.model.WorkloadEstimateUsageItemsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateWorkloadEstimateUsageResponse
extends BcmPricingCalculatorResponse
implements ToCopyableBuilder<Builder, BatchUpdateWorkloadEstimateUsageResponse> {
    private static final SdkField<List<WorkloadEstimateUsageItem>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("items").getter(BatchUpdateWorkloadEstimateUsageResponse.getter(BatchUpdateWorkloadEstimateUsageResponse::items)).setter(BatchUpdateWorkloadEstimateUsageResponse.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkloadEstimateUsageItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchUpdateWorkloadEstimateUsageError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchUpdateWorkloadEstimateUsageResponse.getter(BatchUpdateWorkloadEstimateUsageResponse::errors)).setter(BatchUpdateWorkloadEstimateUsageResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchUpdateWorkloadEstimateUsageError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEMS_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchUpdateWorkloadEstimateUsageResponse.memberNameToFieldInitializer();
    private final List<WorkloadEstimateUsageItem> items;
    private final List<BatchUpdateWorkloadEstimateUsageError> errors;

    private BatchUpdateWorkloadEstimateUsageResponse(BuilderImpl builder) {
        super(builder);
        this.items = builder.items;
        this.errors = builder.errors;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<WorkloadEstimateUsageItem> items() {
        return this.items;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchUpdateWorkloadEstimateUsageError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateWorkloadEstimateUsageResponse)) {
            return false;
        }
        BatchUpdateWorkloadEstimateUsageResponse other = (BatchUpdateWorkloadEstimateUsageResponse)((Object)obj);
        return this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateWorkloadEstimateUsageResponse").add("Items", this.hasItems() ? this.items() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("items", ITEMS_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateWorkloadEstimateUsageResponse, T> g) {
        return obj -> g.apply((BatchUpdateWorkloadEstimateUsageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BcmPricingCalculatorResponse.BuilderImpl
    implements Builder {
        private List<WorkloadEstimateUsageItem> items = DefaultSdkAutoConstructList.getInstance();
        private List<BatchUpdateWorkloadEstimateUsageError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateWorkloadEstimateUsageResponse model) {
            super(model);
            this.items(model.items);
            this.errors(model.errors);
        }

        public final List<WorkloadEstimateUsageItem.Builder> getItems() {
            List<WorkloadEstimateUsageItem.Builder> result = WorkloadEstimateUsageItemsCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<WorkloadEstimateUsageItem.BuilderImpl> items) {
            this.items = WorkloadEstimateUsageItemsCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<WorkloadEstimateUsageItem> items) {
            this.items = WorkloadEstimateUsageItemsCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(WorkloadEstimateUsageItem ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<WorkloadEstimateUsageItem.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (WorkloadEstimateUsageItem)((WorkloadEstimateUsageItem.Builder)WorkloadEstimateUsageItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchUpdateWorkloadEstimateUsageError.Builder> getErrors() {
            List<BatchUpdateWorkloadEstimateUsageError.Builder> result = BatchUpdateWorkloadEstimateUsageErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchUpdateWorkloadEstimateUsageError.BuilderImpl> errors) {
            this.errors = BatchUpdateWorkloadEstimateUsageErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchUpdateWorkloadEstimateUsageError> errors) {
            this.errors = BatchUpdateWorkloadEstimateUsageErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchUpdateWorkloadEstimateUsageError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchUpdateWorkloadEstimateUsageError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchUpdateWorkloadEstimateUsageError)((BatchUpdateWorkloadEstimateUsageError.Builder)BatchUpdateWorkloadEstimateUsageError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchUpdateWorkloadEstimateUsageResponse build() {
            return new BatchUpdateWorkloadEstimateUsageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BcmPricingCalculatorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateWorkloadEstimateUsageResponse> {
        public Builder items(Collection<WorkloadEstimateUsageItem> var1);

        public Builder items(WorkloadEstimateUsageItem ... var1);

        public Builder items(Consumer<WorkloadEstimateUsageItem.Builder> ... var1);

        public Builder errors(Collection<BatchUpdateWorkloadEstimateUsageError> var1);

        public Builder errors(BatchUpdateWorkloadEstimateUsageError ... var1);

        public Builder errors(Consumer<BatchUpdateWorkloadEstimateUsageError.Builder> ... var1);
    }
}

