/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BillInterval;
import software.amazon.awssdk.services.bcmpricingcalculator.model.Expression;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HistoricalUsageEntity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HistoricalUsageEntity> {
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceCode").getter(HistoricalUsageEntity.getter(HistoricalUsageEntity::serviceCode)).setter(HistoricalUsageEntity.setter(Builder::serviceCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCode").build()}).build();
    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usageType").getter(HistoricalUsageEntity.getter(HistoricalUsageEntity::usageType)).setter(HistoricalUsageEntity.setter(Builder::usageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageType").build()}).build();
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operation").getter(HistoricalUsageEntity.getter(HistoricalUsageEntity::operation)).setter(HistoricalUsageEntity.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("location").getter(HistoricalUsageEntity.getter(HistoricalUsageEntity::location)).setter(HistoricalUsageEntity.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> USAGE_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usageAccountId").getter(HistoricalUsageEntity.getter(HistoricalUsageEntity::usageAccountId)).setter(HistoricalUsageEntity.setter(Builder::usageAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageAccountId").build()}).build();
    private static final SdkField<BillInterval> BILL_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("billInterval").getter(HistoricalUsageEntity.getter(HistoricalUsageEntity::billInterval)).setter(HistoricalUsageEntity.setter(Builder::billInterval)).constructor(BillInterval::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billInterval").build()}).build();
    private static final SdkField<Expression> FILTER_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filterExpression").getter(HistoricalUsageEntity.getter(HistoricalUsageEntity::filterExpression)).setter(HistoricalUsageEntity.setter(Builder::filterExpression)).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterExpression").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_FIELD, USAGE_TYPE_FIELD, OPERATION_FIELD, LOCATION_FIELD, USAGE_ACCOUNT_ID_FIELD, BILL_INTERVAL_FIELD, FILTER_EXPRESSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("serviceCode", SERVICE_CODE_FIELD);
            this.put("usageType", USAGE_TYPE_FIELD);
            this.put("operation", OPERATION_FIELD);
            this.put("location", LOCATION_FIELD);
            this.put("usageAccountId", USAGE_ACCOUNT_ID_FIELD);
            this.put("billInterval", BILL_INTERVAL_FIELD);
            this.put("filterExpression", FILTER_EXPRESSION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String serviceCode;
    private final String usageType;
    private final String operation;
    private final String location;
    private final String usageAccountId;
    private final BillInterval billInterval;
    private final Expression filterExpression;

    private HistoricalUsageEntity(BuilderImpl builder) {
        this.serviceCode = builder.serviceCode;
        this.usageType = builder.usageType;
        this.operation = builder.operation;
        this.location = builder.location;
        this.usageAccountId = builder.usageAccountId;
        this.billInterval = builder.billInterval;
        this.filterExpression = builder.filterExpression;
    }

    public final String serviceCode() {
        return this.serviceCode;
    }

    public final String usageType() {
        return this.usageType;
    }

    public final String operation() {
        return this.operation;
    }

    public final String location() {
        return this.location;
    }

    public final String usageAccountId() {
        return this.usageAccountId;
    }

    public final BillInterval billInterval() {
        return this.billInterval;
    }

    public final Expression filterExpression() {
        return this.filterExpression;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.operation());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.billInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterExpression());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistoricalUsageEntity)) {
            return false;
        }
        HistoricalUsageEntity other = (HistoricalUsageEntity)obj;
        return Objects.equals(this.serviceCode(), other.serviceCode()) && Objects.equals(this.usageType(), other.usageType()) && Objects.equals(this.operation(), other.operation()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.usageAccountId(), other.usageAccountId()) && Objects.equals(this.billInterval(), other.billInterval()) && Objects.equals(this.filterExpression(), other.filterExpression());
    }

    public final String toString() {
        return ToString.builder((String)"HistoricalUsageEntity").add("ServiceCode", (Object)this.serviceCode()).add("UsageType", (Object)this.usageType()).add("Operation", (Object)this.operation()).add("Location", (Object)this.location()).add("UsageAccountId", (Object)this.usageAccountId()).add("BillInterval", (Object)this.billInterval()).add("FilterExpression", (Object)this.filterExpression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceCode": {
                return Optional.ofNullable(clazz.cast(this.serviceCode()));
            }
            case "usageType": {
                return Optional.ofNullable(clazz.cast(this.usageType()));
            }
            case "operation": {
                return Optional.ofNullable(clazz.cast(this.operation()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "usageAccountId": {
                return Optional.ofNullable(clazz.cast(this.usageAccountId()));
            }
            case "billInterval": {
                return Optional.ofNullable(clazz.cast(this.billInterval()));
            }
            case "filterExpression": {
                return Optional.ofNullable(clazz.cast(this.filterExpression()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<HistoricalUsageEntity, T> g) {
        return obj -> g.apply((HistoricalUsageEntity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceCode;
        private String usageType;
        private String operation;
        private String location;
        private String usageAccountId;
        private BillInterval billInterval;
        private Expression filterExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(HistoricalUsageEntity model) {
            this.serviceCode(model.serviceCode);
            this.usageType(model.usageType);
            this.operation(model.operation);
            this.location(model.location);
            this.usageAccountId(model.usageAccountId);
            this.billInterval(model.billInterval);
            this.filterExpression(model.filterExpression);
        }

        public final String getServiceCode() {
            return this.serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final String getUsageType() {
            return this.usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        public final String getOperation() {
            return this.operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getUsageAccountId() {
            return this.usageAccountId;
        }

        public final void setUsageAccountId(String usageAccountId) {
            this.usageAccountId = usageAccountId;
        }

        @Override
        public final Builder usageAccountId(String usageAccountId) {
            this.usageAccountId = usageAccountId;
            return this;
        }

        public final BillInterval.Builder getBillInterval() {
            return this.billInterval != null ? this.billInterval.toBuilder() : null;
        }

        public final void setBillInterval(BillInterval.BuilderImpl billInterval) {
            this.billInterval = billInterval != null ? billInterval.build() : null;
        }

        @Override
        public final Builder billInterval(BillInterval billInterval) {
            this.billInterval = billInterval;
            return this;
        }

        public final Expression.Builder getFilterExpression() {
            return this.filterExpression != null ? this.filterExpression.toBuilder() : null;
        }

        public final void setFilterExpression(Expression.BuilderImpl filterExpression) {
            this.filterExpression = filterExpression != null ? filterExpression.build() : null;
        }

        @Override
        public final Builder filterExpression(Expression filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public HistoricalUsageEntity build() {
            return new HistoricalUsageEntity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HistoricalUsageEntity> {
        public Builder serviceCode(String var1);

        public Builder usageType(String var1);

        public Builder operation(String var1);

        public Builder location(String var1);

        public Builder usageAccountId(String var1);

        public Builder billInterval(BillInterval var1);

        default public Builder billInterval(Consumer<BillInterval.Builder> billInterval) {
            return this.billInterval((BillInterval)((BillInterval.Builder)BillInterval.builder().applyMutation(billInterval)).build());
        }

        public Builder filterExpression(Expression var1);

        default public Builder filterExpression(Consumer<Expression.Builder> filterExpression) {
            return this.filterExpression((Expression)((Expression.Builder)Expression.builder().applyMutation(filterExpression)).build());
        }
    }
}

