/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioCommitmentModificationEntriesCopier;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateBillScenarioCommitmentModificationEntry;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BcmPricingCalculatorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateBillScenarioCommitmentModificationRequest
extends BcmPricingCalculatorRequest
implements ToCopyableBuilder<Builder, BatchUpdateBillScenarioCommitmentModificationRequest> {
    private static final SdkField<String> BILL_SCENARIO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("billScenarioId").getter(BatchUpdateBillScenarioCommitmentModificationRequest.getter(BatchUpdateBillScenarioCommitmentModificationRequest::billScenarioId)).setter(BatchUpdateBillScenarioCommitmentModificationRequest.setter(Builder::billScenarioId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billScenarioId").build()}).build();
    private static final SdkField<List<BatchUpdateBillScenarioCommitmentModificationEntry>> COMMITMENT_MODIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("commitmentModifications").getter(BatchUpdateBillScenarioCommitmentModificationRequest.getter(BatchUpdateBillScenarioCommitmentModificationRequest::commitmentModifications)).setter(BatchUpdateBillScenarioCommitmentModificationRequest.setter(Builder::commitmentModifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitmentModifications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchUpdateBillScenarioCommitmentModificationEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILL_SCENARIO_ID_FIELD, COMMITMENT_MODIFICATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("billScenarioId", BILL_SCENARIO_ID_FIELD);
            this.put("commitmentModifications", COMMITMENT_MODIFICATIONS_FIELD);
        }
    });
    private final String billScenarioId;
    private final List<BatchUpdateBillScenarioCommitmentModificationEntry> commitmentModifications;

    private BatchUpdateBillScenarioCommitmentModificationRequest(BuilderImpl builder) {
        super(builder);
        this.billScenarioId = builder.billScenarioId;
        this.commitmentModifications = builder.commitmentModifications;
    }

    public final String billScenarioId() {
        return this.billScenarioId;
    }

    public final boolean hasCommitmentModifications() {
        return this.commitmentModifications != null && !(this.commitmentModifications instanceof SdkAutoConstructList);
    }

    public final List<BatchUpdateBillScenarioCommitmentModificationEntry> commitmentModifications() {
        return this.commitmentModifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.billScenarioId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommitmentModifications() ? this.commitmentModifications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateBillScenarioCommitmentModificationRequest)) {
            return false;
        }
        BatchUpdateBillScenarioCommitmentModificationRequest other = (BatchUpdateBillScenarioCommitmentModificationRequest)((Object)obj);
        return Objects.equals(this.billScenarioId(), other.billScenarioId()) && this.hasCommitmentModifications() == other.hasCommitmentModifications() && Objects.equals(this.commitmentModifications(), other.commitmentModifications());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateBillScenarioCommitmentModificationRequest").add("BillScenarioId", (Object)this.billScenarioId()).add("CommitmentModifications", this.hasCommitmentModifications() ? this.commitmentModifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "billScenarioId": {
                return Optional.ofNullable(clazz.cast(this.billScenarioId()));
            }
            case "commitmentModifications": {
                return Optional.ofNullable(clazz.cast(this.commitmentModifications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateBillScenarioCommitmentModificationRequest, T> g) {
        return obj -> g.apply((BatchUpdateBillScenarioCommitmentModificationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BcmPricingCalculatorRequest.BuilderImpl
    implements Builder {
        private String billScenarioId;
        private List<BatchUpdateBillScenarioCommitmentModificationEntry> commitmentModifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateBillScenarioCommitmentModificationRequest model) {
            super(model);
            this.billScenarioId(model.billScenarioId);
            this.commitmentModifications(model.commitmentModifications);
        }

        public final String getBillScenarioId() {
            return this.billScenarioId;
        }

        public final void setBillScenarioId(String billScenarioId) {
            this.billScenarioId = billScenarioId;
        }

        @Override
        public final Builder billScenarioId(String billScenarioId) {
            this.billScenarioId = billScenarioId;
            return this;
        }

        public final List<BatchUpdateBillScenarioCommitmentModificationEntry.Builder> getCommitmentModifications() {
            List<BatchUpdateBillScenarioCommitmentModificationEntry.Builder> result = BatchUpdateBillScenarioCommitmentModificationEntriesCopier.copyToBuilder(this.commitmentModifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCommitmentModifications(Collection<BatchUpdateBillScenarioCommitmentModificationEntry.BuilderImpl> commitmentModifications) {
            this.commitmentModifications = BatchUpdateBillScenarioCommitmentModificationEntriesCopier.copyFromBuilder(commitmentModifications);
        }

        @Override
        public final Builder commitmentModifications(Collection<BatchUpdateBillScenarioCommitmentModificationEntry> commitmentModifications) {
            this.commitmentModifications = BatchUpdateBillScenarioCommitmentModificationEntriesCopier.copy(commitmentModifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commitmentModifications(BatchUpdateBillScenarioCommitmentModificationEntry ... commitmentModifications) {
            this.commitmentModifications(Arrays.asList(commitmentModifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commitmentModifications(Consumer<BatchUpdateBillScenarioCommitmentModificationEntry.Builder> ... commitmentModifications) {
            this.commitmentModifications(Stream.of(commitmentModifications).map(c -> (BatchUpdateBillScenarioCommitmentModificationEntry)((BatchUpdateBillScenarioCommitmentModificationEntry.Builder)BatchUpdateBillScenarioCommitmentModificationEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateBillScenarioCommitmentModificationRequest build() {
            return new BatchUpdateBillScenarioCommitmentModificationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BcmPricingCalculatorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateBillScenarioCommitmentModificationRequest> {
        public Builder billScenarioId(String var1);

        public Builder commitmentModifications(Collection<BatchUpdateBillScenarioCommitmentModificationEntry> var1);

        public Builder commitmentModifications(BatchUpdateBillScenarioCommitmentModificationEntry ... var1);

        public Builder commitmentModifications(Consumer<BatchUpdateBillScenarioCommitmentModificationEntry.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

