/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdataexports.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bcmdataexports.model.BcmDataExportsRequest;
import software.amazon.awssdk.services.bcmdataexports.model.Export;
import software.amazon.awssdk.services.bcmdataexports.model.ResourceTag;
import software.amazon.awssdk.services.bcmdataexports.model.ResourceTagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateExportRequest
extends BcmDataExportsRequest
implements ToCopyableBuilder<Builder, CreateExportRequest> {
    private static final SdkField<Export> EXPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Export").getter(CreateExportRequest.getter(CreateExportRequest::export)).setter(CreateExportRequest.setter(Builder::export)).constructor(Export::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Export").build()}).build();
    private static final SdkField<List<ResourceTag>> RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTags").getter(CreateExportRequest.getter(CreateExportRequest::resourceTags)).setter(CreateExportRequest.setter(Builder::resourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_FIELD, RESOURCE_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateExportRequest.memberNameToFieldInitializer();
    private final Export export;
    private final List<ResourceTag> resourceTags;

    private CreateExportRequest(BuilderImpl builder) {
        super(builder);
        this.export = builder.export;
        this.resourceTags = builder.resourceTags;
    }

    public final Export export() {
        return this.export;
    }

    public final boolean hasResourceTags() {
        return this.resourceTags != null && !(this.resourceTags instanceof SdkAutoConstructList);
    }

    public final List<ResourceTag> resourceTags() {
        return this.resourceTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.export());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTags() ? this.resourceTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExportRequest)) {
            return false;
        }
        CreateExportRequest other = (CreateExportRequest)((Object)obj);
        return Objects.equals(this.export(), other.export()) && this.hasResourceTags() == other.hasResourceTags() && Objects.equals(this.resourceTags(), other.resourceTags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateExportRequest").add("Export", (Object)this.export()).add("ResourceTags", this.hasResourceTags() ? this.resourceTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Export": {
                return Optional.ofNullable(clazz.cast(this.export()));
            }
            case "ResourceTags": {
                return Optional.ofNullable(clazz.cast(this.resourceTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Export", EXPORT_FIELD);
        map.put("ResourceTags", RESOURCE_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateExportRequest, T> g) {
        return obj -> g.apply((CreateExportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BcmDataExportsRequest.BuilderImpl
    implements Builder {
        private Export export;
        private List<ResourceTag> resourceTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExportRequest model) {
            super(model);
            this.export(model.export);
            this.resourceTags(model.resourceTags);
        }

        public final Export.Builder getExport() {
            return this.export != null ? this.export.toBuilder() : null;
        }

        public final void setExport(Export.BuilderImpl export) {
            this.export = export != null ? export.build() : null;
        }

        @Override
        public final Builder export(Export export) {
            this.export = export;
            return this;
        }

        public final List<ResourceTag.Builder> getResourceTags() {
            List<ResourceTag.Builder> result = ResourceTagListCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTags(Collection<ResourceTag.BuilderImpl> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<ResourceTag> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(ResourceTag ... resourceTags) {
            this.resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<ResourceTag.Builder> ... resourceTags) {
            this.resourceTags(Stream.of(resourceTags).map(c -> (ResourceTag)((ResourceTag.Builder)ResourceTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateExportRequest build() {
            return new CreateExportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BcmDataExportsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateExportRequest> {
        public Builder export(Export var1);

        default public Builder export(Consumer<Export.Builder> export) {
            return this.export((Export)((Export.Builder)Export.builder().applyMutation(export)).build());
        }

        public Builder resourceTags(Collection<ResourceTag> var1);

        public Builder resourceTags(ResourceTag ... var1);

        public Builder resourceTags(Consumer<ResourceTag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

